/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;

public class ProcessHelper {
    private String command = null;
    private Hashtable env = null;
    private File wd = null;
    private Hashtable params = null;
    private InputStream stdin = null;
    private HttpServletResponse response = null;
    private boolean readyToRun = false;
    private int debug = 0;
    private int iClientInputTimeout;

    public ProcessHelper(String command, Hashtable env, File wd, Hashtable params) {
        this.command = command;
        this.env = env;
        this.wd = wd;
        this.params = params;
        this.updateReadyStatus();
    }

    protected void updateReadyStatus() {
        this.readyToRun = this.command != null && this.env != null && this.wd != null && this.params != null && this.response != null;
    }

    public boolean isReady() {
        return this.readyToRun;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
        this.updateReadyStatus();
    }

    public void setInput(InputStream stdin) {
        this.stdin = stdin;
        this.updateReadyStatus();
    }

    private String[] hashToStringArray(Hashtable h) throws NullPointerException {
        Vector<String> v = new Vector<String>();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement().toString();
            v.add(k + "=" + h.get(k));
        }
        Object[] strArr = new String[v.size()];
        v.copyInto(strArr);
        return strArr;
    }

    public void run() throws IOException {
        if (!this.isReady()) {
            throw new IOException(this.getClass().getName() + ": not ready to run.");
        }
        if (this.debug >= 1) {
            this.log("runCGI(envp=[" + this.env + "], command=" + this.command + ")");
        }
        if (this.command.indexOf(File.separator + "." + File.separator) >= 0 || this.command.indexOf(File.separator + "..") >= 0 || this.command.indexOf(".." + File.separator) >= 0) {
            throw new IOException(this.getClass().getName() + "Illegal Character in CGI command " + "path ('.' or '..') detected.  Not " + "running CGI [" + this.command + "].");
        }
        Runtime rt = null;
        BufferedReader commandsStdOut = null;
        BufferedReader commandsStdErr = null;
        BufferedOutputStream commandsStdIn = null;
        Process proc = null;
        byte[] bBuf = new byte[1024];
        char[] cBuf = new char[1024];
        int bufRead = -1;
        Enumeration paramNames = this.params.keys();
        StringBuffer cmdAndArgs = new StringBuffer(this.command);
        if (paramNames != null && paramNames.hasMoreElements()) {
            cmdAndArgs.append(" ");
            while (paramNames.hasMoreElements()) {
                String k = (String)paramNames.nextElement();
                String v = this.params.get(k).toString();
                if (k.indexOf("=") >= 0 || v.indexOf("=") >= 0) continue;
                cmdAndArgs.append(k);
                cmdAndArgs.append("=");
                v = URLEncoder.encode(v);
                cmdAndArgs.append(v);
                cmdAndArgs.append(" ");
            }
        }
        String postIn = this.getPostInput(this.params);
        int contentLength = postIn.length() + System.getProperty("line.separator").length();
        if ("POST".equals(this.env.get("REQUEST_METHOD"))) {
            this.env.put("CONTENT_LENGTH", new Integer(contentLength));
        }
        rt = Runtime.getRuntime();
        proc = rt.exec(cmdAndArgs.toString(), this.hashToStringArray(this.env), this.wd);
        commandsStdIn = new BufferedOutputStream(proc.getOutputStream());
        if (this.debug >= 2) {
            this.log("runCGI stdin=[" + this.stdin + "], qs=" + this.env.get("QUERY_STRING"));
        }
        if ("POST".equals(this.env.get("REQUEST_METHOD"))) {
            if (this.debug >= 2) {
                this.log("runCGI: writing ---------------\n");
                this.log(postIn);
                this.log("runCGI: new content_length=" + contentLength + "---------------\n");
            }
            commandsStdIn.write(postIn.getBytes());
        }
        if (this.stdin != null) {
            if (this.stdin.available() <= 0) {
                if (this.debug >= 2) {
                    this.log("runCGI stdin is NOT available [" + this.stdin.available() + "]");
                }
                try {
                    Thread.sleep(this.iClientInputTimeout);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            if (this.stdin.available() > 0) {
                if (this.debug >= 2) {
                    this.log("runCGI stdin IS available [" + this.stdin.available() + "]");
                }
                bBuf = new byte[1024];
                bufRead = -1;
                try {
                    while ((bufRead = this.stdin.read(bBuf)) != -1) {
                        if (this.debug >= 2) {
                            this.log("runCGI: read [" + bufRead + "] bytes from stdin");
                        }
                        commandsStdIn.write(bBuf, 0, bufRead);
                    }
                    if (this.debug >= 2) {
                        this.log("runCGI: DONE READING from stdin");
                    }
                }
                catch (IOException ioe) {
                    this.log("runCGI: couldn't write all bytes.");
                    ioe.printStackTrace();
                }
            }
        }
        commandsStdIn.flush();
        commandsStdIn.close();
        boolean isRunning = true;
        commandsStdOut = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        commandsStdErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        BufferedWriter servletContainerStdout = null;
        try {
            if (this.response.getOutputStream() != null) {
                servletContainerStdout = new BufferedWriter(new OutputStreamWriter((OutputStream)this.response.getOutputStream()));
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        while (isRunning) {
            try {
                cBuf = new char[1024];
                while ((bufRead = commandsStdErr.read(cBuf)) != -1) {
                    if (servletContainerStdout == null) continue;
                    servletContainerStdout.write(cBuf, 0, bufRead);
                }
                String line = null;
                while ((line = commandsStdOut.readLine()) != null && !"".equals(line)) {
                    if (this.debug >= 2) {
                        this.log("runCGI: addHeader(\"" + line + "\")");
                    }
                    if (line.startsWith("HTTP")) continue;
                    this.response.addHeader(line.substring(0, line.indexOf(":")).trim(), line.substring(line.indexOf(":") + 1).trim());
                }
                cBuf = new char[1024];
                while ((bufRead = commandsStdOut.read(cBuf)) != -1) {
                    if (servletContainerStdout == null) continue;
                    if (this.debug >= 4) {
                        this.log("runCGI: write(\"" + cBuf.toString() + "\")");
                    }
                    servletContainerStdout.write(cBuf, 0, bufRead);
                }
                if (servletContainerStdout != null) {
                    servletContainerStdout.flush();
                }
                proc.exitValue();
                isRunning = false;
            }
            catch (IllegalThreadStateException e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignored) {}
            }
        }
    }

    protected String getPostInput(Hashtable params) {
        String lineSeparator = System.getProperty("line.separator");
        Enumeration paramNames = params.keys();
        StringBuffer postInput = new StringBuffer("");
        StringBuffer qs = new StringBuffer("");
        if (paramNames != null && paramNames.hasMoreElements()) {
            while (paramNames.hasMoreElements()) {
                String k = (String)paramNames.nextElement();
                String v = params.get(k).toString();
                if (k.indexOf("=") >= 0 || v.indexOf("=") >= 0) continue;
                postInput.append(k);
                qs.append(k);
                postInput.append("=");
                qs.append("=");
                postInput.append(v);
                qs.append(v);
                postInput.append(lineSeparator);
                qs.append("&");
            }
        }
        qs.append(lineSeparator);
        return qs.append(postInput).toString();
    }

    private void log(String s) {
        System.out.println(s);
    }

    public int getIClientInputTimeout() {
        return this.iClientInputTimeout;
    }

    public void setIClientInputTimeout(int iClientInputTimeout) {
        this.iClientInputTimeout = iClientInputTimeout;
    }
}

