/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XItemEventBroadcaster;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindowListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexContainer;
import com.sun.star.frame.TerminationVetoException;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.XCompletion;
import com.sun.star.wizards.ui.event.CommonListener;
import com.sun.star.wizards.ui.event.MethodInvocation;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public abstract class WizardDialog
extends UnoDialog2
implements VetoableChangeListener,
XTerminateListener,
XCompletion {
    private static final String NEXT_ACTION_PERFORMED = "gotoNextAvailableStep";
    private static final String BACK_ACTION_PERFORMED = "gotoPreviousAvailableStep";
    private static final String FINISH_ACTION_PERFORMED = "finishWizard_1";
    private static final String CANCEL_ACTION_PERFORMED = "cancelWizard_1";
    private static final String HELP_ACTION_PERFORMED = "callHelp";
    public VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private String[] sRightPaneHeaders;
    private int iButtonWidth = 50;
    private int nNewStep = 1;
    private int nOldStep = 1;
    private int nMaxStep = 1;
    protected XItemListener RoadmapItemListener;
    protected XControl xRoadmapControl;
    XItemEventBroadcaster xRoadmapBroadcaster;
    String[] sRMItemLabels;
    private Object oRoadmap;
    private XSingleServiceFactory xSSFRoadmap;
    public XIndexContainer xIndexContRoadmap;
    private Resource oWizardResource;
    public String sMsgEndAutopilot;
    private int hid;
    private boolean bTerminateListenermustberemoved = true;

    public WizardDialog(XMultiServiceFactory xMultiServiceFactory, int n) {
        super(xMultiServiceFactory);
        this.hid = n;
        this.oWizardResource = new Resource(xMultiServiceFactory, "Common", "dbw");
        this.sMsgEndAutopilot = this.oWizardResource.getResText(1033);
    }

    public Resource getResource() {
        return this.oWizardResource;
    }

    public void activate() {
        try {
            XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface(XTopWindow.class, (Object)this.xWindow);
            if (xTopWindow != null) {
                xTopWindow.toFront();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxStep(int n) {
        this.nMaxStep = n;
    }

    public int getMaxStep() {
        return this.nMaxStep;
    }

    public void setOldStep(int n) {
        this.nOldStep = n;
    }

    public int getOldStep() {
        return this.nOldStep;
    }

    public void setNewStep(int n) {
        this.nNewStep = n;
    }

    public int getNewStep() {
        return this.nNewStep;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        this.nNewStep = this.nOldStep;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        try {
            this.nNewStep = itemEvent.ItemId;
            this.nOldStep = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.xDialogModel, "Step"));
            if (this.nNewStep != this.nOldStep) {
                this.switchToStep();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.out);
        }
    }

    public void setRoadmapInteractive(boolean bl) {
        Helper.setUnoPropertyValue(this.oRoadmap, "Activated", new Boolean(bl));
    }

    public void setRoadmapComplete(boolean bl) {
        Helper.setUnoPropertyValue(this.oRoadmap, "Complete", new Boolean(bl));
    }

    public boolean isRoadmapComplete() {
        try {
            return AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(this.oRoadmap, "Complete"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.out);
            return false;
        }
    }

    public void setCurrentRoadmapItemID(short s) {
        int n;
        if (this.oRoadmap != null && (n = this.getCurrentRoadmapItemID()) != s) {
            Helper.setUnoPropertyValue(this.oRoadmap, "CurrentItemID", new Short(s));
        }
    }

    public int getCurrentRoadmapItemID() {
        try {
            return AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.oRoadmap, "CurrentItemID"));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
            return -1;
        }
    }

    public void addRoadmap() {
        try {
            int n = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, "Height");
            this.oRoadmap = this.insertControlModel("com.sun.star.awt.UnoControlRoadmapModel", "rdmNavi", new String[]{"Height", "PositionX", "PositionY", "Step", "TabIndex", "Tabstop", "Width"}, new Object[]{new Integer(n - 26), new Integer(0), new Integer(0), new Integer(0), new Short(0), Boolean.TRUE, new Integer(85)});
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oRoadmap);
            xPropertySet.setPropertyValue("Name", (Object)"rdmNavi");
            this.xSSFRoadmap = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)this.oRoadmap);
            this.xIndexContRoadmap = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)this.oRoadmap);
            MethodInvocation methodInvocation = new MethodInvocation("itemStateChanged", (Object)this, ItemEvent.class);
            this.getGuiEventListener().add("rdmNavi", "ICH", methodInvocation);
            this.xRoadmapControl = this.xDlgContainer.getControl("rdmNavi");
            this.xRoadmapBroadcaster = (XItemEventBroadcaster)UnoRuntime.queryInterface(XItemEventBroadcaster.class, (Object)this.xRoadmapControl);
            this.xRoadmapBroadcaster.addItemListener((XItemListener)this.getGuiEventListener());
            Helper.setUnoPropertyValue(this.oRoadmap, "Text", this.oWizardResource.getResText(516));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Resource.showCommonResourceError(this.xMSF);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void setRMItemLabels(Resource resource, int n) {
        this.sRMItemLabels = resource.getResArray(n, this.nMaxStep);
    }

    public String[] getRMItemLabels() {
        return this.sRMItemLabels;
    }

    public int insertRoadmapItem(int n, boolean bl, int n2, int n3) {
        return this.insertRoadmapItem(n, bl, this.sRMItemLabels[n2], n3);
    }

    public int insertRoadmapItem(int n, boolean bl, String string, int n2) {
        try {
            Object object = this.xSSFRoadmap.createInstance();
            Helper.setUnoPropertyValue(object, "Label", string);
            Helper.setUnoPropertyValue(object, "Enabled", new Boolean(bl));
            Helper.setUnoPropertyValue(object, "ID", new Integer(n2));
            this.xIndexContRoadmap.insertByIndex(n, object);
            int n3 = n + 1;
            return n3;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
            return -1;
        }
    }

    public int getRMItemCount() {
        return this.xIndexContRoadmap.getCount();
    }

    public XInterface getRoadmapItemByID(int n) {
        try {
            for (int i = 0; i < this.xIndexContRoadmap.getCount(); ++i) {
                XInterface xInterface = (XInterface)this.xIndexContRoadmap.getByIndex(i);
                int n2 = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(xInterface, "ID"));
                if (n2 != n) continue;
                return xInterface;
            }
            return null;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public boolean switchToStep(int n, int n2) {
        this.nOldStep = n;
        this.nNewStep = n2;
        return this.switchToStep();
    }

    private boolean switchToStep() {
        this.leaveStep(this.nOldStep, this.nNewStep);
        if (this.nNewStep != this.nOldStep) {
            if (this.nNewStep == this.nMaxStep) {
                this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.FALSE);
                this.setControlProperty("btnWizardFinish", "DefaultButton", Boolean.TRUE);
            } else {
                this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.TRUE);
                this.setControlProperty("btnWizardFinish", "DefaultButton", Boolean.FALSE);
            }
            this.changeToStep(this.nNewStep);
            this.enterStep(this.nOldStep, this.nNewStep);
            return true;
        }
        return false;
    }

    protected abstract void leaveStep(int var1, int var2);

    protected abstract void enterStep(int var1, int var2);

    protected void changeToStep(int n) {
        Helper.setUnoPropertyValue(this.xDialogModel, "Step", new Integer(n));
        this.setCurrentRoadmapItemID((short)n);
        this.enableNextButton(this.getNextAvailableStep() > 0);
        this.enableBackButton(n != 1);
    }

    public boolean iscompleted(int n) {
        return false;
    }

    public boolean ismodified(int n) {
        return false;
    }

    public void setcompleted(int n, boolean bl) {
    }

    public void setmodified(int n, Object object, Object object2) {
    }

    public void drawNaviBar() {
        try {
            short s = 30000;
            Integer n = new Integer(this.iButtonWidth);
            int n2 = 14;
            Integer n3 = new Integer(n2);
            Integer n4 = new Integer(0);
            int n5 = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, "Height");
            int n6 = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, "Width");
            int n7 = 8;
            int n8 = n5 - n2 - 6;
            int n9 = n6 - this.iButtonWidth - 6;
            int n10 = n9 - 6 - this.iButtonWidth;
            int n11 = n10 - 6 - this.iButtonWidth;
            int n12 = n11 - 3 - this.iButtonWidth;
            this.insertControlModel("com.sun.star.awt.UnoControlFixedLineModel", "lnNaviSep", new String[]{"Height", "Orientation", "PositionX", "PositionY", "Step", "Width"}, new Object[]{new Integer(1), new Integer(0), new Integer(0), new Integer(n5 - 26), n4, new Integer(n6)});
            this.insertControlModel("com.sun.star.awt.UnoControlFixedLineModel", "lnRoadSep", new String[]{"Height", "Orientation", "PositionX", "PositionY", "Step", "Width"}, new Object[]{new Integer(n8 - 6), new Integer(1), new Integer(85), new Integer(0), n4, new Integer(1)});
            String[] stringArray = new String[]{"Enabled", "Height", "HelpURL", "Label", "PositionX", "PositionY", "PushButtonType", "Step", "TabIndex", "Width"};
            Helper.setUnoPropertyValue(this.xDialogModel, "HelpURL", "HID:" + this.hid);
            Object[] objectArray = new Object[9];
            objectArray[0] = new Boolean(true);
            objectArray[1] = n3;
            objectArray[2] = this.oWizardResource.getResText(515);
            objectArray[3] = new Integer(n7);
            objectArray[4] = new Integer(n8);
            objectArray[5] = new Short(3);
            objectArray[6] = n4;
            short s2 = s;
            s = (short)(s + 1);
            objectArray[7] = new Short(s2);
            objectArray[8] = n;
            this.insertButton("btnWizardHelp", HELP_ACTION_PERFORMED, new String[]{"Enabled", "Height", "Label", "PositionX", "PositionY", "PushButtonType", "Step", "TabIndex", "Width"}, objectArray);
            Object[] objectArray2 = new Object[10];
            objectArray2[0] = new Boolean(false);
            objectArray2[1] = n3;
            objectArray2[2] = "HID:" + (this.hid + 2);
            objectArray2[3] = this.oWizardResource.getResText(513);
            objectArray2[4] = new Integer(n12);
            objectArray2[5] = new Integer(n8);
            objectArray2[6] = new Short(0);
            objectArray2[7] = n4;
            short s3 = s;
            s = (short)(s + 1);
            objectArray2[8] = new Short(s3);
            objectArray2[9] = n;
            this.insertButton("btnWizardBack", BACK_ACTION_PERFORMED, stringArray, objectArray2);
            Object[] objectArray3 = new Object[10];
            objectArray3[0] = new Boolean(true);
            objectArray3[1] = n3;
            objectArray3[2] = "HID:" + (this.hid + 3);
            objectArray3[3] = this.oWizardResource.getResText(514);
            objectArray3[4] = new Integer(n11);
            objectArray3[5] = new Integer(n8);
            objectArray3[6] = new Short(0);
            objectArray3[7] = n4;
            short s4 = s;
            s = (short)(s + 1);
            objectArray3[8] = new Short(s4);
            objectArray3[9] = n;
            this.insertButton("btnWizardNext", NEXT_ACTION_PERFORMED, stringArray, objectArray3);
            Object[] objectArray4 = new Object[10];
            objectArray4[0] = new Boolean(true);
            objectArray4[1] = n3;
            objectArray4[2] = "HID:" + (this.hid + 4);
            objectArray4[3] = this.oWizardResource.getResText(512);
            objectArray4[4] = new Integer(n10);
            objectArray4[5] = new Integer(n8);
            objectArray4[6] = new Short(0);
            objectArray4[7] = n4;
            short s5 = s;
            s = (short)(s + 1);
            objectArray4[8] = new Short(s5);
            objectArray4[9] = n;
            this.insertButton("btnWizardFinish", FINISH_ACTION_PERFORMED, stringArray, objectArray4);
            Object[] objectArray5 = new Object[10];
            objectArray5[0] = new Boolean(true);
            objectArray5[1] = n3;
            objectArray5[2] = "HID:" + (this.hid + 5);
            objectArray5[3] = this.oWizardResource.getResText(511);
            objectArray5[4] = new Integer(n9);
            objectArray5[5] = new Integer(n8);
            objectArray5[6] = new Short(0);
            objectArray5[7] = n4;
            short s6 = s;
            s = (short)(s + 1);
            objectArray5[8] = new Short(s6);
            objectArray5[9] = n;
            this.insertButton("btnWizardCancel", CANCEL_ACTION_PERFORMED, stringArray, objectArray5);
            this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.TRUE);
            MethodInvocation methodInvocation = new MethodInvocation("windowHidden", (Object)this);
            this.xWindow.addWindowListener((XWindowListener)((CommonListener)this.getGuiEventListener()));
            String string = (String)Helper.getUnoPropertyValue(this.xDialogModel, "Name");
            this.getGuiEventListener().add(string, "APR", methodInvocation);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    protected void insertRoadMapItems(String[] stringArray, int[] nArray, boolean[] blArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.insertRoadmapItem(i, blArray[i], stringArray[i], nArray[i]);
        }
    }

    public void setStepEnabled(int n, boolean bl, boolean bl2) {
        this.setStepEnabled(n, bl);
        if (this.getNextAvailableStep() > 0) {
            this.enableNextButton(bl);
        }
    }

    public void enableNavigationButtons(boolean bl, boolean bl2, boolean bl3) {
        this.enableBackButton(bl);
        this.enableNextButton(bl2);
        this.enableFinishButton(bl3);
    }

    public void enableBackButton(boolean bl) {
        this.setControlProperty("btnWizardBack", "Enabled", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void enableNextButton(boolean bl) {
        this.setControlProperty("btnWizardNext", "Enabled", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void enableFinishButton(boolean bl) {
        this.setControlProperty("btnWizardFinish", "Enabled", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStepEnabled(int n, boolean bl) {
        XInterface xInterface = this.getRoadmapItemByID(n);
        if (xInterface != null) {
            Helper.setUnoPropertyValue(xInterface, "Enabled", new Boolean(bl));
        }
    }

    public void enablefromStep(int n, boolean bl) {
        if (n <= this.nMaxStep) {
            for (int i = n; i <= this.nMaxStep; ++i) {
                this.setStepEnabled(i, bl);
            }
            this.enableFinishButton(bl);
            if (!bl) {
                this.enableNextButton(n > this.getCurrentStep() + 1);
            } else {
                this.enableNextButton(this.getCurrentStep() != this.nMaxStep);
            }
        }
    }

    public boolean isStepEnabled(int n) {
        try {
            XInterface xInterface = this.getRoadmapItemByID(n);
            if (xInterface == null) {
                return false;
            }
            boolean bl = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(xInterface, "Enabled"));
            return bl;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public synchronized void gotoPreviousAvailableStep() {
        if (this.nNewStep > 1) {
            boolean bl;
            this.nOldStep = this.nNewStep--;
            while (this.nNewStep > 0 && !(bl = this.isStepEnabled(this.nNewStep))) {
                --this.nNewStep;
            }
            if (this.nNewStep == 0) {
                this.nNewStep = this.nOldStep;
            }
            this.switchToStep();
        }
    }

    protected int getNextAvailableStep() {
        if (this.isRoadmapComplete()) {
            for (int i = this.nNewStep + 1; i <= this.nMaxStep; ++i) {
                if (!this.isStepEnabled(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void gotoNextAvailableStep() {
        this.nOldStep = this.nNewStep;
        this.nNewStep = this.getNextAvailableStep();
        if (this.nNewStep > -1) {
            this.switchToStep();
        }
    }

    public abstract void finishWizard();

    public void finishWizard_1() {
        this.enableFinishButton(false);
        this.finishWizard();
        this.removeTerminateListener();
    }

    public int getMaximalStep() {
        return this.nMaxStep;
    }

    public int getCurrentStep() {
        try {
            return AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.MSFDialogModel, "Step"));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
            return -1;
        }
    }

    public void setCurrentStep(int n) {
        this.nNewStep = n;
        this.changeToStep(this.nNewStep);
    }

    public void setRightPaneHeaders(Resource resource, int n, int n2) {
        String[] stringArray = resource.getResArray(n, n2);
        this.setRightPaneHeaders(stringArray);
    }

    public void setRightPaneHeaders(String[] stringArray) {
        this.nMaxStep = stringArray.length;
        this.sRightPaneHeaders = stringArray;
        FontDescriptor fontDescriptor = new FontDescriptor();
        fontDescriptor.Weight = 150.0f;
        for (int i = 0; i < this.sRightPaneHeaders.length; ++i) {
            this.insertLabel("lblQueryTitle" + String.valueOf(i), new String[]{"FontDescriptor", "Height", "Label", "MultiLine", "PositionX", "PositionY", "Step", "TabIndex", "Width"}, new Object[]{fontDescriptor, new Integer(16), this.sRightPaneHeaders[i], Boolean.TRUE, new Integer(91), new Integer(8), new Integer(i + 1), new Short(12), new Integer(212)});
        }
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    public void callHelp() {
    }

    public void removeTerminateListener() {
        if (this.bTerminateListenermustberemoved) {
            Desktop.getDesktop(this.xMSF).removeTerminateListener((XTerminateListener)this);
            this.bTerminateListenermustberemoved = false;
        }
    }

    public void cancelWizard_1() {
        this.cancelWizard();
        this.removeTerminateListener();
    }

    public void windowHidden() {
        this.cancelWizard_1();
    }

    public void notifyTermination(EventObject eventObject) {
        this.cancelWizard_1();
    }

    public void queryTermination(EventObject eventObject) throws TerminationVetoException {
        this.activate();
        throw new TerminationVetoException();
    }

    public void disposing(EventObject eventObject) {
        this.cancelWizard_1();
    }
}

