/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class JTabbedPaneSupport
extends AbstractLayoutSupport {
    private int selectedTab = -1;
    private static Method addTabMethod1;
    private static Method addTabMethod2;
    private static Method addTabMethod3;

    @Override
    public Class getSupportedClass() {
        return JTabbedPane.class;
    }

    @Override
    public void removeComponent(int index) {
        super.removeComponent(index);
        if (this.selectedTab >= this.getComponentCount()) {
            this.selectedTab = this.getComponentCount() - 1;
        }
    }

    @Override
    public void processMouseClick(Point p, Container container, Container containerDelegate) {
        if (!(container instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabbedPane = (JTabbedPane)container;
        int n = tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            Rectangle rect = tabbedPane.getBoundsAt(i);
            if (rect == null || !rect.contains(p)) continue;
            this.selectedTab = i;
            tabbedPane.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void selectComponent(int index) {
        this.selectedTab = index;
    }

    @Override
    public void arrangeContainer(Container container, Container containerDelegate) {
        if (!(container instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabbedPane = (JTabbedPane)container;
        if (this.selectedTab >= 0) {
            if (tabbedPane.getTabCount() > this.selectedTab) {
                tabbedPane.setSelectedIndex(this.selectedTab);
                Component comp = tabbedPane.getSelectedComponent();
                if (comp != null) {
                    comp.setVisible(true);
                }
                tabbedPane.repaint();
            }
        } else if (tabbedPane.getTabCount() > 0) {
            tabbedPane.getComponentAt(0).setVisible(true);
        }
    }

    @Override
    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (!(container instanceof JTabbedPane)) {
            return -1;
        }
        return ((JTabbedPane)container).getTabCount();
    }

    @Override
    public String getAssistantContext() {
        return "tabbedPaneLayout";
    }

    @Override
    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        if (!(container instanceof JTabbedPane)) {
            return false;
        }
        JTabbedPane tabbedPane = (JTabbedPane)container;
        if (tabbedPane.getTabCount() == 0 || component == tabbedPane.getComponentAt(0)) {
            Dimension sz = container.getSize();
            Insets insets = container.getInsets();
            sz.width -= insets.left + insets.right;
            sz.height -= insets.top + insets.bottom;
            g.drawRect(0, 0, sz.width, sz.height);
        } else {
            Rectangle rect = tabbedPane.getComponentAt(0).getBounds();
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
        return true;
    }

    @Override
    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        if (!(container instanceof JTabbedPane)) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            LayoutConstraints constraints = this.getConstraints(i + index);
            if (!(constraints instanceof TabConstraints)) continue;
            JTabbedPane tabbedPane = (JTabbedPane)container;
            try {
                Object title = ((FormProperty)constraints.getProperties()[0]).getRealValue();
                Object icon = ((FormProperty)constraints.getProperties()[1]).getRealValue();
                Object tooltip = ((FormProperty)constraints.getProperties()[2]).getRealValue();
                tabbedPane.insertTab(title instanceof String ? (String)title : null, icon instanceof Icon ? (Icon)icon : null, components[i], tooltip instanceof String ? (String)tooltip : null, index + i);
                continue;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    @Override
    protected CodeExpression readComponentCode(CodeStatement statement, CodeGroup componentCode) {
        int[] constrPropsIndices;
        CodeExpression compExp;
        CodeExpression[] params = statement.getStatementParameters();
        Object connectingObject = statement.getMetaObject();
        if (JTabbedPaneSupport.getAddTabMethod1().equals(connectingObject)) {
            compExp = params[2];
            constrPropsIndices = new int[]{0, 1, -1, 2};
        } else if (JTabbedPaneSupport.getAddTabMethod2().equals(connectingObject)) {
            compExp = params[2];
            constrPropsIndices = new int[]{0, 1, -1};
        } else if (JTabbedPaneSupport.getAddTabMethod3().equals(connectingObject)) {
            compExp = params[1];
            constrPropsIndices = new int[]{0, -1};
        } else {
            return null;
        }
        TabConstraints constr = new TabConstraints("tab");
        Node.Property[] props = constr.getProperties();
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == compExp) continue;
            Node.Property prop = props[constrPropsIndices[i]];
            Object comp = compExp.getOrigin().getMetaObject();
            if (prop instanceof FormProperty && comp instanceof RADComponent) {
                FormProperty fprop = (FormProperty)prop;
                RADComponent metacomp = (RADComponent)comp;
                fprop.setPropertyContext(new FormPropertyContext.Component(metacomp));
            }
            FormCodeSupport.readPropertyExpression(params[i], prop, false);
        }
        this.getConstraintsList().add(constr);
        componentCode.addStatement(statement);
        constr.createComponentCode(componentCode, this.getLayoutContext().getContainerCodeExpression(), compExp, false);
        return compExp;
    }

    @Override
    protected void createComponentCode(CodeGroup componentCode, CodeExpression componentExpression, int index) {
        LayoutConstraints constr = this.getConstraints(index);
        if (!(constr instanceof TabConstraints)) {
            return;
        }
        ((TabConstraints)constr).createComponentCode(componentCode, this.getLayoutContext().getContainerCodeExpression(), componentExpression, true);
    }

    @Override
    protected LayoutConstraints createDefaultConstraints() {
        return new TabConstraints("tab" + this.getComponentCount());
    }

    private static Method getAddTabMethod1() {
        if (addTabMethod1 == null) {
            try {
                addTabMethod1 = JTabbedPane.class.getMethod("addTab", String.class, Icon.class, Component.class, String.class);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return addTabMethod1;
    }

    private static Method getAddTabMethod2() {
        if (addTabMethod2 == null) {
            try {
                addTabMethod2 = JTabbedPane.class.getMethod("addTab", String.class, Icon.class, Component.class);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return addTabMethod2;
    }

    private static Method getAddTabMethod3() {
        if (addTabMethod3 == null) {
            try {
                addTabMethod3 = JTabbedPane.class.getMethod("addTab", String.class, Component.class);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return addTabMethod3;
    }

    public static class TabConstraints
    implements LayoutConstraints {
        private String title;
        private Icon icon;
        private String toolTip;
        private FormProperty[] properties;
        private CodeExpression containerExpression;
        private CodeExpression componentExpression;
        private CodeGroup componentCode;
        private CodeExpression[] propertyExpressions;

        public TabConstraints(String title) {
            this.title = title;
        }

        public TabConstraints(String title, Icon icon, String toolTip) {
            this.title = title;
            this.icon = icon;
            this.toolTip = toolTip;
        }

        public String getTitle() {
            return this.title;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        @Override
        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.properties = new FormProperty[]{new FormProperty("TabConstraints.tabTitle", String.class, JTabbedPaneSupport.getBundle().getString("PROP_tabTitle"), JTabbedPaneSupport.getBundle().getString("HINT_tabTitle")){

                    @Override
                    public Object getTargetValue() {
                        return TabConstraints.this.title;
                    }

                    @Override
                    public void setTargetValue(Object value) {
                        TabConstraints.this.title = (String)value;
                    }

                    @Override
                    protected Object getRealValue(Object value) {
                        Object realValue = super.getRealValue(value);
                        if (realValue == FormDesignValue.IGNORED_VALUE) {
                            realValue = ((FormDesignValue)value).getDescription();
                        }
                        return realValue;
                    }

                    @Override
                    protected void propertyValueChanged(Object old, Object current) {
                        if (this.isChangeFiring()) {
                            TabConstraints.this.updateCode();
                        }
                        super.propertyValueChanged(old, current);
                    }
                }, new FormProperty("TabConstraints.tabIcon", Icon.class, JTabbedPaneSupport.getBundle().getString("PROP_tabIcon"), JTabbedPaneSupport.getBundle().getString("HINT_tabIcon")){

                    @Override
                    public Object getTargetValue() {
                        return TabConstraints.this.icon;
                    }

                    @Override
                    public void setTargetValue(Object value) {
                        TabConstraints.this.icon = (Icon)value;
                    }

                    @Override
                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    @Override
                    public Object getDefaultValue() {
                        return null;
                    }

                    @Override
                    protected void propertyValueChanged(Object old, Object current) {
                        if (this.isChangeFiring()) {
                            TabConstraints.this.updateCode();
                        }
                        super.propertyValueChanged(old, current);
                    }
                }, new FormProperty("TabConstraints.tabToolTip", String.class, JTabbedPaneSupport.getBundle().getString("PROP_tabToolTip"), JTabbedPaneSupport.getBundle().getString("HINT_tabToolTip")){

                    @Override
                    public Object getTargetValue() {
                        return TabConstraints.this.toolTip;
                    }

                    @Override
                    public void setTargetValue(Object value) {
                        TabConstraints.this.toolTip = (String)value;
                    }

                    @Override
                    protected Object getRealValue(Object value) {
                        Object realValue = super.getRealValue(value);
                        if (realValue == FormDesignValue.IGNORED_VALUE) {
                            realValue = ((FormDesignValue)value).getDescription();
                        }
                        return realValue;
                    }

                    @Override
                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    @Override
                    public Object getDefaultValue() {
                        return null;
                    }

                    @Override
                    protected void propertyValueChanged(Object old, Object current) {
                        if (this.isChangeFiring()) {
                            TabConstraints.this.updateCode();
                        }
                        super.propertyValueChanged(old, current);
                    }
                }};
                this.properties[0].setChanged(true);
            }
            return this.properties;
        }

        @Override
        public Object getConstraintsObject() {
            return this.title;
        }

        @Override
        public LayoutConstraints cloneConstraints() {
            TabConstraints constr = new TabConstraints(this.title);
            FormUtils.copyProperties(this.getProperties(), constr.getProperties(), 3);
            return constr;
        }

        private void createComponentCode(CodeGroup compCode, CodeExpression contExp, CodeExpression compExp, boolean update) {
            this.componentCode = compCode;
            this.containerExpression = contExp;
            this.componentExpression = compExp;
            this.propertyExpressions = null;
            if (update) {
                this.updateCode();
            }
        }

        private void updateCode() {
            CodeExpression[] params;
            Method addTabMethod;
            if (this.componentCode == null) {
                return;
            }
            CodeStructure.removeStatements(this.componentCode.getStatementsIterator());
            this.componentCode.removeAll();
            this.getProperties();
            if (this.properties[2].isChanged()) {
                addTabMethod = JTabbedPaneSupport.getAddTabMethod1();
                params = new CodeExpression[]{this.getPropertyExpression(0), this.getPropertyExpression(1), this.componentExpression, this.getPropertyExpression(2)};
            } else if (this.properties[1].isChanged()) {
                addTabMethod = JTabbedPaneSupport.getAddTabMethod2();
                params = new CodeExpression[]{this.getPropertyExpression(0), this.getPropertyExpression(1), this.componentExpression};
            } else {
                addTabMethod = JTabbedPaneSupport.getAddTabMethod3();
                params = new CodeExpression[]{this.getPropertyExpression(0), this.componentExpression};
            }
            CodeStatement addTabStatement = CodeStructure.createStatement(this.containerExpression, addTabMethod, params);
            this.componentCode.addStatement(addTabStatement);
        }

        private CodeExpression getPropertyExpression(int index) {
            if (this.propertyExpressions == null) {
                this.propertyExpressions = new CodeExpression[this.properties.length];
                for (int i = 0; i < this.properties.length; ++i) {
                    this.propertyExpressions[i] = this.componentExpression.getCodeStructure().createExpression(FormCodeSupport.createOrigin(this.properties[i]));
                }
            }
            return this.propertyExpressions[index];
        }
    }
}

