/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceTaskFactory;
import org.netbeans.napi.gsfret.source.support.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class LookupBasedSourceTaskFactory
extends SourceTaskFactory {
    private Lookup.Result<FileObject> fileObjectResult;
    private Lookup.Result<DataObject> dataObjectResult;
    private Lookup.Result<Node> nodeResult;
    private List<FileObject> currentFiles = Collections.emptyList();
    private LookupListener listener = new LookupListenerImpl();

    public LookupBasedSourceTaskFactory(Phase phase, Source.Priority priority) {
        super(phase, priority);
    }

    protected final synchronized void setLookup(Lookup lookup) {
        if (this.fileObjectResult != null) {
            this.fileObjectResult.removeLookupListener(this.listener);
        }
        if (this.dataObjectResult != null) {
            this.dataObjectResult.removeLookupListener(this.listener);
        }
        if (this.nodeResult != null) {
            this.nodeResult.removeLookupListener(this.listener);
        }
        this.fileObjectResult = lookup.lookupResult(FileObject.class);
        this.dataObjectResult = lookup.lookupResult(DataObject.class);
        this.nodeResult = lookup.lookupResult(Node.class);
        this.fileObjectResult.addLookupListener(this.listener);
        this.dataObjectResult.addLookupListener(this.listener);
        this.nodeResult.addLookupListener(this.listener);
        this.updateCurrentFiles();
        this.fileObjectsChanged();
    }

    private synchronized void updateCurrentFiles() {
        HashSet<FileObject> newCurrentFiles = new HashSet<FileObject>();
        newCurrentFiles.addAll(this.fileObjectResult.allInstances());
        for (DataObject d : this.dataObjectResult.allInstances()) {
            newCurrentFiles.add(d.getPrimaryFile());
        }
        for (Node n : this.nodeResult.allInstances()) {
            newCurrentFiles.addAll(n.getLookup().lookupAll(FileObject.class));
            for (DataObject d : n.getLookup().lookupAll(DataObject.class)) {
                newCurrentFiles.add(d.getPrimaryFile());
            }
        }
        List<FileObject> newCurrentFilesFiltered = OpenedEditors.filterSupportedMIMETypes(new LinkedList<FileObject>(newCurrentFiles), new String[0]);
        if (!((Object)this.currentFiles).equals(newCurrentFilesFiltered)) {
            this.currentFiles = newCurrentFilesFiltered;
            this.lookupContentChanged();
        }
    }

    public synchronized List<FileObject> getFileObjects() {
        return this.currentFiles;
    }

    protected void lookupContentChanged() {
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        public void resultChanged(LookupEvent ev) {
            LookupBasedSourceTaskFactory.this.updateCurrentFiles();
            LookupBasedSourceTaskFactory.this.fileObjectsChanged();
        }
    }
}

