/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class FileInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOTVERSIONED_NOTMANAGED = 1;
    public static final int STATUS_NOTVERSIONED_EXCLUDED = 2;
    public static final int STATUS_NOTVERSIONED_NEWLOCALLY = 4;
    public static final int STATUS_VERSIONED_UPTODATE = 8;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY = 16;
    public static final int STATUS_VERSIONED_MODIFIEDINREPOSITORY = 32;
    public static final int STATUS_VERSIONED_CONFLICT_CONTENT = 64;
    public static final int STATUS_VERSIONED_MERGE = 128;
    public static final int STATUS_VERSIONED_REMOVEDLOCALLY = 256;
    public static final int STATUS_VERSIONED_NEWINREPOSITORY = 512;
    public static final int STATUS_VERSIONED_REMOVEDINREPOSITORY = 1024;
    public static final int STATUS_VERSIONED_DELETEDLOCALLY = 2048;
    public static final int STATUS_VERSIONED_ADDEDLOCALLY = 4096;
    public static final int STATUS_LOCKED = 8192;
    public static final int STATUS_VERSIONED_CONFLICT_TREE = 16384;
    public static final int STATUS_VERSIONED_CONFLICT = 16448;
    public static final int STATUS_ALL = -1;
    public static final int STATUS_MANAGED = -2;
    public static final int STATUS_VERSIONED = 24056;
    public static final int STATUS_IN_REPOSITORY = 20472;
    public static final int STATUS_LOCAL_CHANGE = 22996;
    public static final int STATUS_REVERTIBLE_CHANGE = 22992;
    public static final int STATUS_REMOTE_CHANGE = 1696;
    private final int status;
    private final int propStatus;
    private transient ISVNStatus entry;
    private final boolean isDirectory;
    private static final String STATUS_UNKNOWN_EXT = "W";
    private static final String STATUS_NOTVERSIONED_NOTMANAGED_EXT = "Z";
    private static final String STATUS_NOTVERSIONED_EXCLUDED_EXT = "I";
    private static final String STATUS_NOTVERSIONED_NEWLOCALLY_EXT = "?";
    private static final String STATUS_VERSIONED_UPTODATE_EXT = "S";
    private static final String STATUS_VERSIONED_MODIFIEDLOCALLY_EXT = "M";
    private static final String STATUS_VERSIONED_MODIFIEDINREPOSITORY_EXT = "G";
    private static final String STATUS_VERSIONED_CONFLICT_EXT = "C";
    private static final String STATUS_VERSIONED_MERGE_EXT = "P";
    private static final String STATUS_VERSIONED_REMOVEDLOCALLY_EXT = "R";
    private static final String STATUS_VERSIONED_NEWINREPOSITORY_EXT = "N";
    private static final String STATUS_VERSIONED_REMOVEDINREPOSITORY_EXT = "D";
    private static final String STATUS_VERSIONED_DELETEDLOCALLY_EXT = "E";
    private static final String STATUS_VERSIONED_ADDEDLOCALLY_EXT = "A";

    public FileInformation() {
        this.status = 0;
        this.propStatus = 0;
        this.isDirectory = false;
    }

    private FileInformation(int status, int propStatus, ISVNStatus entry, boolean isDirectory) {
        this.status = status;
        this.propStatus = propStatus;
        this.entry = entry;
        this.isDirectory = isDirectory;
    }

    FileInformation(int status, ISVNStatus entry) {
        this(status, 0, entry, entry.getNodeKind() == SVNNodeKind.DIR);
    }

    FileInformation(int status, boolean isDirectory) {
        this(status, 0, null, isDirectory);
    }

    FileInformation(int status, int propStatus, boolean isDirectory) {
        this(status, propStatus, null, isDirectory);
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public ISVNStatus getEntry(File file) {
        if (this.entry == null && file != null) {
            this.readEntry(file);
        }
        return this.entry;
    }

    private void readEntry(File file) {
        block2: {
            try {
                this.entry = Subversion.getInstance().getClient(true).getSingleStatus(file);
            }
            catch (SVNClientException e) {
                if (SvnClientExceptionHandler.isTooOldClientForWC(e.getMessage())) break block2;
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
    }

    public String getStatusText() {
        return this.getStatusText(-1);
    }

    public String getStatusText(int displayStatuses) {
        int status = this.status & displayStatuses;
        ResourceBundle loc = NbBundle.getBundle(FileInformation.class);
        if (status == 0) {
            return loc.getString("CTL_FileInfoStatus_Unknown");
        }
        if (FileInformation.match(status, 2)) {
            return loc.getString("CTL_FileInfoStatus_Excluded");
        }
        if (FileInformation.match(status, 4)) {
            return loc.getString("CTL_FileInfoStatus_NewLocally");
        }
        if (FileInformation.match(status, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                return loc.getString("CTL_FileInfoStatus_AddedLocallyCopied");
            }
            return loc.getString("CTL_FileInfoStatus_AddedLocally");
        }
        if (FileInformation.match(status, 8)) {
            return loc.getString("CTL_FileInfoStatus_UpToDate");
        }
        if (FileInformation.match(status, 16384)) {
            return loc.getString("CTL_FileInfoStatus_TreeConflict");
        }
        if (FileInformation.match(status, 16448)) {
            return loc.getString("CTL_FileInfoStatus_Conflict");
        }
        if (FileInformation.match(status, 128)) {
            return loc.getString("CTL_FileInfoStatus_Merge");
        }
        if (FileInformation.match(status, 2048)) {
            return loc.getString("CTL_FileInfoStatus_DeletedLocally");
        }
        if (FileInformation.match(status, 256)) {
            return loc.getString("CTL_FileInfoStatus_RemovedLocally");
        }
        if (FileInformation.match(status, 16)) {
            return loc.getString("CTL_FileInfoStatus_ModifiedLocally");
        }
        if (FileInformation.match(status, 512)) {
            return loc.getString("CTL_FileInfoStatus_NewInRepository");
        }
        if (FileInformation.match(status, 32)) {
            return loc.getString("CTL_FileInfoStatus_ModifiedInRepository");
        }
        if (FileInformation.match(status, 1024)) {
            return loc.getString("CTL_FileInfoStatus_RemovedInRepository");
        }
        return "";
    }

    public String getShortStatusText() {
        ResourceBundle loc = NbBundle.getBundle(FileInformation.class);
        if (FileInformation.match(this.status, 2)) {
            return loc.getString("CTL_FileInfoStatus_Excluded_Short");
        }
        if (FileInformation.match(this.status, 4)) {
            return loc.getString("CTL_FileInfoStatus_NewLocally_Short");
        }
        if (FileInformation.match(this.status, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                return loc.getString("CTL_FileInfoStatus_AddedLocallyCopied_Short");
            }
            return loc.getString("CTL_FileInfoStatus_AddedLocally_Short");
        }
        if (this.status == 256) {
            return loc.getString("CTL_FileInfoStatus_RemovedLocally_Short");
        }
        if (this.status == 2048) {
            return loc.getString("CTL_FileInfoStatus_DeletedLocally_Short");
        }
        if (FileInformation.match(this.status, 16)) {
            return loc.getString("CTL_FileInfoStatus_ModifiedLocally_Short");
        }
        if (FileInformation.match(this.status, 16384)) {
            return loc.getString("CTL_FileInfoStatus_TreeConflict_Short");
        }
        if (FileInformation.match(this.status, 16448)) {
            return loc.getString("CTL_FileInfoStatus_Conflict_Short");
        }
        return "";
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }

    public String toString() {
        return "Text: " + this.status + " " + this.getStatusText(this.status) + "\nProp: " + this.propStatus + " " + this.getStatusText(this.propStatus);
    }
}

