/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.IndexedConstant;
import org.netbeans.modules.ruby.lexer.Call;

final class RubyConstantCompleter
extends RubyBaseCompleter {
    private final Call call;

    static boolean complete(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive, Call call) {
        RubyConstantCompleter rsc = new RubyConstantCompleter(proposals, request, anchor, caseSensitive, call);
        return rsc.complete();
    }

    private RubyConstantCompleter(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive, Call call) {
        super(proposals, request, anchor, caseSensitive);
        this.call = call;
    }

    private boolean complete() {
        String classFqn;
        if (this.getIndex() == null) {
            return false;
        }
        if (this.call == Call.NONE) {
            return false;
        }
        RubyType type = this.call.getType();
        if (this.call == Call.LOCAL && !type.isKnown() && (classFqn = AstUtilities.getFqnName(this.request.path)).length() > 0) {
            type = RubyType.create(classFqn);
        }
        Set<? extends IndexedConstant> constants = this.getIndex().getConstants(type, this.request.prefix);
        for (IndexedConstant indexedConstant : constants) {
            RubyCompletionItem item = new RubyCompletionItem(indexedConstant, this.anchor, this.request);
            item.setSmart(true);
            this.propose((CompletionProposal)item);
        }
        return true;
    }
}

