/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.elements.MethodElementImpl;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassMemberElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IntroduceHint
extends AbstractRule {
    public String getId() {
        return "Introduce.Hint";
    }

    public String getDescription() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintDispName");
    }

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        BaseDocument doc = context.doc;
        int caretOffset = context.caretOffset;
        int lineBegin = -1;
        int lineEnd = -1;
        lineBegin = caretOffset > 0 ? Utilities.getRowStart((BaseDocument)doc, (int)caretOffset) : -1;
        int n = lineEnd = lineBegin != -1 ? Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset) : -1;
        if (lineBegin != -1 && lineEnd != -1 && caretOffset > lineBegin) {
            Model model = phpParseResult.getModel();
            IntroduceFixVisitor introduceFixVisitor = new IntroduceFixVisitor(model, lineBegin, lineEnd);
            phpParseResult.getProgram().accept(introduceFixVisitor);
            IntroduceFix variableFix = introduceFixVisitor.getIntroduceFix();
            if (variableFix != null) {
                hints.add(new Hint((Rule)this, this.getDisplayName(), context.parserResult.getSnapshot().getSource().getFileObject(), variableFix.getOffsetRange(), Collections.singletonList(variableFix), 500));
            }
        }
    }

    private static boolean isInside(int carret, int left, int right) {
        return carret >= left && carret <= right;
    }

    private static boolean isBefore(int carret, int margin) {
        return carret <= margin;
    }

    private static String getParameters(List<Expression> parameters) {
        StringBuilder paramNames = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            Expression expression = parameters.get(i);
            String varName = null;
            if (expression instanceof Variable) {
                varName = CodeUtils.extractVariableName((Variable)expression);
            }
            if (varName == null) {
                varName = String.format("$param%d", i);
            }
            if (i > 0) {
                paramNames.append(", ");
            }
            paramNames.append(varName);
        }
        return paramNames.toString();
    }

    private static int getOffset(BaseDocument doc, TypeScope typeScope, PhpElementKind kind) throws BadLocationException {
        int offset = -1;
        HashSet<ClassMemberElement> elements = new HashSet<ClassMemberElement>();
        switch (kind) {
            case TYPE_CONSTANT: {
                elements.addAll(typeScope.getDeclaredConstants());
                break;
            }
            case METHOD: 
            case FIELD: {
                elements.addAll(typeScope.getDeclaredConstants());
                if (!(typeScope instanceof ClassScope)) break;
                ClassScope clz = (ClassScope)typeScope;
                elements.addAll(clz.getDeclaredFields());
            }
        }
        for (ModelElement modelElement : elements) {
            if (modelElement.getOffset() <= offset) continue;
            offset = modelElement.getOffset();
        }
        offset = offset != -1 ? Utilities.getRowEnd((BaseDocument)doc, (int)offset) : IntroduceHint.getClassCurlyOpenOffset(doc, typeScope.getOffset());
        return offset;
    }

    private static int getClassCurlyOpenOffset(BaseDocument doc, int offset) throws BadLocationException {
        int retval = offset;
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, retval);
        if (ts != null) {
            ts.move(retval);
            while (ts.moveNext()) {
                Token t = ts.token();
                if (t.id() != PHPTokenId.PHP_CURLY_OPEN) continue;
                retval = ts.offset();
                break;
            }
        }
        return Utilities.getRowEnd((BaseDocument)doc, (int)retval);
    }

    private static PHPCompletionItem.MethodDeclarationItem createMethodDeclarationItem(TypeScope typeScope, MethodInvocation node) {
        String methodName = CodeUtils.extractFunctionName(node.getMethod());
        MethodElement method = MethodElementImpl.createMagicMethod(typeScope, methodName, 0, IntroduceHint.getParameters(node.getMethod().getParameters()));
        return PHPCompletionItem.MethodDeclarationItem.forIntroduceHint(method, null);
    }

    private static PHPCompletionItem.MethodDeclarationItem createMethodDeclarationItem(TypeScope typeScope, StaticMethodInvocation node) {
        String methodName = CodeUtils.extractFunctionName(node.getMethod());
        MethodElement method = MethodElementImpl.createMagicMethod(typeScope, methodName, 8, IntroduceHint.getParameters(node.getMethod().getParameters()));
        return PHPCompletionItem.MethodDeclarationItem.forIntroduceHint(method, null);
    }

    static abstract class IntroduceFix
    implements HintFix {
        BaseDocument doc;
        ASTNode node;

        public IntroduceFix(BaseDocument doc, ASTNode node) {
            this.doc = doc;
            this.node = node;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }
    }

    private static class IntroduceClassConstantFix
    extends IntroduceFix {
        private TypeScope type;
        private String templ;
        private String constantName;

        public IntroduceClassConstantFix(BaseDocument doc, StaticConstantAccess node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.constantName = node.getConstant().getName();
            this.templ = String.format("const %s = \"\";", this.constantName);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.type.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String clsName = this.type.getName();
            String fileName = this.type.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintClassConstDesc", (Object)this.constantName, (Object)clsName, (Object)fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.type, PhpElementKind.TYPE_CONSTANT);
        }
    }

    private static class IntroduceStaticFieldFix
    extends IntroduceFix {
        private ClassScope clz;
        private String templ;
        private String fieldName;

        public IntroduceStaticFieldFix(BaseDocument doc, StaticFieldAccess node, ClassScope clz) {
            super(doc, node);
            this.clz = clz;
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String clsName = this.clz.getName();
            String fileName = this.clz.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintStaticFieldDesc", (Object)this.fieldName, (Object)clsName, (Object)fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.clz, PhpElementKind.FIELD);
        }

        private String createTemplate() {
            Variable fieldVar = ((StaticFieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(fieldVar);
            if (!fieldVar.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("static %s = \"\";", this.fieldName);
        }
    }

    private static class IntroduceFieldFix
    extends IntroduceFix {
        private ClassScope clz;
        private String templ;
        private String fieldName;

        public IntroduceFieldFix(BaseDocument doc, FieldAccess node, ClassScope clz) {
            super(doc, node);
            this.clz = clz;
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String clsName = this.clz.getName();
            String fileName = this.clz.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintFieldDesc", (Object)this.templ, (Object)clsName, (Object)fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.clz, PhpElementKind.FIELD);
        }

        private String createTemplate() {
            Variable fieldVar = ((FieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(fieldVar);
            if (!fieldVar.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("public %s = \"\";", this.fieldName);
        }
    }

    private static class IntroduceStaticMethodFix
    extends IntroduceFix {
        private TypeScope type;
        private PHPCompletionItem.MethodDeclarationItem item;

        public IntroduceStaticMethodFix(BaseDocument doc, StaticMethodInvocation node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.item = IntroduceHint.createMethodDeclarationItem(type, node);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 1));
        }

        public String getDescription() {
            String clsName = this.type.getName();
            String fileName = this.type.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintStaticMethodDesc", (Object)this.item.getMethod().asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration), (Object)clsName, (Object)fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.type, PhpElementKind.METHOD);
        }
    }

    private static class IntroduceMethodFix
    extends IntroduceFix {
        private TypeScope type;
        private PHPCompletionItem.MethodDeclarationItem item;

        public IntroduceMethodFix(BaseDocument doc, MethodInvocation node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.item = IntroduceHint.createMethodDeclarationItem(type, node);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 1));
        }

        public String getDescription() {
            String clsName = this.type.getName();
            String fileName = this.type.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintMethodDesc", (Object)this.item.getMethod().asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration), (Object)clsName, (Object)fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceHint.getOffset(this.doc, this.type, PhpElementKind.METHOD);
        }
    }

    private static class IntroduceClassFix
    extends IntroduceFix {
        private Model model;
        private String clsName;
        private FileObject folder;
        private FileObject template;

        static IntroduceClassFix getInstance(String className, Model model, ClassInstanceCreation instanceCreation) {
            FileObject currentFile = model.getFileScope().getFileObject();
            FileObject folder = currentFile.getParent();
            String templatePath = "Templates/Scripting/PHPClass.php";
            FileObject template = FileUtil.getConfigFile((String)templatePath);
            return template != null && folder != null && folder.canWrite() ? new IntroduceClassFix(className, template, folder, model, instanceCreation) : null;
        }

        IntroduceClassFix(String className, FileObject template, FileObject folder, Model model, ClassInstanceCreation instanceCreation) {
            super(null, instanceCreation);
            this.model = model;
            this.clsName = className;
            this.template = template;
            this.folder = folder;
        }

        public void implement() throws Exception {
            final DataFolder dataFolder = DataFolder.findFolder((FileObject)this.folder);
            final DataObject configDataObject = DataObject.find((FileObject)this.template);
            final FileObject[] clsFo = new FileObject[1];
            FileUtil.runAtomicAction((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DataObject clsDataObject = configDataObject.createFromTemplate(dataFolder, IntroduceClassFix.this.clsName);
                        clsFo[0] = clsDataObject.getPrimaryFile();
                        FileObject fo = clsFo[0];
                        FileLock lock = fo.lock();
                        try {
                            fo.rename(lock, fo.getName(), "php");
                        }
                        finally {
                            lock.releaseLock();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            if (clsFo[0] != null) {
                UiUtils.open((FileObject)clsFo[0], (int)0);
            }
        }

        public String getDescription() {
            String fileName = FileUtil.getFileDisplayName((FileObject)this.folder);
            int length = fileName.length();
            if (length > 30) {
                int indexOf = (fileName = fileName.substring(length - 30)).indexOf("/");
                if (indexOf != -1) {
                    fileName = fileName.substring(indexOf);
                }
                fileName = String.format("...%s/%s.php", fileName, this.clsName);
            }
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintClassDesc", (Object)this.clsName, (Object)fileName);
        }
    }

    private class IntroduceFixVisitor
    extends DefaultTreePathVisitor {
        private int lineBegin;
        private int lineEnd;
        private IntroduceFix fix;
        private Model model;

        IntroduceFixVisitor(Model model, int lineBegin, int lineEnd) {
            this.lineBegin = lineBegin;
            this.lineEnd = lineEnd;
            this.model = model;
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null && IntroduceHint.isBefore(node.getStartOffset(), this.lineEnd)) {
                super.scan(node);
            }
        }

        @Override
        public void visit(ClassInstanceCreation instanceCreation) {
            if (IntroduceHint.isInside(instanceCreation.getStartOffset(), this.lineBegin, this.lineEnd)) {
                String clzName = CodeUtils.extractClassName(instanceCreation.getClassName());
                clzName = clzName != null && clzName.trim().length() > 0 ? clzName : null;
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<Object> classes = Collections.emptySet();
                if (clzName != null) {
                    classes = index.getClasses(NameKind.exact(clzName));
                }
                if (clzName != null && classes.isEmpty()) {
                    ClassElement clz;
                    ClassElement classElement = clz = clzName != null ? this.getIndexedClass(clzName) : null;
                    if (clz == null && clzName != null) {
                        this.fix = IntroduceClassFix.getInstance(clzName, this.model, instanceCreation);
                    }
                }
            }
            super.visit(instanceCreation);
        }

        @Override
        public void visit(MethodInvocation methodInvocation) {
            Collection<? extends TypeScope> allTypes;
            String methName;
            if (IntroduceHint.isInside(methodInvocation.getStartOffset(), this.lineBegin, this.lineEnd) && (methName = CodeUtils.extractFunctionName(methodInvocation.getMethod())) != null && (allTypes = ModelUtils.resolveType(this.model, methodInvocation)).size() == 1) {
                TypeScope type = ModelUtils.getFirst(allTypes);
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<MethodElement> allMethods = ElementFilter.forName(NameKind.exact(methName)).filter(index.getAllMethods(type));
                if (allMethods.isEmpty()) {
                    BaseDocument document;
                    FileObject fileObject = type.getFileObject();
                    BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                    if (document != null && fileObject.canWrite()) {
                        this.fix = new IntroduceMethodFix(document, methodInvocation, type);
                    }
                }
            }
            super.visit(methodInvocation);
        }

        @Override
        public void visit(StaticMethodInvocation methodInvocation) {
            if (IntroduceHint.isInside(methodInvocation.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Collection<? extends TypeScope> allTypes;
                String methName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
                String clzName = CodeUtils.extractUnqualifiedClassName(methodInvocation);
                if (clzName != null && (allTypes = ModelUtils.resolveType(this.model, methodInvocation)).size() == 1) {
                    ElementFilter staticFilter;
                    TypeScope type = ModelUtils.getFirst(allTypes);
                    ElementQuery.Index index = this.model.getIndexScope().getIndex();
                    ElementFilter nameFilter = ElementFilter.forName(NameKind.exact(methName));
                    Set<MethodElement> allMethods = ElementFilter.allOf(nameFilter, staticFilter = ElementFilter.forStaticModifiers(true)).filter(index.getAllMethods(type));
                    if (allMethods.isEmpty()) {
                        BaseDocument document;
                        FileObject fileObject = type.getFileObject();
                        BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                        if (document != null && fileObject.canWrite()) {
                            this.fix = new IntroduceStaticMethodFix(document, methodInvocation, type);
                        }
                    }
                }
            }
            super.visit(methodInvocation);
        }

        @Override
        public void visit(FieldAccess fieldAccess) {
            Collection<? extends TypeScope> allTypes;
            String fieldName;
            if (IntroduceHint.isInside(fieldAccess.getStartOffset(), this.lineBegin, this.lineEnd) && (fieldName = CodeUtils.extractVariableName(fieldAccess.getField())) != null && (allTypes = ModelUtils.resolveType(this.model, fieldAccess)).size() == 1) {
                TypeScope type = ModelUtils.getFirst(allTypes);
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<FieldElement> allFields = ElementFilter.forName(NameKind.exact(fieldName)).filter(index.getAlllFields(type));
                if (allFields.isEmpty()) {
                    BaseDocument document;
                    FileObject fileObject = type.getFileObject();
                    BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                    if (document != null && fileObject.canWrite() && type instanceof ClassScope) {
                        this.fix = new IntroduceFieldFix(document, fieldAccess, (ClassScope)type);
                    }
                }
            }
            super.visit(fieldAccess);
        }

        @Override
        public void visit(StaticFieldAccess fieldAccess) {
            if (IntroduceHint.isInside(fieldAccess.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Variable field = fieldAccess.getField();
                String clzName = CodeUtils.extractUnqualifiedClassName(fieldAccess);
                if (clzName != null) {
                    Collection<? extends TypeScope> allTypes;
                    String fieldName = CodeUtils.extractVariableName(field);
                    if (fieldName == null) {
                        return;
                    }
                    if (fieldName.startsWith("$")) {
                        fieldName = fieldName.substring(1);
                    }
                    if ((allTypes = ModelUtils.resolveType(this.model, fieldAccess)).size() == 1) {
                        TypeScope type = ModelUtils.getFirst(allTypes);
                        ElementQuery.Index index = this.model.getIndexScope().getIndex();
                        ElementFilter staticFieldsFilter = ElementFilter.allOf(ElementFilter.forName(NameKind.exact(fieldName)), ElementFilter.forStaticModifiers(true));
                        Set<FieldElement> allFields = staticFieldsFilter.filter(index.getAlllFields(type));
                        if (allFields.isEmpty()) {
                            BaseDocument document;
                            FileObject fileObject = type.getFileObject();
                            BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                            if (document != null && fileObject.canWrite() && type instanceof ClassScope) {
                                this.fix = new IntroduceStaticFieldFix(document, fieldAccess, (ClassScope)type);
                            }
                        }
                    }
                }
            }
            super.visit(fieldAccess);
        }

        @Override
        public void visit(StaticConstantAccess staticConstantAccess) {
            if (IntroduceHint.isInside(staticConstantAccess.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Collection<? extends TypeScope> allTypes;
                String constName = staticConstantAccess.getConstant().getName();
                String clzName = CodeUtils.extractUnqualifiedClassName(staticConstantAccess);
                if (clzName != null && constName != null && (allTypes = ModelUtils.resolveType(this.model, staticConstantAccess)).size() == 1) {
                    TypeScope type = ModelUtils.getFirst(allTypes);
                    ElementQuery.Index index = this.model.getIndexScope().getIndex();
                    Set<TypeConstantElement> allConstants = ElementFilter.forName(NameKind.exact(constName)).filter(index.getAllTypeConstants(type));
                    if (allConstants.isEmpty()) {
                        BaseDocument document;
                        FileObject fileObject = type.getFileObject();
                        BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                        if (document != null && fileObject.canWrite()) {
                            this.fix = new IntroduceClassConstantFix(document, staticConstantAccess, type);
                        }
                    }
                }
            }
            super.visit(staticConstantAccess);
        }

        public IntroduceFix getIntroduceFix() {
            return this.fix;
        }

        private ClassElement getIndexedClass(String name) {
            ClassElement retval = null;
            ElementQuery.Index index = this.model.getIndexScope().getIndex();
            Collection<Object> classes = Collections.emptyList();
            if ("self".equals(name) || "parent".equals(name)) {
                List<ASTNode> path = this.getPath();
                for (ASTNode aSTNode : path) {
                    if (!(aSTNode instanceof ClassDeclaration)) continue;
                    String clzName = CodeUtils.extractClassName((ClassDeclaration)aSTNode);
                    classes = index.getClasses(NameKind.exact(clzName));
                    break;
                }
            } else {
                classes = index.getClasses(NameKind.exact(name));
            }
            if (classes.size() == 1) {
                String superClassName;
                retval = (ClassElement)classes.iterator().next();
                if ("parent".equals(name) && (superClassName = retval.getSuperClassName().getName()) != null) {
                    classes = index.getClasses(NameKind.exact(superClassName));
                    retval = classes.size() == 1 ? (ClassElement)classes.iterator().next() : null;
                }
            }
            return retval;
        }
    }
}

