/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingAdditionalInfoPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingFiles4Panel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingFilesOuterPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingFilesPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingInfoOuterPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingInfoPanel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PackagingPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    PackagingConfiguration packagingConfiguration;
    private PropertyEditorSupport editor;
    private MakeConfiguration conf;
    private PackagingInfoOuterPanel packagingInfoOuterPanel = null;
    private PackagingInfoPanel packagingInfoPanel = null;
    private PackagingAdditionalInfoPanel packagingAdditionalInfoPanel = null;
    private PackagingFilesOuterPanel packagingFilesOuterPanel = null;
    private PackagingFilesPanel packagingFilesPanel = null;
    private JTabbedPane tabbedPane;
    private static ResourceBundle bundle;

    public PackagingPanel(PackagingConfiguration packagingConfiguration, PropertyEditorSupport editor, PropertyEnv env, MakeConfiguration conf) {
        this.initComponents();
        this.packagingConfiguration = packagingConfiguration;
        this.editor = editor;
        this.conf = conf;
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        String type = packagingConfiguration.getType().getValue();
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        if (packager.hasInfoList()) {
            this.packagingInfoPanel = new PackagingInfoPanel(packagingConfiguration.getHeaderSubList(type), packagingConfiguration);
            this.packagingAdditionalInfoPanel = new PackagingAdditionalInfoPanel(packagingConfiguration.getAdditionalInfo().getValue(), packagingConfiguration);
            this.packagingInfoOuterPanel = new PackagingInfoOuterPanel(this.packagingInfoPanel, this.packagingAdditionalInfoPanel);
            this.packagingFilesPanel = new PackagingFilesPanel(packagingConfiguration.getFiles().getValue(), conf.getBaseDir());
        } else {
            this.packagingFilesPanel = new PackagingFiles4Panel(packagingConfiguration.getFiles().getValue(), conf.getBaseDir());
        }
        this.packagingFilesOuterPanel = new PackagingFilesOuterPanel(this.packagingFilesPanel, packagingConfiguration);
        this.tabbedPane.addTab(PackagingPanel.getString("InfoPanelText"), this.packagingInfoOuterPanel);
        this.tabbedPane.addTab(PackagingPanel.getString("FilePanelText"), this.packagingFilesOuterPanel);
        if (packager.hasInfoList()) {
            this.tabbedPane.setEnabledAt(0, true);
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setSelectedIndex(0);
        } else {
            this.tabbedPane.setEnabledAt(0, false);
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setSelectedIndex(1);
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)dim.getWidth() / 10 * 6;
        this.setPreferredSize(new Dimension(width, 600));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private Object getPropertyValue() throws IllegalStateException {
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(this.packagingConfiguration.getType().getValue());
        if (packager.hasInfoList()) {
            List<PackagerInfoElement> oldList = this.packagingConfiguration.getInfo().getValue();
            ArrayList<PackagerInfoElement> newList = new ArrayList<PackagerInfoElement>();
            for (PackagerInfoElement elem : oldList) {
                if (elem.getPackager().equals(this.packagingConfiguration.getType().getValue())) continue;
                newList.add(elem);
            }
            List editedList = this.packagingInfoPanel.getListData();
            for (PackagerInfoElement elem : editedList) {
                newList.add(elem);
            }
            this.packagingConfiguration.getInfo().setValue(newList);
            this.packagingConfiguration.getAdditionalInfo().setValue(this.packagingAdditionalInfoPanel.getListData());
        }
        this.packagingConfiguration.getFiles().setValue(new ArrayList(this.packagingFilesPanel.getListData()));
        return this.packagingConfiguration;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("PackagingFiles");
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PackagingPanel.class, (String)"PackagingPanel.tabbedPane.AccessibleContext.accessibleName"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PackagingPanel.class, (String)"PackagingPanel.tabbedPane.AccessibleContext.accessibleDescription"));
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PackagingPanel.class);
        }
        return bundle.getString(s);
    }
}

