/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.openide.WizardDescriptor;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OperationDescriptionStep
implements WizardDescriptor.Panel<WizardDescriptor> {
    private static final String HEAD = "OperationDescriptionStep_Header_Head";
    private static final String CONTENT = "OperationDescriptionStep_Header_Content";
    private static final String TABLE_TITLE_INSTALL = "OperationDescriptionStep_TableInstall_Title";
    private static final String TABLE_TITLE_UPDATE = "OperationDescriptionStep_TableUpdate_Title";
    private static final String HEAD_UNINSTALL = "OperationDescriptionStep_HeaderUninstall_Head";
    private static final String CONTENT_UNINSTALL = "OperationDescriptionStep_HeaderUninstall_Content";
    private static final String TABLE_TITLE_UNINSTALL = "OperationDescriptionStep_TableUninstall_Title";
    private static final String HEAD_ACTIVATE = "OperationDescriptionStep_HeaderActivate_Head";
    private static final String CONTENT_ACTIVATE = "OperationDescriptionStep_HeaderActivate_Content";
    private static final String TABLE_TITLE_ACTIVATE = "OperationDescriptionStepActivate_Table_Title";
    private static final String HEAD_DEACTIVATE = "OperationDescriptionStep_HeaderDeativate_Head";
    private static final String CONTENT_DEACTIVATE = "OperationDescriptionStep_HeaderDeativate_Content";
    private static final String TABLE_TITLE_DEACTIVATE = "OperationDescriptionStep_TableDeativate_Title";
    private static final String DEPENDENCIES_TITLE_INSTALL = "DependenciesResolutionStep_Table_Title";
    private static final String DEPENDENCIES_TITLE_UPDATE = "DependenciesResolutionStep_Table_Title";
    private static final String DEPENDENCIES_TITLE_UNINSTALL = "UninstallDependenciesResolutionStep_Table_Title";
    private static final String DEPENDENCIES_TITLE_ACTIVATE = "OperationDescriptionStep_TableInstall_Title";
    private static final String DEPENDENCIES_TITLE_DEACTIVATE = "UninstallDependenciesResolutionStep_Table_Title";
    private PanelBodyContainer component;
    private OperationWizardModel model = null;
    private boolean readyToGo = false;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private RequestProcessor.Task lazyDependingTask = null;

    public OperationDescriptionStep(OperationWizardModel model) {
        this.model = model;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.readyToGo = false;
            String tableTitle = null;
            String dependenciesTitle = null;
            String head = null;
            String content = null;
            switch (this.model.getOperation()) {
                case LOCAL_DOWNLOAD: {
                    if (Containers.forUpdateNbms().listAll().isEmpty()) {
                        tableTitle = OperationDescriptionStep.getBundle("OperationDescriptionStep_TableInstall_Title", new Object[0]);
                        dependenciesTitle = OperationDescriptionStep.getBundle("DependenciesResolutionStep_Table_Title", new Object[0]);
                    } else {
                        tableTitle = OperationDescriptionStep.getBundle(TABLE_TITLE_UPDATE, new Object[0]);
                        dependenciesTitle = OperationDescriptionStep.getBundle("DependenciesResolutionStep_Table_Title", new Object[0]);
                    }
                    head = OperationDescriptionStep.getBundle(HEAD, new Object[0]);
                    content = OperationDescriptionStep.getBundle(CONTENT, new Object[0]);
                    break;
                }
                case INSTALL: {
                    tableTitle = OperationDescriptionStep.getBundle("OperationDescriptionStep_TableInstall_Title", new Object[0]);
                    dependenciesTitle = OperationDescriptionStep.getBundle("DependenciesResolutionStep_Table_Title", new Object[0]);
                    head = OperationDescriptionStep.getBundle(HEAD, new Object[0]);
                    content = OperationDescriptionStep.getBundle(CONTENT, new Object[0]);
                    break;
                }
                case UPDATE: {
                    tableTitle = OperationDescriptionStep.getBundle(TABLE_TITLE_UPDATE, new Object[0]);
                    dependenciesTitle = OperationDescriptionStep.getBundle("DependenciesResolutionStep_Table_Title", new Object[0]);
                    head = OperationDescriptionStep.getBundle(HEAD, new Object[0]);
                    content = OperationDescriptionStep.getBundle(CONTENT, new Object[0]);
                    break;
                }
                case UNINSTALL: {
                    tableTitle = OperationDescriptionStep.getBundle(TABLE_TITLE_UNINSTALL, new Object[0]);
                    dependenciesTitle = OperationDescriptionStep.getBundle("UninstallDependenciesResolutionStep_Table_Title", new Object[0]);
                    head = OperationDescriptionStep.getBundle(HEAD_UNINSTALL, new Object[0]);
                    content = OperationDescriptionStep.getBundle(CONTENT_UNINSTALL, new Object[0]);
                    break;
                }
                case ENABLE: {
                    tableTitle = OperationDescriptionStep.getBundle(TABLE_TITLE_ACTIVATE, new Object[0]);
                    dependenciesTitle = OperationDescriptionStep.getBundle("OperationDescriptionStep_TableInstall_Title", new Object[0]);
                    head = OperationDescriptionStep.getBundle(HEAD_ACTIVATE, new Object[0]);
                    content = OperationDescriptionStep.getBundle(CONTENT_ACTIVATE, new Object[0]);
                    break;
                }
                case DISABLE: {
                    tableTitle = OperationDescriptionStep.getBundle(TABLE_TITLE_DEACTIVATE, new Object[0]);
                    dependenciesTitle = OperationDescriptionStep.getBundle("UninstallDependenciesResolutionStep_Table_Title", new Object[0]);
                    head = OperationDescriptionStep.getBundle(HEAD_DEACTIVATE, new Object[0]);
                    content = OperationDescriptionStep.getBundle(CONTENT_DEACTIVATE, new Object[0]);
                }
            }
            OperationDescriptionPanel body = new OperationDescriptionPanel(tableTitle, this.preparePluginsForShow(this.model.getPrimaryUpdateElements(), this.model.getPrimaryVisibleUpdateElements(false), this.model.getCustomHandledComponents(), this.model.getOperation(), false), "", "", true);
            this.component = new PanelBodyContainer(head, content, body);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
            this.component.setWaitingState(true);
            this.appendDependingLazy(tableTitle, dependenciesTitle);
        }
        return this.component;
    }

    private void appendDependingLazy(final String tableTitle, final String dependenciesTitle) {
        this.lazyDependingTask = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                boolean hasBrokenDependencies;
                OperationDescriptionPanel body = null;
                OperationDescriptionStep.this.model.getRequiredUpdateElements();
                if (OperationDescriptionStep.this.model instanceof InstallUnitWizardModel) {
                    ((InstallUnitWizardModel)OperationDescriptionStep.this.model).allLicensesApproved();
                    ((InstallUnitWizardModel)OperationDescriptionStep.this.model).hasCustomComponents();
                    ((InstallUnitWizardModel)OperationDescriptionStep.this.model).hasStandardComponents();
                }
                body = (hasBrokenDependencies = OperationDescriptionStep.this.model.hasBrokenDependencies()) ? new OperationDescriptionPanel("", "", OperationDescriptionStep.prepareBrokenDependenciesForShow(OperationDescriptionStep.this.model), "", true) : new OperationDescriptionPanel(tableTitle, OperationDescriptionStep.this.preparePluginsForShow(OperationDescriptionStep.this.model.getPrimaryUpdateElements(), OperationDescriptionStep.this.model.getPrimaryVisibleUpdateElements(true), OperationDescriptionStep.this.model.getCustomHandledComponents(), OperationDescriptionStep.this.model.getOperation(), true), dependenciesTitle, OperationDescriptionStep.this.preparePluginsForShow(OperationDescriptionStep.this.model.getRequiredUpdateElements(), OperationDescriptionStep.this.model.getRequiredVisibleUpdateElements(), null, OperationDescriptionStep.this.model.getOperation(), true), !OperationDescriptionStep.this.model.getRequiredVisibleUpdateElements().isEmpty());
                final OperationDescriptionPanel finalPanel = body;
                OperationDescriptionStep.this.readyToGo = OperationDescriptionStep.this.model != null && !hasBrokenDependencies;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OperationDescriptionStep.this.component.setBody(finalPanel);
                        OperationDescriptionStep.this.component.setWaitingState(false);
                        OperationDescriptionStep.this.fireChange();
                    }
                });
            }
        });
    }

    static String prepareBrokenDependenciesForShow(OperationWizardModel model) {
        String s = new String();
        boolean moreBroken = false;
        SortedMap<String, Set<UpdateElement>> dep2plugins = model.getBrokenDependency2Plugins();
        for (String brokenDep : dep2plugins.keySet()) {
            if (OperationWizardModel.MORE_BROKEN_PLUGINS.equals(brokenDep)) {
                moreBroken = true;
                continue;
            }
            s = s + OperationDescriptionStep.getPresentationName(brokenDep);
            if (dep2plugins.get(brokenDep) == null) continue;
            HashSet sset = new HashSet((Collection)dep2plugins.get(brokenDep));
            HashSet<UpdateElement> uniqueElements = new HashSet<UpdateElement>();
            for (UpdateElement plugin : sset) {
                uniqueElements.addAll(model.findPrimaryPlugins(plugin));
            }
            TreeSet<String> uniqueNames = new TreeSet<String>();
            for (UpdateElement plugin : uniqueElements) {
                uniqueNames.add(plugin.getDisplayName());
            }
            s = s + (uniqueNames.size() == 1 ? OperationDescriptionStep.getBundle("OperationDescriptionStep_AffectedPluginByBrokenDepOnce", new Object[0]) : OperationDescriptionStep.getBundle("OperationDescriptionStep_AffectedPluginByBrokenDep", new Object[0]));
            for (String name : uniqueNames) {
                s = s + OperationDescriptionStep.getBundle("OperationDescriptionStep_AffectedPlugin", name);
            }
        }
        if (moreBroken) {
            s = s + OperationDescriptionStep.getBundle(OperationWizardModel.MORE_BROKEN_PLUGINS, new Object[0]);
        }
        return s.trim();
    }

    private static String getPresentationName(String dep) {
        String presentationName = null;
        boolean isPending = false;
        String reason = null;
        if (dep != null && dep.startsWith("module")) {
            String codeName = dep.substring(6).trim();
            int end = codeName.indexOf(47);
            String releaseVersion = null;
            if (end == -1) {
                end = codeName.indexOf(32);
            } else {
                int spaceIndex = codeName.indexOf(32);
                int index = spaceIndex != -1 ? spaceIndex : codeName.length();
                releaseVersion = codeName.substring(end + 1, index).trim();
            }
            if (end != -1) {
                codeName = codeName.substring(0, end);
            }
            int greater = dep.indexOf(62);
            int equals = dep.indexOf(61);
            int idx = Math.max(greater, equals);
            String version = null;
            if (idx > 0) {
                version = dep.substring(idx + 2).trim();
            }
            UpdateElement other = null;
            for (UpdateUnit u : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
                if (!codeName.equals(u.getCodeName())) continue;
                if (u.getInstalled() != null) {
                    other = u.getInstalled();
                } else if (u.getAvailableUpdates().size() > 0) {
                    other = (UpdateElement)u.getAvailableUpdates().get(0);
                }
                if (u == null) break;
                isPending = u.isPending();
                break;
            }
            if (idx == -1) {
                reason = OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleNameDep", other == null ? codeName : other.getDisplayName());
            } else if (greater > 0) {
                if (version != null && other != null && version.equals(other.getSpecificationVersion())) {
                    reason = OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleDep", other.getDisplayName());
                } else if (version != null) {
                    if (other != null) {
                        int compare = new SpecificationVersion(other.getSpecificationVersion()).compareTo((Object)new SpecificationVersion(version));
                        reason = releaseVersion != null && (equals > 0 ? compare >= 0 : compare > 0) ? OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleReleaseVersionDep", other.getDisplayName(), version, releaseVersion, other.getSpecificationVersion()) : OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleVersionDep", other.getDisplayName(), version, other.getSpecificationVersion());
                    } else {
                        reason = OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleOnlyVersionDep", codeName, version);
                    }
                } else {
                    reason = OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleDep", other == null ? codeName : other.getDisplayName());
                }
            } else if (equals > 0) {
                reason = version != null ? OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleImplDep", other == null ? codeName : other.getDisplayName(), version) : OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleDep", other == null ? codeName : other.getDisplayName());
            }
            presentationName = isPending ? OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenPendingModuleDepInit", other == null ? codeName : other.getDisplayName(), reason) : OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenModuleDepInit", other == null ? codeName : other.getDisplayName(), reason);
        } else if (dep != null && (dep.toLowerCase().startsWith("requires") || dep.toLowerCase().startsWith("needs"))) {
            String token = dep.substring(dep.indexOf(32) + 1);
            presentationName = OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenRequireDepInit", token, OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenRequiresDep", token));
        } else if (dep != null && dep.toLowerCase().startsWith("java")) {
            presentationName = OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenJavaDepInit", dep, OperationDescriptionStep.getBundle("OperationDescriptionStep_PluginBrokesJavaDependency", dep, Dependency.JAVA_SPEC));
        } else if (dep != null && dep.toLowerCase().startsWith("package")) {
            presentationName = OperationDescriptionStep.getBundle("OperationDescriptionStep_BrokenPackageDepInit", new Object[0]);
        }
        return presentationName == null ? dep : presentationName;
    }

    private String preparePluginsForShow(Set<UpdateElement> allPlugins, Set<UpdateElement> visiblePlugins, Set<UpdateElement> customHandled, OperationWizardModel.OperationType type, boolean checkInternalUpdates) {
        String s = new String();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<UpdateUnit> invisibleIncluded = new ArrayList<UpdateUnit>();
        ArrayList<UpdateUnit> units = new ArrayList<UpdateUnit>();
        ArrayList<UpdateElement> plugins = new ArrayList<UpdateElement>();
        for (UpdateElement el : visiblePlugins) {
            String newVersion;
            String oldVersion;
            boolean internal = false;
            if (OperationWizardModel.OperationType.UPDATE == type && el.getUpdateUnit().getInstalled() != null && ((oldVersion = el.getUpdateUnit().getInstalled().getSpecificationVersion()).equals(newVersion = el.getSpecificationVersion()) || !el.getUpdateUnit().getType().equals((Object)UpdateManager.TYPE.KIT_MODULE))) {
                internal = true;
            }
            if (internal) {
                plugins.add(el);
                continue;
            }
            plugins.add(0, el);
        }
        for (UpdateElement p : plugins) {
            units.add(p.getUpdateUnit());
        }
        if (plugins != null && !plugins.isEmpty()) {
            HashMap<UpdateUnit, List<UpdateElement>> map = null;
            if (checkInternalUpdates) {
                map = Utilities.getVisibleModulesDependecyMap(units);
            }
            for (UpdateElement el : plugins) {
                String updatename = "<b>" + el.getDisplayName() + "</b> ";
                if (OperationWizardModel.OperationType.UPDATE == type && el.getUpdateUnit().getInstalled() != null) {
                    String oldVersion = el.getUpdateUnit().getInstalled().getSpecificationVersion();
                    String newVersion = el.getSpecificationVersion();
                    OperationContainer container = OperationContainer.createForUpdate();
                    if (oldVersion.equals(newVersion) && checkInternalUpdates) {
                        OperationContainer internalUpdate = OperationContainer.createForInternalUpdate();
                        internalUpdate.add(el);
                        for (OperationContainer.OperationInfo info : internalUpdate.listAll()) {
                            if (!info.getUpdateElement().equals((Object)el) && !container.contains(info.getUpdateElement()) && allPlugins.contains(info.getUpdateElement())) {
                                container.add(info.getUpdateElement());
                            }
                            for (UpdateElement r : info.getRequiredElements()) {
                                if (container.contains(r) || !container.canBeAdded(r.getUpdateUnit(), r) || !allPlugins.contains(r)) continue;
                                container.add(r);
                            }
                        }
                    } else {
                        updatename = updatename + OperationDescriptionStep.getBundle("OperationDescriptionStep_UpdatePluginVersionFormat", oldVersion, newVersion);
                        if (checkInternalUpdates) {
                            container.add(el);
                        }
                    }
                    if (checkInternalUpdates) {
                        ArrayList<UpdateElement> list = new ArrayList<UpdateElement>();
                        for (OperationContainer.OperationInfo info : container.listAll()) {
                            if (!info.getUpdateUnit().equals((Object)el.getUpdateUnit()) && info.getUpdateUnit().getInstalled() != null && !info.getUpdateUnit().isPending()) {
                                list.add(info.getUpdateElement());
                            }
                            for (UpdateElement upd : info.getRequiredElements()) {
                                if (upd.getUpdateUnit().getInstalled() == null || upd.getUpdateUnit().isPending()) continue;
                                list.add(upd);
                            }
                        }
                        TreeSet<UpdateElement> sorted = new TreeSet<UpdateElement>(new Comparator<UpdateElement>(){

                            @Override
                            public int compare(UpdateElement o1, UpdateElement o2) {
                                return o1.getDisplayName().compareTo(o2.getDisplayName());
                            }
                        });
                        sorted.addAll(list);
                        for (UpdateElement upd : sorted) {
                            UpdateUnit visibleUnit;
                            UpdateUnit unit = upd.getUpdateUnit();
                            if (unit.getType().equals((Object)UpdateManager.TYPE.KIT_MODULE) || invisibleIncluded.contains(unit) || (visibleUnit = Utilities.getVisibleUnitForInvisibleModule(unit, map)) != null && visibleUnit != el.getUpdateUnit()) continue;
                            if (!unit.getType().equals((Object)UpdateManager.TYPE.KIT_MODULE)) {
                                invisibleIncluded.add(unit);
                            }
                            if (unit.getInstalled() != null) {
                                updatename = updatename + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + upd.getDisplayName() + " [" + unit.getInstalled().getSpecificationVersion() + " -> " + ((UpdateElement)unit.getAvailableUpdates().get(0)).getSpecificationVersion() + "]";
                                continue;
                            }
                            updatename = updatename + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + upd.getDisplayName() + " [" + ((UpdateElement)unit.getAvailableUpdates().get(0)).getSpecificationVersion() + "]";
                        }
                        map.remove(el.getUpdateUnit());
                    }
                } else {
                    updatename = updatename + OperationDescriptionStep.getBundle("OperationDescriptionStep_PluginVersionFormat", el.getSpecificationVersion());
                }
                updatename = updatename + "<br>";
                String notification = el.getNotification();
                if (notification != null && notification.length() > 0) {
                    updatename = updatename + "<font color=\"red\">" + notification + "</font><br><br>";
                }
                names.add(updatename);
            }
            Collections.sort(names);
            for (String name : names) {
                s = s + name;
            }
        }
        if (customHandled != null && !customHandled.isEmpty()) {
            names = new ArrayList();
            for (UpdateElement el : customHandled) {
                names.add("<b>" + el.getDisplayName() + "</b> " + OperationDescriptionStep.getBundle("OperationDescriptionStep_PluginVersionFormat", el.getSpecificationVersion()) + "<br>");
            }
            Collections.sort(names);
            s = s + "<br>" + OperationDescriptionStep.getBundle("OperationDescriptionStep_CustomHandled_Head", customHandled.size()) + "<br>";
            for (String name : names) {
                s = s + name;
            }
        }
        return s.trim();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        boolean doOperation;
        boolean bl = doOperation = !(this.model instanceof InstallUnitWizardModel);
        if (doOperation) {
            this.model.modifyOptionsForDoOperation(wd);
        } else {
            this.model.modifyOptionsForStartWizard(wd);
        }
    }

    public void storeSettings(WizardDescriptor wd) {
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue())) {
            try {
                if (this.lazyDependingTask != null && !this.lazyDependingTask.isFinished()) {
                    this.lazyDependingTask.cancel();
                }
                this.model.doCleanup(true);
            }
            catch (OperationException x) {
                Logger.getLogger(InstallUnitWizardModel.class.getName()).log(Level.INFO, x.getMessage(), x);
            }
        }
    }

    public boolean isValid() {
        return this.readyToGo;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        OperationDescriptionStep operationDescriptionStep = this;
        synchronized (operationDescriptionStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private static String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(OperationDescriptionPanel.class, (String)key, (Object[])params);
    }
}

