/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NetworkProblemPanel
extends JPanel {
    private String problem;
    private JButton[] buttons = null;
    private boolean isWarning = false;
    private JScrollPane spMessage;
    private JScrollPane spTitle;
    private JTextArea taMessage;
    private JTextArea taTitle;

    public NetworkProblemPanel(String problemDescription) {
        this(problemDescription, false, new JButton[0]);
    }

    public NetworkProblemPanel(String problemDescription, JButton ... buttons) {
        this(problemDescription, true, buttons);
    }

    private NetworkProblemPanel(String problemDescription, boolean warning, JButton ... buttons) {
        this.buttons = buttons;
        this.isWarning = warning;
        this.problem = problemDescription == null ? NetworkProblemPanel.getBundle("NetworkProblemPanel_taTitle_Text") : problemDescription;
        this.initComponents();
        this.taTitle.setToolTipText(this.problem);
        if (this.isWarning) {
            if (buttons.length == 2) {
                this.taMessage.setText(NbBundle.getMessage(NetworkProblemPanel.class, (String)"NetworkProblemPanel_taMessage_WarningTextWithReload"));
            } else {
                this.taMessage.setText(NbBundle.getMessage(NetworkProblemPanel.class, (String)"NetworkProblemPanel_taMessage_WarningText"));
            }
        } else {
            this.taMessage.setText(NbBundle.getMessage(NetworkProblemPanel.class, (String)"NetworkProblemPanel_taMessage_ErrorText"));
        }
        for (JButton b : buttons) {
            b.getAccessibleContext().setAccessibleDescription(b.getText());
        }
    }

    private void initComponents() {
        this.spTitle = new JScrollPane();
        this.taTitle = new JTextArea(this.problem);
        this.spMessage = new JScrollPane();
        this.taMessage = new JTextArea();
        this.setMinimumSize(new Dimension(250, 200));
        this.spTitle.setBorder(null);
        this.taTitle.setEditable(false);
        this.taTitle.setLineWrap(true);
        this.taTitle.setWrapStyleWord(true);
        this.taTitle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.taTitle.setOpaque(false);
        this.taTitle.setPreferredSize(new Dimension(100, 40));
        this.spTitle.setViewportView(this.taTitle);
        this.taTitle.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NetworkProblemPanel.class, (String)"NetworkProblemPanel_taTitle_ACN"));
        this.taTitle.getAccessibleContext().setAccessibleDescription(this.problem);
        this.spMessage.setBorder(null);
        this.taMessage.setEditable(false);
        this.taMessage.setLineWrap(true);
        this.taMessage.setRows(3);
        this.taMessage.setWrapStyleWord(true);
        this.taMessage.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.taMessage.setOpaque(false);
        this.spMessage.setViewportView(this.taMessage);
        this.taMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NetworkProblemPanel.class, (String)"NetworkProblemPanel_taMessage"));
        this.taMessage.getAccessibleContext().setAccessibleDescription(this.problem);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spTitle, -1, 347, Short.MAX_VALUE).addComponent(this.spMessage));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.spTitle, -1, 103, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spMessage, -1, 160, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NetworkProblemPanel.class, (String)"NetworkProblemPanel_ACD"));
    }

    public Object showNetworkProblemDialog() {
        DialogDescriptor dd = this.getDialogDescriptor();
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        return dd.getValue();
    }

    private DialogDescriptor getDialogDescriptor() {
        Object[] options = null;
        options = this.buttons == null || this.buttons.length == 0 ? new Object[]{DialogDescriptor.OK_OPTION} : this.buttons;
        JButton showProxyOptions = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)showProxyOptions, (String)NetworkProblemPanel.getBundle("CTL_ShowProxyOptions"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, this.isWarning ? NetworkProblemPanel.getBundle("CTL_Warning") : NetworkProblemPanel.getBundle("CTL_Error"), true, options, null, 0, null, null);
        showProxyOptions.getAccessibleContext().setAccessibleDescription(NetworkProblemPanel.getBundle("ACSD_ShowProxyOptions"));
        showProxyOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionsDisplayer.getDefault().open("General");
            }
        });
        descriptor.setMessageType(this.isWarning ? 2 : 0);
        if (this.isWarning) {
            descriptor.setAdditionalOptions(new Object[]{showProxyOptions});
        }
        descriptor.setClosingOptions(options);
        return descriptor;
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(NetworkProblemPanel.class, (String)key);
    }
}

