/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.CatalogNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class CatalogNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private CatalogNodeProvider(Lookup lookup) {
        super(lookup, new CatalogComparator());
    }

    @Override
    protected synchronized void initialize() {
        boolean isConnected;
        final ArrayList<Node> newList = new ArrayList<Node>();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        boolean bl = isConnected = !this.connection.getConnector().isDisconnected();
        if (isConnected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Collection catalogs = metaData.getCatalogs();
                        String defaultCatalog = metaData.getDefaultCatalog().getName();
                        for (Catalog catalog : catalogs) {
                            boolean use;
                            boolean oneCatalog;
                            boolean bl = oneCatalog = catalogs.size() == 1;
                            if (catalog.getName() == null && !oneCatalog || !(use = true)) continue;
                            MetadataElementHandle catalogHandle = MetadataElementHandle.create((MetadataElement)catalog);
                            Collection matches = CatalogNodeProvider.this.getNodes(catalogHandle);
                            if (matches.size() > 0) {
                                newList.addAll(matches);
                                continue;
                            }
                            NodeDataLookup lookup = new NodeDataLookup();
                            lookup.add(CatalogNodeProvider.this.connection);
                            lookup.add(catalogHandle);
                            newList.add(CatalogNode.create(lookup, CatalogNodeProvider.this));
                        }
                        if (newList.size() == 1) {
                            CatalogNodeProvider.this.setProxyNodes(newList);
                        } else {
                            CatalogNodeProvider.this.setNodes(newList);
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        } else if (!isConnected) {
            this.setNodes(newList);
        }
    }

    static class CatalogComparator
    implements Comparator<Node> {
        CatalogComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public CatalogNodeProvider createInstance(Lookup lookup) {
                CatalogNodeProvider provider = new CatalogNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

