/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.samples.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.project.Project;
import org.netbeans.modules.identity.samples.util.Log;
import org.netbeans.modules.identity.samples.util.SoaSampleProjectProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class SoaSampleUtils {
    public static String[] xlateFiles = new String[]{"build-impl.xml", "project.xml", "project.properties", "AssemblyInformation.xml"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(InputStream inputStream, FileObject fileObject) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFileTranslateProjectName(InputStream inputStream, FileObject fileObject, String string, String string2) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String string3 = zipEntry.getName();
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string3);
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        if (SoaSampleUtils.needTranslation(string3)) {
                            SoaSampleUtils.translateProjectName(zipInputStream, outputStream, string, string2);
                            continue;
                        }
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    static boolean needTranslation(String string) {
        for (int i = 0; i < xlateFiles.length; ++i) {
            if (!string.endsWith(xlateFiles[i])) continue;
            return true;
        }
        return false;
    }

    static void translateProjectName(InputStream inputStream, OutputStream outputStream, String string, String string2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toString().replaceAll(string2, string).getBytes());
        FileUtil.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
    }

    public static FileObject getStudioUserDir() {
        Log.out("StudioUserDir: " + FileUtil.toFileObject((File)new File(System.getProperty("netbeans.user"))).getPath());
        return FileUtil.toFileObject((File)new File(System.getProperty("netbeans.user")));
    }

    public static FileObject getProjectFolder(FileObject fileObject, String string) {
        assert (fileObject != null) : fileObject + "/" + string + "doesn't exist";
        assert (string != null) : "project name can't be empty";
        return fileObject.getFileObject(string);
    }

    private static FileObject getFolder(String string) {
        return SoaSampleUtils.getFolder(SoaSampleUtils.getStudioUserDir(), string);
    }

    private static FileObject getFolder(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            return fileObject2;
        }
        try {
            fileObject2 = fileObject.createFolder(string);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(4096, (Throwable)iOException);
        }
        return fileObject2;
    }

    private static String getPropertiesPath(String string) {
        return SoaSampleProjectProperties.getDefault().isPrivateProperty(string) ? "nbproject/private/private.properties" : "nbproject/project.properties";
    }

    private static AntProjectHelper getAntProjectHelper(Project project) {
        return (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPrivateProperty(FileObject fileObject, String string, String string2) {
        Properties properties = new Properties();
        try {
            properties.setProperty(string, string2);
            FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)"nbproject/private/private.properties");
            FileLock fileLock = fileObject2.lock();
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                properties.store(outputStream, null);
            }
            finally {
                outputStream.close();
                fileLock.releaseLock();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getProperty(Project project, String string) {
        return SoaSampleUtils.getProperties(project, string).getProperty(string);
    }

    private static EditableProperties getProperties(Project project, String string) {
        AntProjectHelper antProjectHelper = SoaSampleUtils.getAntProjectHelper(project);
        assert (antProjectHelper != null) : "Can't get AntProjectHelper for project: " + project;
        return antProjectHelper.getProperties(SoaSampleUtils.getPropertiesPath(string));
    }

    public static String getDefaultSunAppLocation() {
        String[] stringArray;
        String string = null;
        for (String string2 : stringArray = InstanceProperties.getInstanceList()) {
            if (string2.indexOf("Sun:AppServer") == -1) continue;
            int n = string2.indexOf(93);
            string = string2.substring(1, n);
            break;
        }
        return string;
    }

    public static void setProjectName(FileObject fileObject, String string, String string2) {
        try {
            File file = FileUtil.toFile((FileObject)fileObject.getFileObject("nbproject/project.xml"));
            Document document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, null, null);
            NodeList nodeList = document.getElementsByTagNameNS(string, "name");
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    SoaSampleUtils.replaceText(element, string2);
                }
                SoaSampleUtils.saveXml(document, fileObject, "nbproject/project.xml");
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private static void replaceText(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            text.setNodeValue(string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document document, FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public static void insertParameters(FileObject fileObject, String string) {
        Enumeration enumeration = fileObject.getData(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (fileObject2.isFolder() || !fileObject2.getExt().toLowerCase().equals("xml") && !fileObject2.getExt().toLowerCase().equals("properties")) continue;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string2;
                InputStream inputStream = fileObject2.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    string2 = string2.replace("__BPELPROJECTNAME__", string);
                    stringBuffer.append(string2);
                    stringBuffer.append("\n");
                }
                File file = FileUtil.toFile((FileObject)fileObject2);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.write(stringBuffer.toString());
                printWriter.flush();
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }
}

