/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.filesystems.FileObject;

public class PreprocessorFileFilterImplementation
implements JavaFileFilterImplementation,
PropertyChangeListener,
AntProjectListener {
    private HashMap<String, String> abilities;
    private HashMap<String, String> defAbilities;
    private ProjectConfigurationsHelper pch;
    private AntProjectHelper aph;
    private FileObject srcRoot;
    private HashSet<ChangeListener> changeListeners = new HashSet();

    PreprocessorFileFilterImplementation(ProjectConfigurationsHelper pch, AntProjectHelper aph) {
        this.pch = pch;
        this.aph = aph;
        pch.addPropertyChangeListener(this);
        aph.addAntProjectListener((AntProjectListener)this);
    }

    public Reader filterReader(final Reader r) {
        if (!this.pch.isPreprocessorOn()) {
            return r;
        }
        final StringWriter sw = new StringWriter();
        new CommentingPreProcessor(new CommentingPreProcessor.Source(){

            public Reader createReader() throws IOException {
                return r;
            }
        }, new CommentingPreProcessor.Destination(){

            public Writer createWriter(boolean validOutput) throws IOException {
                return sw;
            }

            public void doInsert(int line, String s) throws IOException {
            }

            public void doRemove(int line, int column, int length) throws IOException {
            }
        }, this.getAbilities()).run();
        return new StringReader(sw.toString());
    }

    public CharSequence filterCharSequence(final CharSequence charSequence) {
        if (!this.pch.isPreprocessorOn()) {
            return charSequence;
        }
        final StringWriter sw = new StringWriter();
        new CommentingPreProcessor(new CommentingPreProcessor.Source(){

            public Reader createReader() throws IOException {
                return new StringReader(((Object)charSequence).toString());
            }
        }, new CommentingPreProcessor.Destination(){

            public Writer createWriter(boolean validOutput) throws IOException {
                return sw;
            }

            public void doInsert(int line, String s) throws IOException {
            }

            public void doRemove(int line, int column, int length) throws IOException {
            }
        }, this.getAbilities()).run();
        return sw.toString();
    }

    public Writer filterWriter(final Writer w) {
        if (!this.pch.isPreprocessorOn()) {
            return w;
        }
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                new CommentingPreProcessor(new CommentingPreProcessor.Source(){

                    public Reader createReader() throws IOException {
                        return new StringReader(this.getBuffer().toString());
                    }
                }, new CommentingPreProcessor.Destination(){

                    public Writer createWriter(boolean validOutput) throws IOException {
                        return w;
                    }

                    public void doInsert(int line, String s) throws IOException {
                    }

                    public void doRemove(int line, int column, int length) throws IOException {
                    }
                }, (Map)PreprocessorFileFilterImplementation.this.getDefaultAbilities()).run();
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.fireChange();
    }

    public void propertiesChanged(AntProjectEvent ev) {
        if ("nbproject/project.properties".equals(ev.getPath())) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        this.abilities = null;
        this.defAbilities = null;
        ChangeEvent ev = new ChangeEvent(this);
        HashSet<ChangeListener> hashSet = this.changeListeners;
        synchronized (hashSet) {
            for (ChangeListener ch : this.changeListeners) {
                ch.stateChanged(ev);
            }
        }
    }

    private HashMap<String, String> getDefaultAbilities() {
        HashMap<String, String> identifiers = this.defAbilities;
        if (identifiers == null) {
            ProjectConfiguration cfg = this.pch.getDefaultConfiguration();
            identifiers = new HashMap();
            identifiers.putAll(this.pch.getAbilitiesFor(cfg));
            identifiers.put(cfg.getDisplayName(), null);
            this.defAbilities = identifiers;
        }
        return identifiers;
    }

    private HashMap<String, String> getAbilities() {
        HashMap<String, String> identifiers = this.abilities;
        if (identifiers == null) {
            ProjectConfiguration cfg = this.pch.getActiveConfiguration();
            identifiers = new HashMap();
            identifiers.putAll(this.pch.getAbilitiesFor(cfg));
            identifiers.put(cfg.getDisplayName(), null);
            this.abilities = identifiers;
        }
        return identifiers;
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        HashSet<ChangeListener> hashSet = this.changeListeners;
        synchronized (hashSet) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        HashSet<ChangeListener> hashSet = this.changeListeners;
        synchronized (hashSet) {
            this.changeListeners.remove(listener);
        }
    }
}

