/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.mimelookup.impl.ClassInfoStorage;
import org.netbeans.modules.editor.mimelookup.impl.FolderPathLookup;
import org.netbeans.modules.editor.mimelookup.impl.InstanceProviderLookup;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public class SwitchLookup
extends Lookup {
    private static final Logger LOG = Logger.getLogger(SwitchLookup.class.getName());
    static final String ROOT_FOLDER = "Editors";
    private MimePath mimePath;
    private final String LOCK = new String("SwitchLookup.LOCK");
    private MappingListener listener;
    private Map<String, UpdatableProxyLookup> classLookups = new HashMap<String, UpdatableProxyLookup>();
    private Map<List<String>, Lookup> pathsLookups = new HashMap<List<String>, Lookup>();
    private Map<String, ClassInfoStorage.Info> classInfos = new HashMap<String, ClassInfoStorage.Info>();
    private Map<List<String>, Set<String>> pathsToClasses = new HashMap<List<String>, Set<String>>();

    public SwitchLookup(MimePath mimePath) {
        this.mimePath = mimePath;
        this.listener = new MappingListener();
        ClassInfoStorage.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)ClassInfoStorage.getInstance()));
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return this.findLookup(template.getType()).lookup(template);
    }

    public <T> T lookup(Class<T> clazz) {
        return (T)this.findLookup(clazz).lookup(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup findLookup(Class clazz) {
        String string = this.LOCK;
        synchronized (string) {
            String className = clazz.getName();
            UpdatableProxyLookup lookup = this.classLookups.get(className);
            if (lookup == null) {
                ClassInfoStorage.Info classInfo = ClassInfoStorage.getInstance().getInfo(className);
                this.classInfos.put(className, classInfo);
                Lookup innerLookup = this.createLookup(classInfo);
                lookup = new UpdatableProxyLookup(innerLookup);
                this.classLookups.put(className, lookup);
            }
            return lookup;
        }
    }

    private Lookup createLookup(ClassInfoStorage.Info classInfo) {
        Lookup lookup;
        List<String> paths = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, classInfo.getExtraPath());
        if (classInfo.getInstanceProviderClass() != null) {
            lookup = this.getLookupForProvider(paths, classInfo.getInstanceProvider());
        } else {
            Set<String> pathsUsers = this.pathsToClasses.get(paths);
            if (pathsUsers == null) {
                pathsUsers = new HashSet<String>();
                this.pathsToClasses.put(paths, pathsUsers);
            }
            pathsUsers.add(classInfo.getClassName());
            lookup = this.getLookupForPaths(paths);
        }
        return lookup;
    }

    private Lookup getLookupForPaths(List<String> paths) {
        Object lookup = this.pathsLookups.get(paths);
        if (lookup == null) {
            lookup = new FolderPathLookup(paths.toArray(new String[paths.size()]));
            this.pathsLookups.put(paths, (Lookup)lookup);
        }
        return lookup;
    }

    private Lookup getLookupForProvider(List<String> paths, InstanceProvider instanceProvider) {
        return new InstanceProviderLookup(paths.toArray(new String[paths.size()]), instanceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildLookup(String className) {
        String string = this.LOCK;
        synchronized (string) {
            ClassInfoStorage.Info classInfo;
            UpdatableProxyLookup classLookup = this.classLookups.get(className);
            if (classLookup == null) {
                return;
            }
            ClassInfoStorage.Info currentClassInfo = this.classInfos.get(className);
            if (currentClassInfo.equals(classInfo = ClassInfoStorage.getInstance().getInfo(className))) {
                return;
            }
            if (currentClassInfo.getInstanceProviderClass() == null) {
                List<String> currentPaths = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, currentClassInfo.getExtraPath());
                Set<String> currentPathsUsers = this.pathsToClasses.get(currentPaths);
                currentPathsUsers.remove(className);
                if (currentPathsUsers.isEmpty()) {
                    this.pathsToClasses.remove(currentPaths);
                    this.pathsLookups.remove(currentPaths);
                }
            }
            this.classInfos.put(className, classInfo);
            Lookup innerLookup = this.createLookup(classInfo);
            classLookup.setLookupsEx(innerLookup);
        }
    }

    private static List<String> computePaths(MimePath mimePath, String prefixPath, String suffixPath) {
        try {
            Method m = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
            m.setAccessible(true);
            List paths = (List)m.invoke((Object)mimePath, prefixPath, suffixPath);
            return paths;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", e);
            StringBuilder sb = new StringBuilder();
            if (prefixPath != null && prefixPath.length() > 0) {
                sb.append(prefixPath);
            }
            if (mimePath.size() > 0) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(mimePath.getPath());
            }
            if (suffixPath != null && suffixPath.length() > 0) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(suffixPath);
            }
            return Collections.singletonList(sb.toString());
        }
    }

    private final class MappingListener
    implements PropertyChangeListener {
        private MappingListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            for (String className : NbCollections.checkedSetByFilter((Set)((Set)evt.getNewValue()), String.class, (boolean)true)) {
                SwitchLookup.this.rebuildLookup(className);
            }
        }
    }

    private static final class UpdatableProxyLookup
    extends ProxyLookup {
        public UpdatableProxyLookup() {
        }

        public UpdatableProxyLookup(Lookup ... lookups) {
            super(lookups);
        }

        public void setLookupsEx(Lookup ... lookups) {
            this.setLookups(lookups);
        }
    }
}

