/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.encapsulation;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class ClassEncapsulation {
    private static final String ACTION_PATH = "Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-InnerToOuterAction.instance";
    private static final Logger LOG = Logger.getLogger(ClassEncapsulation.class.getName());
    static final String ALLOW_ENUMS_KEY = "allow.enums";
    static final boolean ALLOW_ENUMS_DEFAULT = false;

    public static ErrorDescription publicCls(HintContext hintContext) {
        assert (hintContext != null);
        return ClassEncapsulation.create(hintContext, Modifier.PUBLIC, NbBundle.getMessage(ClassEncapsulation.class, (String)"TXT_PublicInnerClass"), "PublicInnerClass");
    }

    public static ErrorDescription protectedCls(HintContext hintContext) {
        assert (hintContext != null);
        return ClassEncapsulation.create(hintContext, Modifier.PROTECTED, NbBundle.getMessage(ClassEncapsulation.class, (String)"TXT_ProtectedInnerClass"), "ProtectedInnerClass");
    }

    public static ErrorDescription packageCls(HintContext hintContext) {
        assert (hintContext != null);
        return ClassEncapsulation.create(hintContext, null, NbBundle.getMessage(ClassEncapsulation.class, (String)"TXT_PackageInnerClass"), "PackageVisibleInnerClass");
    }

    private static ErrorDescription create(HintContext hintContext, Modifier modifier, String string, String string2) {
        assert (hintContext != null);
        assert (string != null);
        assert (string2 != null);
        TreePath treePath = hintContext.getPath();
        Tree tree = treePath.getParentPath().getLeaf();
        if (tree.getKind() != Tree.Kind.CLASS) {
            return null;
        }
        if (!ClassEncapsulation.hasRequiredVisibility(((ClassTree)treePath.getLeaf()).getModifiers().getFlags(), modifier)) {
            return null;
        }
        if (hintContext.getPreferences().getBoolean(ALLOW_ENUMS_KEY, false) && hintContext.getInfo().getTreeUtilities().isEnum((ClassTree)treePath.getLeaf())) {
            return null;
        }
        return ErrorDescriptionFactory.forName(hintContext, treePath, string, new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)hintContext.getInfo())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), treePath, string2));
    }

    private static boolean hasRequiredVisibility(Set<Modifier> set, Modifier modifier) {
        return modifier != null ? set.contains((Object)modifier) : (set.isEmpty() ? true : !EnumSet.copyOf(set).removeAll(EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC)));
    }

    public static final class CustomizerImpl
    extends OneCheckboxCustomizerProvider {
        public CustomizerImpl() {
            super(NbBundle.getMessage(ClassEncapsulation.class, (String)"DN_IgnoreEnumForInnerClass"), NbBundle.getMessage(ClassEncapsulation.class, (String)"TP_IgnoreEnumForInnerClass"), ClassEncapsulation.ALLOW_ENUMS_KEY, false);
        }
    }

    private static class FixImpl
    implements Fix {
        private final TreePathHandle handle;

        private FixImpl(TreePathHandle treePathHandle) {
            assert (treePathHandle != null);
            this.handle = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(ClassEncapsulation.class, (String)"FIX_MoveInnerToOuter");
        }

        public ChangeInfo implement() throws Exception {
            FileObject fileObject = this.handle.getFileObject();
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            if (fileObject != null && fileObject == FixImpl.getFileObject(jTextComponent)) {
                final int[] nArray = new int[]{-1};
                JavaSource.forFileObject((FileObject)fileObject).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.PARSED);
                        TreePath treePath = FixImpl.this.handle.resolve((CompilationInfo)compilationController);
                        if (treePath != null && treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
                            nArray[0] = (int)compilationController.getTrees().getSourcePositions().getStartPosition(treePath.getCompilationUnit(), (ClassTree)treePath.getLeaf()) + 1;
                        }
                    }
                }, true);
                this.invokeRefactoring(jTextComponent, nArray[0]);
            }
            return null;
        }

        private static FileObject getFileObject(JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return null;
            }
            Document document = jTextComponent.getDocument();
            if (document == null) {
                return null;
            }
            Object object = document.getProperty("stream");
            if (object instanceof FileObject) {
                return (FileObject)object;
            }
            if (object instanceof DataObject) {
                return ((DataObject)object).getPrimaryFile();
            }
            return null;
        }

        private void invokeRefactoring(final JTextComponent jTextComponent, final int n) {
            assert (jTextComponent != null);
            FileObject fileObject = FileUtil.getConfigRoot();
            FileObject fileObject2 = fileObject.getFileObject(ClassEncapsulation.ACTION_PATH);
            if (fileObject2 == null) {
                LOG.warning("Move Inner to Outer action not found at: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-InnerToOuterAction.instance");
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
                if (instanceCookie == null) {
                    throw new IOException();
                }
                final Object object = instanceCookie.instanceCreate();
                if (!(object instanceof Action)) {
                    throw new IOException();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (n != -1) {
                            jTextComponent.setCaretPosition(n);
                        }
                        ((Action)object).actionPerformed(new ActionEvent(jTextComponent, 0, null));
                    }
                });
            }
            catch (IOException iOException) {
                LOG.warning("Move Inner to Outer action is broken: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-InnerToOuterAction.instance");
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.warning("Move Inner to Outer action is broken: Actions/Refactoring/org-netbeans-modules-refactoring-java-api-ui-InnerToOuterAction.instance");
                return;
            }
        }
    }
}

