/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.options;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.groovy.support.options.Model;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class GroovyPanel
extends JPanel {
    JTabbedPane tabbedPanel;
    private LookupListener listener = new LookupListenerImpl();
    private Model model = new Model(this.listener);
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            GroovyPanel.this.handleTabSwitched();
        }
    };

    GroovyPanel() {
    }

    public void update() {
        String category = this.tabbedPanel.getTitleAt(this.tabbedPanel.getSelectedIndex());
        this.model.update(category);
    }

    public void applyChanges() {
        this.model.applyChanges();
    }

    public void cancel() {
        this.model.cancel();
    }

    public HelpCtx getHelpCtx() {
        return this.model.getHelpCtx(this.tabbedPanel != null ? (JComponent)this.tabbedPanel.getSelectedComponent() : null);
    }

    public boolean dataValid() {
        return this.model.isValid();
    }

    public boolean isChanged() {
        return this.model.isChanged();
    }

    public Lookup getLookup() {
        return this.model.getLookup();
    }

    void init(Lookup masterLookup) {
        this.tabbedPanel = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPanel, "Center");
        this.initTabbedPane(masterLookup);
    }

    private void initTabbedPane(Lookup masterLookup) {
        this.tabbedPanel.removeChangeListener(this.changeListener);
        this.tabbedPanel.removeAll();
        for (String category : this.model.getCategories()) {
            this.tabbedPanel.addTab(category, new JLabel(category));
        }
        this.tabbedPanel.addChangeListener(this.changeListener);
        this.handleTabSwitched();
    }

    private void handleTabSwitched() {
        int selectedIndex = this.tabbedPanel.getSelectedIndex() >= 0 ? this.tabbedPanel.getSelectedIndex() : 0;
        String category = this.tabbedPanel.getTitleAt(selectedIndex);
        if (this.tabbedPanel.getSelectedComponent() instanceof JLabel) {
            this.tabbedPanel.setComponentAt(this.tabbedPanel.getSelectedIndex(), this.model.getPanel(category));
            ((JComponent)this.tabbedPanel.getSelectedComponent()).setBorder(new EmptyBorder(11, 11, 11, 11));
        }
        this.model.update(category);
        this.firePropertyChange("helpCtx", null, null);
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        public void resultChanged(LookupEvent ev) {
            Lookup masterLookup = GroovyPanel.this.model.getLookup();
            GroovyPanel.this.model = new Model(GroovyPanel.this.listener);
            GroovyPanel.this.initTabbedPane(masterLookup);
        }
    }
}

