/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectCreateData;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.RailsProjectProperties;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectGenerator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RailsProjectGenerator {
    private static final Logger LOGGER = Logger.getLogger(RailsProjectGenerator.class.getName());
    static final Pattern RAILS_GENERATOR_PATTERN = Pattern.compile("^   (   create|    force|identical|     skip)\\s+([\\w|/]+\\.\\S+)\\s*$");

    private RailsProjectGenerator() {
    }

    public static RakeProjectHelper createProject(RailsProjectCreateData data) throws IOException {
        FileObject dirFO = FileUtil.createFolder((File)data.getDir());
        RubyPlatform platform = data.getPlatform();
        RailsDatabaseConfiguration railsDb = data.getDatabase();
        if (data.isCreate()) {
            File spec;
            String rails = platform.getRails();
            File railsF = new File(rails);
            FileObject railsFO = FileUtil.toFileObject((File)railsF);
            boolean runThroughRuby = railsFO != null ? RubyUtils.isRubyFile((FileObject)railsFO) : false;
            RubyExecutionDescriptor desc = null;
            String displayName = NbBundle.getMessage(RailsProjectGenerator.class, (String)"GenerateRails");
            String railsDbArg = railsDb.railsGenerationParam() == null ? null : "--database=" + railsDb.railsGenerationParam();
            String railsVersionArg = data.getRailsVersion() == null ? null : "_" + data.getRailsVersion() + "_";
            File pwd = data.getDir().getParentFile();
            ArrayList<String> argList = new ArrayList<String>();
            if (railsVersionArg != null) {
                argList.add(railsVersionArg);
            }
            if (runThroughRuby) {
                argList.add(data.getName());
            }
            if (railsDbArg != null) {
                argList.add(railsDbArg);
            }
            if (data.getOptions() != null) {
                argList.add(data.getOptions());
            }
            String[] args = argList.toArray(new String[argList.size()]);
            if (runThroughRuby) {
                desc = new RubyExecutionDescriptor(platform, displayName, pwd, rails);
                desc.additionalArgs(args);
            } else {
                desc = new RubyExecutionDescriptor(platform, displayName, pwd, data.getName());
                desc.additionalArgs(args);
                desc.cmd(railsF);
            }
            desc.runThroughRuby(runThroughRuby);
            desc.fileLocator((LineConvertors.FileLocator)new DirectoryFileLocator(dirFO));
            LineConvertor convertor = LineConvertors.filePattern((LineConvertors.FileLocator)desc.getFileLocator(), (Pattern)RAILS_GENERATOR_PATTERN, null, (int)2, (int)-1);
            desc.addStandardRecognizers();
            desc.addErrConvertor(convertor);
            desc.addOutConvertor(convertor);
            desc.setOutProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    return InputProcessors.ansiStripping((InputProcessor)defaultProcessor);
                }
            });
            RubyProcessCreator rpc = new RubyProcessCreator(desc);
            ExecutionService es = ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName);
            try {
                es.run().get();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (platform.getGemManager().getLatestVersion("rspec") != null && !(spec = new File(data.getDir(), "spec")).exists()) {
                spec.mkdirs();
            }
            dirFO.getFileSystem().refresh(true);
        }
        RakeProjectHelper h = RailsProjectGenerator.createProject(dirFO, platform, data);
        Project p = ProjectManager.getDefault().findProject(dirFO);
        railsDb.editConfig((RailsProject)p);
        ProjectManager.getDefault().saveProject(p);
        if (data.isDeploy()) {
            RailsProjectGenerator.runWarblePluginize(platform, p);
        }
        RakeSupport.refreshTasks((Project)p);
        String railsVersion = data.getRailsVersion() != null ? data.getRailsVersion() : platform.getGemManager().getLatestVersion("rails");
        Util.logUsage(RailsProjectGenerator.class, (String)"USG_PROJECT_CREATE_RAILS", (Object[])new Object[]{platform.getInfo().getKind(), platform.getInfo().getPlatformVersion(), platform.getInfo().getGemVersion(), RailsProjectGenerator.getServerIdForLogging(data.getServerInstanceId(), platform), data.getDatabase().getDisplayName(), railsVersion});
        return h;
    }

    private static String getServerIdForLogging(String serverURI, RubyPlatform platform) {
        RubyInstance serverInstance = ServerRegistry.getDefault().getServer(serverURI, platform);
        return serverInstance != null ? serverInstance.getDisplayName() : "";
    }

    private static void runWarblePluginize(RubyPlatform platform, Project project) {
        String warble = platform.findExecutable("warble");
        if (warble == null) {
            LOGGER.warning("Could not find warble executable, platform: " + platform);
            return;
        }
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, NbBundle.getMessage(RailsProjectGenerator.class, (String)"WarblePluginize"), FileUtil.toFile((FileObject)project.getProjectDirectory()), new File(warble).getAbsolutePath());
        desc.additionalArgs(new String[]{"pluginize"});
        RubyProcessCreator processCreator = new RubyProcessCreator(desc);
        desc.addStandardRecognizers();
        ExecutionService.newService((Callable)processCreator, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)NbBundle.getMessage(RailsProjectGenerator.class, (String)"WarblePluginize")).run();
    }

    private static RakeProjectHelper createProject(FileObject dirFO, RubyPlatform platform, RailsProjectCreateData createData) throws IOException {
        RakeProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.ruby.railsprojects");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/rails-project/1", "name");
        nameEl.appendChild(doc.createTextNode(createData.getName()));
        data.appendChild(nameEl);
        EditableProperties privateProperties = h.getProperties("nbproject/private/private.properties");
        privateProperties.put("rails.servertype", createData.getServerInstanceId());
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        RubyInstance instance = ServerRegistry.getDefault().getServer(createData.getServerInstanceId(), platform);
        int port = instance != null ? instance.getRailsPort() : 3000;
        ep.setProperty("rails.port", String.valueOf(port));
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        h.putPrimaryConfigurationData(data, true);
        RailsProjectProperties.storePlatform((EditableProperties)ep, (RubyPlatform)platform);
        h.putProperties("nbproject/private/private.properties", privateProperties);
        h.putProperties("nbproject/project.properties", ep);
        return h;
    }
}

