/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsFileLocator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.rubyproject.Migrations;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunner;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class MigrateAction
extends SystemAction
implements ContextAwareAction {
    private static final Logger LOGGER = Logger.getLogger(MigrateAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(MigrateAction.class, (String)"LBL_rake_migrate");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent e) {
        assert (false) : "Action should never be called without a context";
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextAction(actionContext);
    }

    private static JMenu createMenu(RailsProject project) {
        return new LazyMenu(project);
    }

    static void buildMenu(JMenu menu, RailsProject project) {
        JMenuItem menuitem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"CurrentVersion"));
        menuitem.addActionListener(new MigrateMenuItemHandler(project, -1L));
        menu.add(menuitem);
        menuitem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"Version0", (Object)0));
        menuitem.addActionListener(new MigrateMenuItemHandler(project, 0L));
        menu.add(menuitem);
        List migrations = Migrations.getMigrations((Project)project);
        HashMap<Long, String> versions = new HashMap<Long, String>(migrations.size());
        for (Migrations.Migration each : migrations) {
            versions.put(each.getVersion(), "- " + each.getDescription());
        }
        if (!versions.isEmpty()) {
            menu.addSeparator();
            ArrayList<Long> sortedList = new ArrayList<Long>();
            sortedList.addAll(versions.keySet());
            Collections.sort(sortedList);
            MigrateAction.buildMenu(project, menu, 0, sortedList.size() - 1, sortedList, versions);
        }
    }

    private static void buildMenu(RailsProject project, JMenu menu, int startIndex, int endIndex, List<Long> versions, Map<Long, String> descriptions) {
        int MAX_ITEMS = 20;
        int MENU_COUNT = 15;
        if (endIndex - startIndex > MAX_ITEMS) {
            int length = endIndex - startIndex;
            int sqrt = (int)Math.sqrt(length);
            if (sqrt < MENU_COUNT) {
                MENU_COUNT = sqrt;
            }
            int divisions = length / MENU_COUNT;
            if (length % MENU_COUNT == 0) {
                --MENU_COUNT;
            }
            for (int i = 0; i <= MENU_COUNT; ++i) {
                int start = i * divisions + startIndex;
                int end = (i + 1) * divisions - 1 + startIndex;
                if (start > endIndex) {
                    return;
                }
                if (end > endIndex) {
                    end = endIndex;
                } else if (end == endIndex - 1) {
                    end = endIndex;
                }
                if (end == start) {
                    MigrateAction.buildMenu(project, menu, start, end, versions, descriptions);
                    continue;
                }
                long startVersion = versions.get(start);
                long endVersion = versions.get(end);
                JMenu submenu = new JMenu(NbBundle.getMessage(MigrateAction.class, (String)"VersionXtoY", (Object)Long.toString(startVersion), (Object)Long.toString(endVersion)));
                MigrateAction.buildMenu(project, submenu, start, end, versions, descriptions);
                menu.add(submenu);
            }
            return;
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            long version = versions.get(i);
            String description = descriptions.get(version);
            if (description == null) {
                description = "";
            }
            JMenuItem menuitem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"VersionX", (Object)Long.toString(version), (Object)description));
            menuitem.addActionListener(new MigrateMenuItemHandler(project, version));
            menu.add(menuitem);
        }
    }

    private static final class MigrateMenuItemHandler
    implements ActionListener,
    Runnable {
        private final RailsProject project;
        private final long version;
        private static final String WARN_ON_CLEAR_PREF_ID = "confirmMigratingToVersion0";

        public MigrateMenuItemHandler(RailsProject project, long version) {
            this.project = project;
            this.version = version;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)true)) {
                return;
            }
            LifecycleManager.getDefault().saveAll();
            RailsFileLocator fileLocator = new RailsFileLocator(Lookup.EMPTY, (Project)this.project);
            String displayName = NbBundle.getMessage(MigrateAction.class, (String)"Migration");
            File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            if (this.version == 0L && !this.confirmReset()) {
                return;
            }
            RakeRunner runner = new RakeRunner((RubyBaseProject)this.project);
            runner.setPWD(pwd);
            runner.setDisplayName(displayName);
            runner.setFileLocator((RubyFileLocator)fileLocator);
            runner.showWarnings(true);
            if (this.version != -1L) {
                runner.setParameters(new String[]{"VERSION=" + Long.toString(this.version)});
            }
            runner.run(new String[]{"db:migrate"});
        }

        private boolean confirmReset() {
            Preferences prefs = NbPreferences.forModule(MigrateAction.class);
            if (!prefs.getBoolean(WARN_ON_CLEAR_PREF_ID, true)) {
                return true;
            }
            JCheckBox showWarning = new JCheckBox(NbBundle.getMessage(MigrateAction.class, (String)"ShowConfirmDialog"));
            showWarning.setSelected(true);
            DialogDescriptor dd = new DialogDescriptor((Object)NbBundle.getMessage(MigrateAction.class, (String)"ConfirmReset"), NbBundle.getMessage(MigrateAction.class, (String)"ConfirmResetTitle"));
            Object[] options = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.NO_OPTION, DialogDescriptor.CANCEL_OPTION};
            dd.setOptions(options);
            dd.setClosingOptions(options);
            dd.setAdditionalOptions(new Object[]{showWarning});
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (result.equals(NotifyDescriptor.OK_OPTION) || result.equals(NotifyDescriptor.NO_OPTION)) {
                prefs.putBoolean(WARN_ON_CLEAR_PREF_ID, showWarning.isSelected());
            }
            return result.equals(NotifyDescriptor.OK_OPTION);
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final RailsProject project;
        private boolean initialized = false;

        public LazyMenu(RailsProject project) {
            super(((MigrateAction)SystemAction.get(MigrateAction.class)).getName());
            this.project = project;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                this.initialized = true;
                super.removeAll();
                MigrateAction.buildMenu(this, this.project);
            }
            return super.getPopupMenu();
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final RailsProject project;

        public ContextAction(Lookup lkp) {
            super(((MigrateAction)SystemAction.get(MigrateAction.class)).getName());
            Collection apcs = lkp.lookupAll(RailsProject.class);
            this.project = apcs.size() == 1 ? (RailsProject)((Object)apcs.iterator().next()) : null;
            super.setEnabled(this.project != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return MigrateAction.createMenu(this.project);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        @Override
        public void setEnabled(boolean b) {
            assert (false) : "No modifications to enablement status permitted";
        }
    }
}

