/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ide;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Format;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.ide.DebugSupport;
import org.netbeans.modules.tomcat5.ide.MonitorSupport;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;
import org.netbeans.modules.tomcat5.util.LogManager;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.netbeans.modules.tomcat5.util.Utils;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.xml.sax.SAXException;

public final class StartTomcat
extends StartServer
implements ProgressObject {
    public static final String CATALINA_BAT = "catalina.bat";
    public static final String CATALINA_SH = "catalina.sh";
    public static final String CATALINA_50_BAT = "catalina.50.bat";
    public static final String CATALINA_50_SH = "catalina.50.sh";
    public static final String SETCLASSPATH_BAT = "setclasspath.bat";
    public static final String SETCLASSPATH_SH = "setclasspath.sh";
    public static final String TAG_CATALINA_HOME = "catalina_home";
    public static final String TAG_CATALINA_BASE = "catalina_base";
    public static final String TAG_JPDA = "jpda";
    public static final String TAG_JPDA_STARTUP = "jpda_startup";
    public static final String TAG_EXEC_CMD = "catalina";
    public static final String TAG_EXEC_STARTUP = "exec_startup";
    public static final String TAG_EXEC_SHUTDOWN = "exec_shutdown";
    public static final String TAG_SECURITY_OPT = "security_option";
    public static final String TAG_FORCE_OPT = "force_option";
    public static final String TAG_DEBUG_CMD = "catalina";
    private static final int MODE_RUN = 0;
    private static final int MODE_DEBUG = 1;
    private static final int MODE_PROFILE = 2;
    private static final long TIMEOUT_DELAY = 180000L;
    private static final Logger LOGGER = Logger.getLogger(StartTomcat.class.getName());
    private TomcatManager tm;
    private ProgressEventSupport pes;
    private int currentServerPort;
    private static Map isDebugModeUri = Collections.synchronizedMap(new HashMap(2, 1.0f));

    public StartTomcat(DeploymentManager deploymentManager) {
        assert (deploymentManager instanceof TomcatManager) : "Illegal DeploymentManager instance: " + deploymentManager.getClass().getName();
        this.tm = (TomcatManager)deploymentManager;
        this.tm.setStartTomcat(this);
        this.pes = new ProgressEventSupport((Object)this);
        this.currentServerPort = this.tm.getServerPort();
    }

    public boolean supportsStartDeploymentManager() {
        return true;
    }

    public boolean supportsStartProfiling(Target target) {
        return true;
    }

    public ProgressObject startDeploymentManager() {
        LOGGER.log(Level.FINE, "StartTomcat.startDeploymentManager called on " + this.tm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.START, "", StateType.RUNNING));
        RequestProcessor.getDefault().post((Runnable)new StartRunnable(0, CommandType.START, null), 0, 5);
        isDebugModeUri.remove(this.tm.getUri());
        return this;
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForTargetList() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return false;
    }

    public boolean needsRestart(Target target) {
        return this.tm.getNeedsRestart();
    }

    public boolean isRunning() {
        return this.tm.isRunning(true);
    }

    public boolean isDebuggable(Target target) {
        if (!isDebugModeUri.containsKey(this.tm.getUri())) {
            return false;
        }
        if (!this.isRunning()) {
            isDebugModeUri.remove(this.tm.getUri());
            return false;
        }
        return true;
    }

    public ProgressObject stopDeploymentManager() {
        LOGGER.log(Level.FINE, "StartTomcat.stopDeploymentManager called on " + this.tm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.STOP, "", StateType.RUNNING));
        RequestProcessor.getDefault().post((Runnable)new StartRunnable(0, CommandType.STOP, null), 0, 5);
        isDebugModeUri.remove(this.tm.getUri());
        return this;
    }

    public ProgressObject startDebugging(Target target) {
        LOGGER.log(Level.FINE, "StartTomcat.startDebugging called on " + this.tm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.START, "", StateType.RUNNING));
        RequestProcessor.getDefault().post((Runnable)new StartRunnable(1, CommandType.START, null), 0, 5);
        return this;
    }

    public ProgressObject startProfiling(Target target, ProfilerServerSettings profilerServerSettings) {
        LOGGER.log(Level.FINE, "StartTomcat.startProfiling called on " + this.tm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.START, "", StateType.RUNNING));
        RequestProcessor.getDefault().post((Runnable)new StartRunnable(2, CommandType.START, profilerServerSettings), 0, 5);
        return this;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        TomcatProperties tomcatProperties = this.tm.getTomcatProperties();
        ServerDebugInfo serverDebugInfo = tomcatProperties.getDebugType().toLowerCase().indexOf("socket") != -1 ? new ServerDebugInfo("localhost", tomcatProperties.getDebugPort()) : new ServerDebugInfo("localhost", tomcatProperties.getSharedMem());
        return serverDebugInfo;
    }

    private boolean isStopped() {
        Process process = this.tm.getTomcatProcess();
        if (process != null) {
            try {
                process.exitValue();
                return true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return false;
            }
        }
        int n = this.tm.getTomcatProperties().getRunningCheckTimeout();
        return !Utils.pingTomcat(this.tm.getServerPort(), n);
    }

    public ProgressObject startServer(Target target) {
        return null;
    }

    public boolean supportsStartDebugging(Target target) {
        return true;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.pes.getDeploymentStatus();
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[0];
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.pes.addProgressListener(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.pes.removeProgressListener(progressListener);
    }

    public String toString() {
        return "StartTomcat [" + this.tm + "]";
    }

    public int getCurrentServerPort() {
        return this.currentServerPort;
    }

    private static NbProcessDescriptor defaultExecDesc(String string, String string2, String string3) {
        return new NbProcessDescriptor("{" + string + "}", "{" + string2 + "}" + " {" + string3 + "}", NbBundle.getMessage(StartTomcat.class, (String)"MSG_TomcatExecutionCommand"));
    }

    private static NbProcessDescriptor defaultExecDesc(String string, String string2) {
        return new NbProcessDescriptor("{" + string + "}", "{" + string2 + "}", NbBundle.getMessage(StartTomcat.class, (String)"MSG_TomcatExecutionCommand"));
    }

    private static NbProcessDescriptor defaultDebugStartDesc(String string, String string2, String string3) {
        return new NbProcessDescriptor("{" + string + "}", "{jpda} {" + string2 + "}" + " {" + string3 + "}", NbBundle.getMessage(StartTomcat.class, (String)"MSG_TomcatExecutionCommand"));
    }

    private static NbProcessDescriptor defaultDebugStartDesc(String string, String string2) {
        return new NbProcessDescriptor("{" + string + "}", "{jpda} {" + string2 + "}", NbBundle.getMessage(StartTomcat.class, (String)"MSG_TomcatExecutionCommand"));
    }

    private String getJavaHome(JavaPlatform javaPlatform) {
        FileObject fileObject = (FileObject)javaPlatform.getInstallFolders().iterator().next();
        return FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
    }

    private File getStartupScript() {
        TomcatProperties tomcatProperties = this.tm.getTomcatProperties();
        if (tomcatProperties.getCustomScript()) {
            return new File(tomcatProperties.getScriptPath());
        }
        String string = Utilities.isWindows() ? CATALINA_BAT : CATALINA_SH;
        return new File(tomcatProperties.getCatalinaHome(), "/bin/" + string);
    }

    private JavaPlatform getJavaPlatform() {
        return this.tm.getTomcatProperties().getJavaPlatform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchCatalinaProperties(File file, boolean bl) {
        File file2 = new File(file, "conf/catalina.properties");
        if (!file2.exists()) {
            return;
        }
        EditableProperties editableProperties = new EditableProperties(false);
        try {
            Object object;
            block18: {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                try {
                    editableProperties.load((InputStream)bufferedInputStream);
                    object = "common.loader";
                    String string = editableProperties.getProperty((String)object);
                    if (string == null) break block18;
                    String string2 = "${catalina.home}/common/endorsed/*.jar";
                    int n = string.indexOf(string2);
                    if (bl) {
                        if (n == -1) {
                            String string3 = "${catalina.home}/" + this.tm.libFolder() + "/*.jar";
                            int n2 = string.indexOf(string3);
                            StringBuffer stringBuffer = new StringBuffer(n2 == -1 ? string : string.substring(0, n2));
                            if (n2 != -1) {
                                stringBuffer.append(string2).append(',').append(string.substring(n2));
                            } else {
                                if (string.trim().length() != 0) {
                                    stringBuffer.append(',');
                                }
                                stringBuffer.append(string2);
                            }
                            editableProperties.setProperty((String)object, stringBuffer.toString());
                            break block18;
                        }
                        return;
                    }
                    if (n != -1) {
                        int n3;
                        String string4 = string.substring(0, n);
                        int n4 = string4.lastIndexOf(44);
                        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n4 == -1 ? n : n4));
                        String string5 = string.substring(n + string2.length());
                        if (n4 == -1 && (n3 = string5.indexOf(44)) != -1) {
                            string5 = string5.substring(n3 + 1);
                        }
                        stringBuffer.append(string5);
                        editableProperties.setProperty((String)object, stringBuffer.toString());
                        break block18;
                    }
                    return;
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            object = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                editableProperties.store((OutputStream)object);
            }
            finally {
                ((FilterOutputStream)object).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.INFO, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
    }

    private static class TomcatFormat
    extends MapFormat {
        private static final long serialVersionUID = 992972967554321415L;

        public TomcatFormat(File file, File file2) {
            super(new HashMap());
            Map map = this.getMap();
            String string = file.getAbsolutePath();
            map.put("catalina", string);
            map.put(StartTomcat.TAG_EXEC_STARTUP, "run");
            map.put(StartTomcat.TAG_EXEC_SHUTDOWN, "stop");
            map.put("catalina", string);
            map.put(StartTomcat.TAG_JPDA, StartTomcat.TAG_JPDA);
            map.put(StartTomcat.TAG_JPDA_STARTUP, "run");
            map.put(StartTomcat.TAG_SECURITY_OPT, "-security");
            map.put(StartTomcat.TAG_FORCE_OPT, "-force");
            map.put(StartTomcat.TAG_CATALINA_HOME, file2.getAbsolutePath());
        }
    }

    private static class StreamConsumer
    implements Runnable {
        private BufferedInputStream in;

        public StreamConsumer(InputStream inputStream) {
            this.in = new BufferedInputStream(inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int n;
                byte[] byArray = new byte[1024];
                while ((n = this.in.read(byArray)) >= 0) {
                    LOGGER.log(Level.FINE, new String(byArray, 0, n));
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, null, iOException);
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class StartRunnable
    implements Runnable {
        private int mode;
        private CommandType command = CommandType.START;
        private ProfilerServerSettings profilerSettings;

        public StartRunnable(int n, CommandType commandType, ProfilerServerSettings profilerServerSettings) {
            this.mode = n;
            this.command = commandType;
            this.profilerSettings = profilerServerSettings;
        }

        @Override
        public synchronized void run() {
            Object object;
            String[] stringArray;
            String[] stringArray2;
            StringBuilder stringBuilder;
            Object object2;
            TomcatProperties tomcatProperties = StartTomcat.this.tm.getTomcatProperties();
            File file = tomcatProperties.getCatalinaHome();
            if (file == null || !file.exists()) {
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_NoHomeDirStart" : "MSG_NoHomeDirStop", StateType.FAILED);
                return;
            }
            File file2 = tomcatProperties.getCatalinaBase();
            if (file2 == null) {
                file2 = file;
            } else {
                if (file2 != null && ((object2 = file2.list()) == null || ((Object)object2).length == 0)) {
                    file2 = StartTomcat.this.tm.createBaseDir(file2, file);
                }
                if (file2 == null) {
                    this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_NoBaseDirStart" : "MSG_NoBaseDirStop", StateType.FAILED);
                    return;
                }
            }
            object2 = StartTomcat.this.getStartupScript();
            if (!((File)object2).exists()) {
                String string = NbBundle.getMessage(StartTomcat.class, (String)(this.command == CommandType.START ? "MSG_StartFailedNoStartScript" : "MSG_StopFailedNoStartScript"), (Object)((File)object2).getAbsolutePath());
                StartTomcat.this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.command, string, StateType.FAILED));
                return;
            }
            if (this.command == CommandType.START) {
                try {
                    MonitorSupport.synchronizeMonitorWithFlag(StartTomcat.this.tm, true);
                }
                catch (IOException iOException) {
                    if (MonitorSupport.getMonitorFlag(StartTomcat.this.tm)) {
                        MonitorSupport.setMonitorFlag(StartTomcat.this.tm, false);
                        this.fireCmdExecProgressEvent(StartTomcat.this.tm.isTomcat60() ? "MSG_enableMonitorSupportErr60" : "MSG_enableMonitorSupportErr", StateType.FAILED);
                    } else {
                        this.fireCmdExecProgressEvent("MSG_disableMonitorSupportErr", StateType.FAILED);
                    }
                    LOGGER.log(Level.INFO, null, iOException);
                    return;
                }
                catch (SAXException sAXException) {
                    LOGGER.log(Level.INFO, null, sAXException);
                }
                try {
                    DebugSupport.allowDebugging(StartTomcat.this.tm);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                }
                catch (SAXException sAXException) {
                    LOGGER.log(Level.INFO, null, sAXException);
                }
            }
            StartTomcat.this.currentServerPort = StartTomcat.this.tm.getServerPort();
            int n = StartTomcat.this.tm.getShutdownPort();
            if (this.command == CommandType.START) {
                if (!Utils.isPortFree(StartTomcat.this.currentServerPort)) {
                    this.fireCmdExecProgressEvent("MSG_StartFailedServerPortInUse", String.valueOf(StartTomcat.this.currentServerPort), StateType.FAILED);
                    return;
                }
                if (!Utils.isPortFree(n)) {
                    this.fireCmdExecProgressEvent("MSG_StartFailedShutdownPortInUse", String.valueOf(n), StateType.FAILED);
                    return;
                }
            }
            String string = tomcatProperties.getJavaOpts();
            if (tomcatProperties.getProxyEnabled()) {
                stringBuilder = new StringBuilder(string);
                stringArray2 = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
                boolean bl = Utilities.isWindows();
                for (String string2 : stringArray2) {
                    if (string.indexOf(string2) != -1 || (stringArray = System.getProperty(string2)) == null) continue;
                    if (bl && "http.nonProxyHosts".equals(string2)) {
                        stringArray = "\"" + (String)stringArray + "\"";
                    }
                    stringBuilder.append(" -D").append(string2).append("=").append((String)stringArray);
                }
                string = stringBuilder.toString();
            }
            stringBuilder = this.mode == 2 ? this.profilerSettings.getJavaPlatform() : StartTomcat.this.getJavaPlatform();
            stringArray2 = stringBuilder.getSpecification().getVersion().toString();
            if (StartTomcat.this.tm.isBundledTomcat()) {
                StartTomcat.this.patchCatalinaProperties(tomcatProperties.getCatalinaDir(), "1.4".equals(stringArray2));
            }
            if (this.mode == 1 && this.command == CommandType.START) {
                NbProcessDescriptor nbProcessDescriptor = null;
                nbProcessDescriptor = tomcatProperties.getSecManager() ? StartTomcat.defaultDebugStartDesc("catalina", StartTomcat.TAG_JPDA_STARTUP, StartTomcat.TAG_SECURITY_OPT) : StartTomcat.defaultDebugStartDesc("catalina", StartTomcat.TAG_JPDA_STARTUP);
                try {
                    String string3;
                    String string4;
                    this.fireCmdExecProgressEvent("MSG_startProcess", StateType.RUNNING);
                    object = null;
                    if (tomcatProperties.getDebugType().toLowerCase().indexOf("socket") != -1) {
                        string4 = "dt_socket";
                        string3 = Integer.toString(tomcatProperties.getDebugPort());
                    } else {
                        string4 = "dt_shmem";
                        string3 = tomcatProperties.getSharedMem();
                    }
                    LOGGER.log(Level.FINE, "transport: " + string4);
                    LOGGER.log(Level.FINE, "address: " + string3);
                    object = nbProcessDescriptor.exec((Format)((Object)new TomcatFormat((File)object2, file)), new String[]{"JAVA_HOME=" + StartTomcat.this.getJavaHome((JavaPlatform)stringBuilder), "JRE_HOME=", "JAVA_OPTS=" + string, "JPDA_TRANSPORT=" + string4, "JPDA_ADDRESS=" + string3, "CATALINA_HOME=" + file.getAbsolutePath(), "CATALINA_BASE=" + file2.getAbsolutePath(), "NB_TOMCAT_JDK=" + (String)stringArray2}, true, new File(file, "bin"));
                    StartTomcat.this.tm.setTomcatProcess((Process)object);
                    this.openLogs();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, null, iOException);
                    this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_StartFailedIOE" : "MSG_StopFailedIOE", ((File)object2).getAbsolutePath(), StateType.FAILED);
                    return;
                }
            }
            if (this.mode == 2 && this.command == CommandType.START) {
                NbProcessDescriptor nbProcessDescriptor = null;
                nbProcessDescriptor = tomcatProperties.getSecManager() ? StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_STARTUP, StartTomcat.TAG_SECURITY_OPT) : StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_STARTUP);
                try {
                    this.fireCmdExecProgressEvent("MSG_StartingInProfileMode", StateType.RUNNING);
                    object = null;
                    String[] stringArray3 = this.profilerSettings.getJvmArgs();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray3.length; ++i) {
                        stringBuffer.append(stringArray3[i]).append(" ");
                    }
                    String[] stringArray4 = new String[]{"JAVA_HOME=" + StartTomcat.this.getJavaHome((JavaPlatform)stringBuilder), "JRE_HOME=", "JAVA_OPTS=" + string, "CATALINA_OPTS=" + stringBuffer.toString(), "CATALINA_HOME=" + file.getAbsolutePath(), "CATALINA_BASE=" + file2.getAbsolutePath(), "NB_TOMCAT_JDK=" + (String)stringArray2};
                    stringArray = this.profilerSettings.getEnv();
                    String[] stringArray5 = new String[stringArray4.length + stringArray.length];
                    System.arraycopy(stringArray, 0, stringArray5, 0, stringArray.length);
                    System.arraycopy(stringArray4, 0, stringArray5, stringArray.length, stringArray4.length);
                    object = nbProcessDescriptor.exec((Format)((Object)new TomcatFormat((File)object2, file)), stringArray5, true, new File(file, "bin"));
                    StartTomcat.this.tm.setTomcatProcess((Process)object);
                    this.openLogs();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, null, iOException);
                    this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_StartFailedIOE" : "MSG_StopFailedIOE", ((File)object2).getAbsolutePath(), StateType.FAILED);
                    return;
                }
            }
            NbProcessDescriptor nbProcessDescriptor = null;
            nbProcessDescriptor = this.command == CommandType.START ? (tomcatProperties.getSecManager() ? StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_STARTUP, StartTomcat.TAG_SECURITY_OPT) : StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_STARTUP)) : (tomcatProperties.getForceStop() && Utilities.isUnix() ? StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_SHUTDOWN, StartTomcat.TAG_FORCE_OPT) : StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_SHUTDOWN));
            try {
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_startProcess" : "MSG_stopProcess", StateType.RUNNING);
                object = nbProcessDescriptor.exec((Format)((Object)new TomcatFormat((File)object2, file)), new String[]{"JAVA_HOME=" + StartTomcat.this.getJavaHome((JavaPlatform)stringBuilder), "JRE_HOME=", "JAVA_OPTS=" + string, "CATALINA_HOME=" + file.getAbsolutePath(), "CATALINA_BASE=" + file2.getAbsolutePath(), "NB_TOMCAT_JDK=" + (String)stringArray2}, true, new File(file, "bin"));
                if (this.command == CommandType.START) {
                    StartTomcat.this.tm.setTomcatProcess((Process)object);
                    this.openLogs();
                } else {
                    RequestProcessor.getDefault().post((Runnable)new StreamConsumer(((Process)object).getInputStream()), 0, 1);
                    RequestProcessor.getDefault().post((Runnable)new StreamConsumer(((Process)object).getErrorStream()), 0, 1);
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, null, iOException);
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_StartFailedIOE" : "MSG_StopFailedIOE", ((File)object2).getAbsolutePath(), StateType.FAILED);
                return;
            }
            this.fireCmdExecProgressEvent("MSG_waiting", StateType.RUNNING);
            if (this.hasCommandSucceeded()) {
                if (this.command == CommandType.START) {
                    StartTomcat.this.tm.setNeedsRestart(false);
                    if (this.mode == 1) {
                        isDebugModeUri.put(StartTomcat.this.tm.getUri(), new Object());
                    }
                }
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_Started" : "MSG_Stopped", StateType.COMPLETED);
            } else {
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_StartFailed" : "MSG_StopFailed", StateType.FAILED);
            }
        }

        private void openLogs() {
            LogManager logManager = StartTomcat.this.tm.logManager();
            if (logManager.hasJuliLog()) {
                logManager.openJuliLog();
            }
            logManager.closeServerLog();
            logManager.openServerLog();
        }

        private void fireCmdExecProgressEvent(String string, StateType stateType) {
            String string2 = NbBundle.getMessage(StartTomcat.class, (String)string);
            StartTomcat.this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.command, string2, stateType));
        }

        private void fireCmdExecProgressEvent(String string, Object object, StateType stateType) {
            String string2 = NbBundle.getMessage(StartTomcat.class, (String)string, (Object)object);
            StartTomcat.this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.command, string2, stateType));
        }

        private boolean hasCommandSucceeded() {
            long l = System.currentTimeMillis() + 180000L;
            while (true) {
                boolean bl = StartTomcat.this.isRunning();
                if (this.command == CommandType.START) {
                    if (bl) {
                        return true;
                    }
                    if (StartTomcat.this.isStopped()) {
                        return false;
                    }
                    if (this.mode == 2) {
                        int n = ProfilerSupport.getState();
                        if (n == 2 || n == 3 || n == 4) {
                            return true;
                        }
                        if (n == 0) {
                            return false;
                        }
                    }
                }
                if (this.command == CommandType.STOP && StartTomcat.this.isStopped()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return true;
                }
                if (System.currentTimeMillis() > l) {
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

