/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tomcat5.config.gen.Engine;
import org.netbeans.modules.tomcat5.config.gen.Host;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.config.gen.Service;

public class TomcatManagerConfig {
    private File serverXml;
    private long timestamp;
    private boolean hasLogger;
    private String loggerClassName;
    private String loggerDir;
    private String loggerPrefix;
    private String loggerSuffix;
    private boolean loggerTimestamp;

    public TomcatManagerConfig(File file) {
        this.serverXml = file;
        this.refresh();
    }

    public void refresh() {
        long l = this.serverXml.lastModified();
        if (l > this.timestamp) {
            this.timestamp = l;
            Host host = this.getHostElement();
            if (host != null && host.isLogger()) {
                this.hasLogger = true;
                this.loggerClassName = host.getAttributeValue("Logger", "className");
                this.loggerDir = host.getAttributeValue("Logger", "directory");
                this.loggerPrefix = host.getAttributeValue("Logger", "prefix");
                this.loggerSuffix = host.getAttributeValue("Logger", "suffix");
                String string = host.getAttributeValue("Logger", "timestamp");
                this.loggerTimestamp = Boolean.valueOf(string);
            } else {
                Engine engine = this.getEngineElement();
                if (engine != null && engine.isLogger()) {
                    this.hasLogger = true;
                    this.loggerClassName = engine.getAttributeValue("Logger", "className");
                    this.loggerDir = engine.getAttributeValue("Logger", "directory");
                    this.loggerPrefix = engine.getAttributeValue("Logger", "prefix");
                    this.loggerSuffix = engine.getAttributeValue("Logger", "suffix");
                    String string = engine.getAttributeValue("Logger", "timestamp");
                    this.loggerTimestamp = Boolean.valueOf(string);
                } else {
                    this.hasLogger = false;
                }
            }
        }
    }

    public String serverXmlPath() {
        return this.serverXml.getAbsolutePath();
    }

    public Server getServerElement() {
        try {
            return Server.createGraph(this.serverXml);
        }
        catch (IOException iOException) {
            Logger.getLogger(TomcatManagerConfig.class.getName()).log(Level.INFO, null, iOException);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(TomcatManagerConfig.class.getName()).log(Level.INFO, null, runtimeException);
        }
        return null;
    }

    public Engine getEngineElement() {
        Server server = this.getServerElement();
        if (server == null) {
            return null;
        }
        Service[] serviceArray = server.getService();
        if (serviceArray.length > 0) {
            return serviceArray[0].getEngine();
        }
        return null;
    }

    public Host getHostElement() {
        Host[] hostArray;
        Engine engine = this.getEngineElement();
        if (engine != null && (hostArray = engine.getHost()).length > 0) {
            return hostArray[0];
        }
        return null;
    }

    public boolean hasLogger() {
        return this.hasLogger;
    }

    public String loggerClassName() {
        return this.loggerClassName;
    }

    public String loggerDir() {
        return this.loggerDir;
    }

    public String loggerPrefix() {
        return this.loggerPrefix;
    }

    public String loggerSuffix() {
        return this.loggerSuffix;
    }

    public boolean loggerTimestamp() {
        return this.loggerTimestamp;
    }
}

