/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.CharSequences;
import org.openide.util.Lookup;

public abstract class CsmVirtualInfoQuery {
    private static final CsmVirtualInfoQuery EMPTY = new Empty();
    private static CsmVirtualInfoQuery defaultQuery;

    public abstract boolean isVirtual(CsmMethod var1);

    public abstract Collection<CsmMethod> getTopmostBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getFirstBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getAllBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getOverriddenMethods(CsmMethod var1, boolean var2);

    protected CsmVirtualInfoQuery() {
    }

    public static CsmVirtualInfoQuery getDefault() {
        if (defaultQuery != null) {
            return defaultQuery;
        }
        defaultQuery = (CsmVirtualInfoQuery)Lookup.getDefault().lookup(CsmVirtualInfoQuery.class);
        return defaultQuery == null ? EMPTY : defaultQuery;
    }

    private static final class Empty
    extends CsmVirtualInfoQuery {
        private Empty() {
        }

        @Override
        public boolean isVirtual(CsmMethod method) {
            if (method.isVirtual()) {
                return true;
            }
            return this.processClass(method.getSignature(), method.getContainingClass(), new AntiLoop());
        }

        private boolean processClass(CharSequence sig, CsmClass cls, AntiLoop antilLoop) {
            if (cls == null || antilLoop.contains((CsmClassifier)cls)) {
                return false;
            }
            antilLoop.add((CsmClassifier)cls);
            for (CsmMember m : cls.getMembers()) {
                if (!CsmKindUtilities.isMethod((CsmObject)m)) continue;
                CsmMethod met = (CsmMethod)m;
                if (CharSequences.comparator().compare(sig, met.getSignature()) != 0) continue;
                if (!met.isVirtual()) break;
                return true;
            }
            for (CsmInheritance inh : cls.getBaseClasses()) {
                if (!this.processClass(sig, CsmInheritanceUtilities.getCsmClass(inh), antilLoop)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<CsmMethod> getTopmostBaseDeclarations(CsmMethod method) {
            return this.getBaseDeclaration(method, Overridden.TOP);
        }

        @Override
        public Collection<CsmMethod> getFirstBaseDeclarations(CsmMethod method) {
            return this.getBaseDeclaration(method, Overridden.FIRST);
        }

        @Override
        public Collection<CsmMethod> getAllBaseDeclarations(CsmMethod method) {
            return this.getBaseDeclaration(method, Overridden.ALL);
        }

        private Collection<CsmMethod> getBaseDeclaration(CsmMethod method, Overridden overridden) {
            HashSet<CharSequence> antilLoop = new HashSet<CharSequence>();
            CharSequence sig = method.getSignature();
            HashSet<CsmMethod> result = new HashSet<CsmMethod>();
            CsmClass cls = method.getContainingClass();
            if (cls != null) {
                for (CsmInheritance inh : cls.getBaseClasses()) {
                    this.processMethod(sig, CsmInheritanceUtilities.getCsmClass(inh), antilLoop, null, null, result, overridden);
                }
            }
            return result;
        }

        private void processMethod(CharSequence sig, CsmClass cls, Set<CharSequence> antilLoop, CsmMethod firstFound, CsmMethod lastFound, Set<CsmMethod> result, Overridden overridden) {
            CsmMethod m;
            boolean theLastInHierarchy;
            if (cls == null || antilLoop.contains(cls.getQualifiedName())) {
                theLastInHierarchy = true;
            } else {
                antilLoop.add(cls.getQualifiedName());
                for (CsmMember member : cls.getMembers()) {
                    if (!CsmKindUtilities.isMethod((CsmObject)member)) continue;
                    CsmMethod method = (CsmMethod)member;
                    if (CharSequences.comparator().compare(sig, method.getSignature()) != 0) continue;
                    if (firstFound == null) {
                        firstFound = method;
                    }
                    lastFound = method;
                    if (!method.isVirtual()) continue;
                    switch (overridden) {
                        case FIRST: {
                            result.add(firstFound);
                            return;
                        }
                        case ALL: {
                            result.add(method);
                        }
                    }
                }
                theLastInHierarchy = cls.getBaseClasses().isEmpty();
                for (CsmInheritance inh : cls.getBaseClasses()) {
                    this.processMethod(sig, CsmInheritanceUtilities.getCsmClass(inh), antilLoop, firstFound, lastFound, result, overridden);
                }
            }
            if (theLastInHierarchy && (m = lastFound) != null && m.isVirtual()) {
                CndUtils.assertNotNull((Object)firstFound, (String)"last found != null && first found == null ?!");
                switch (overridden) {
                    case FIRST: {
                        result.add(firstFound);
                        break;
                    }
                    case TOP: {
                        result.add(m);
                    }
                }
            }
        }

        @Override
        public Collection<CsmMethod> getOverriddenMethods(CsmMethod method, boolean searchFromBase) {
            CsmClass cls;
            HashSet<CsmMethod> res = new HashSet<CsmMethod>();
            if (searchFromBase) {
                Iterator<CsmMethod> it = this.getTopmostBaseDeclarations(method).iterator();
                if (it.hasNext()) {
                    method = it.next();
                }
                res.add(method);
            }
            if ((cls = method.getContainingClass()) != null) {
                CharSequence sig = method.getSignature();
                block0: for (CsmReference ref : CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, false)) {
                    CsmClass c = (CsmClass)ref.getOwner();
                    if (c == null) continue;
                    for (CsmMember m : c.getMembers()) {
                        if (!CsmKindUtilities.isMethod((CsmObject)m)) continue;
                        CsmMethod met = (CsmMethod)m;
                        if (CharSequences.comparator().compare(sig, met.getSignature()) != 0) continue;
                        res.add(met);
                        continue block0;
                    }
                }
            }
            return res;
        }

        private static enum Overridden {
            FIRST,
            TOP,
            ALL;

        }
    }
}

