/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebFreeFormActionProvider
implements ActionProvider {
    static final String FILE_SCRIPT_PATH = "nbproject/ide-file-targets.xml";
    static final String GENERAL_SCRIPT_PATH = "nbproject/ide-targets.xml";
    private static final String LOAD_PROPS_TARGET = "-load-props";
    private static final String CHECK_PROPS_TARGET = "-check-props";
    private static final String INIT_TARGET = "-init";
    private static final String DEBUG_TARGET = "debug-nb";
    private static final String DISPLAY_BROWSER = "debug-display-browser";
    private static final String[] DEBUG_PROPERTIES = new String[]{"jpda.session.name", "jpda.host", "jpda.address", "jpda.transport", "debug.sourcepath", "client.url"};
    private static final String DEBUG_PROPERTIES_TEMPLATE = "/org/netbeans/modules/web/freeform/resources/debug-properties.template";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration aux;
    private static final String[] SUPPORTED_ACTIONS = new String[]{"debug"};

    public WebFreeFormActionProvider(Project aProject, AntProjectHelper aHelper, AuxiliaryConfiguration aAux) {
        this.project = aProject;
        this.helper = aHelper;
        this.aux = aAux;
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        boolean enabled = false;
        if (command.equals("debug")) {
            enabled = true;
        }
        return enabled;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        try {
            try {
                if (command.equals("debug")) {
                    this.handleDebug();
                }
            }
            catch (SAXException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public String[] getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    private void handleDebug() throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"ACTION_debug"), GENERAL_SCRIPT_PATH)) {
            return;
        }
        String propertiesFile = this.writeDebugProperties();
        Document script = this.readCustomScript(GENERAL_SCRIPT_PATH);
        if (script == null) {
            script = this.createCustomScript();
        }
        this.writeComments(script);
        this.writeTargets(script, propertiesFile);
        this.writeCustomScript(script, GENERAL_SCRIPT_PATH);
        this.addBinding("debug", GENERAL_SCRIPT_PATH, DEBUG_TARGET, null, null, null, null, null);
        this.jumpToBinding("debug");
        this.jumpToBuildScript(GENERAL_SCRIPT_PATH, DEBUG_TARGET);
        this.openFile(propertiesFile);
    }

    private boolean alert(String commandDisplayName, String scriptPath) {
        String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String title = NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"TITLE_generate_target_dialog", (Object)commandDisplayName, (Object)projectDisplayName);
        String body = NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"TEXT_generate_target_dialog", (Object)commandDisplayName, (Object)scriptPath);
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)body, 3);
        d.setTitle(title);
        d.setOptionType(2);
        JButton generate = new JButton(NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"LBL_generate"));
        generate.setDefaultCapable(true);
        d.setOptions(new Object[]{generate, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == generate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document readCustomScript(String scriptPath) throws IOException, SAXException {
        Document script = null;
        FileObject scriptFile = this.helper.getProjectDirectory().getFileObject(scriptPath);
        if (scriptFile != null) {
            InputStream is = scriptFile.getInputStream();
            try {
                script = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)true, null, null);
            }
            finally {
                is.close();
            }
        }
        return script;
    }

    Document createCustomScript() {
        Document script = XMLUtil.createDocument((String)"project", null, null, null);
        Element scriptRoot = script.getDocumentElement();
        scriptRoot.setAttribute("basedir", "..");
        String projname = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        scriptRoot.setAttribute("name", NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"LBL_generated_script_name", (Object)projname));
        this.copyProperties(Util.getPrimaryConfigurationData((AntProjectHelper)this.helper), scriptRoot);
        return script;
    }

    private void copyProperties(Element config, Element script) {
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element properties = XMLUtil.findElement((Element)data, (String)"properties", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (properties != null) {
            for (Element el : XMLUtil.findSubElements((Element)properties)) {
                Element nue = script.getOwnerDocument().createElement("property");
                if (el.getLocalName().equals("property")) {
                    String name = el.getAttribute("name");
                    assert (name != null);
                    String text = XMLUtil.findText((Node)el);
                    assert (text != null);
                    nue.setAttribute("name", name);
                    nue.setAttribute("value", text);
                } else if (el.getLocalName().equals("property-file")) {
                    String text = XMLUtil.findText((Node)el);
                    assert (text != null);
                    nue.setAttribute("file", text);
                } else assert (false) : el;
                script.appendChild(nue);
            }
        }
    }

    private void writeComments(Document script) {
        Comment comm4Edit = script.createComment(" " + NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"COMMENT_edit_target") + " ");
        Comment comm4Info = script.createComment(" " + NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"COMMENT_more_info_debug") + " ");
        Element scriptRoot = script.getDocumentElement();
        scriptRoot.appendChild(comm4Edit);
        scriptRoot.appendChild(comm4Info);
    }

    private void writeTargets(Document script, String propertiesFile) {
        this.createLoadPropertiesTarget(script, propertiesFile);
        this.createCheckPropertiesTarget(script);
        this.createInitTarget(script);
        this.createDebugTarget(script);
        this.createDisplayBrowserTarget(script);
    }

    private void createLoadPropertiesTarget(Document script, String propertiesFile) {
        Element target = script.createElement("target");
        target.setAttribute("name", LOAD_PROPS_TARGET);
        Element property = script.createElement("property");
        property.setAttribute("file", propertiesFile);
        target.appendChild(property);
        script.getDocumentElement().appendChild(target);
    }

    private void createCheckPropertiesTarget(Document script) {
        Element target = script.createElement("target");
        target.setAttribute("name", CHECK_PROPS_TARGET);
        for (int i = 0; i < DEBUG_PROPERTIES.length; ++i) {
            Element fail = script.createElement("fail");
            fail.setAttribute("unless", DEBUG_PROPERTIES[i]);
            target.appendChild(fail);
        }
        script.getDocumentElement().appendChild(target);
    }

    private void createInitTarget(Document script) {
        Element target = script.createElement("target");
        target.setAttribute("name", INIT_TARGET);
        target.setAttribute("depends", "-load-props, -check-props");
        script.getDocumentElement().appendChild(target);
    }

    private void createDebugTarget(Document script) {
        Element target = script.createElement("target");
        target.setAttribute("name", DEBUG_TARGET);
        target.setAttribute("depends", INIT_TARGET);
        target.setAttribute("if", "netbeans.home");
        Element nbjpdaconnect = script.createElement("nbjpdaconnect");
        nbjpdaconnect.setAttribute("name", "${jpda.session.name}");
        nbjpdaconnect.setAttribute("host", "${jpda.host}");
        nbjpdaconnect.setAttribute("address", "${jpda.address}");
        nbjpdaconnect.setAttribute("transport", "${jpda.transport}");
        Element sourcepath = script.createElement("sourcepath");
        Element path = script.createElement("path");
        path.setAttribute("path", "${debug.sourcepath}");
        sourcepath.appendChild(path);
        nbjpdaconnect.appendChild(sourcepath);
        target.appendChild(nbjpdaconnect);
        Element antcall = script.createElement("antcall");
        antcall.setAttribute("target", DISPLAY_BROWSER);
        target.appendChild(antcall);
        script.getDocumentElement().appendChild(target);
    }

    private void createDisplayBrowserTarget(Document script) {
        Element target = script.createElement("target");
        target.setAttribute("name", DISPLAY_BROWSER);
        Element nbbrowse = script.createElement("nbbrowse");
        nbbrowse.setAttribute("url", "${client.url}");
        target.appendChild(nbbrowse);
        script.getDocumentElement().appendChild(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCustomScript(Document script, String scriptPath) throws IOException {
        FileObject scriptFile = this.helper.getProjectDirectory().getFileObject(scriptPath);
        if (scriptFile == null) {
            scriptFile = FileUtil.createData((FileObject)this.helper.getProjectDirectory(), (String)scriptPath);
        }
        FileLock lock = scriptFile.lock();
        try {
            OutputStream os = scriptFile.getOutputStream(lock);
            try {
                XMLUtil.write((Document)script, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    void addBinding(String command, String scriptPath, String target, String propertyName, String dir, String pattern, String format, String separator) throws IOException {
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element ideActions = XMLUtil.findElement((Element)data, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (ideActions == null) {
            return;
        }
        Document doc = data.getOwnerDocument();
        Element action = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "action");
        action.setAttribute("name", command);
        Element script = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
        script.appendChild(doc.createTextNode(scriptPath));
        action.appendChild(script);
        Element targetEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "target");
        targetEl.appendChild(doc.createTextNode(target));
        action.appendChild(targetEl);
        ideActions.appendChild(action);
        if (propertyName != null) {
            Element context = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context");
            Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
            property.appendChild(doc.createTextNode(propertyName));
            context.appendChild(property);
            Element folder = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folder");
            folder.appendChild(doc.createTextNode(dir));
            context.appendChild(folder);
            if (pattern != null) {
                Element patternEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "pattern");
                patternEl.appendChild(doc.createTextNode(pattern));
                context.appendChild(patternEl);
            }
            Element formatEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "format");
            formatEl.appendChild(doc.createTextNode(format));
            context.appendChild(formatEl);
            Element arity = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "arity");
            if (separator != null) {
                Element separatorEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "separated-files");
                separatorEl.appendChild(doc.createTextNode(separator));
                arity.appendChild(separatorEl);
            } else {
                arity.appendChild(doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "one-file-only"));
            }
            context.appendChild(arity);
            action.appendChild(context);
        } else {
            Element contextMenu;
            Element view = XMLUtil.findElement((Element)data, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (view != null && (contextMenu = XMLUtil.findElement((Element)view, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                Element ideAction = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "ide-action");
                ideAction.setAttribute("name", command);
                contextMenu.appendChild(ideAction);
            }
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)this.helper, (Element)data);
        ProjectManager.getDefault().saveProject(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeDebugProperties() throws IOException {
        String file;
        String fileName = "debug";
        int i = 0;
        do {
            file = "nbproject/" + fileName + (i != 0 ? String.valueOf(i) : "") + ".properties";
            ++i;
        } while (this.helper.resolveFileObject(file) != null);
        FileObject fo = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)file);
        FileLock lock = fo.lock();
        BufferedOutputStream out = null;
        InputStream in = null;
        try {
            int read;
            out = new BufferedOutputStream(fo.getOutputStream(lock));
            in = this.getClass().getResourceAsStream(DEBUG_PROPERTIES_TEMPLATE);
            byte[] buffer = new byte[4096];
            do {
                read = in.read(buffer);
                ((OutputStream)out).write(buffer, 0, read);
            } while (read == buffer.length);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
            lock.releaseLock();
        }
        EditableProperties ep = this.helper.getProperties(file);
        ProjectInformation pi = ProjectUtils.getInformation((Project)this.project);
        ep.setProperty("jpda.session.name", pi.getName());
        ep.setProperty("src.folders", this.findSourceFolders("java"));
        ep.setProperty("web.docbase.dir", this.findSourceFolders("doc_root"));
        String contextPath = this.findContextPath();
        ep.setProperty("client.url", ep.getProperty("client.url") + (contextPath != null ? contextPath : "/"));
        this.helper.putProperties(file, ep);
        return file;
    }

    private void jumpToBinding(String command) {
        this.jumpToFile("nbproject/project.xml", command, "action", "name");
    }

    private void jumpToBuildScript(String scriptPath, String target) {
        this.jumpToFile(scriptPath, target, "target", "name");
    }

    private void jumpToFile(String path, String match, String elementLocalName, String elementAttributeName) {
        DataObject fileDO;
        int line;
        FileObject file = this.helper.getProjectDirectory().getFileObject(path);
        if (file == null) {
            return;
        }
        try {
            line = WebFreeFormActionProvider.findLine(file, match, elementLocalName, elementAttributeName);
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            return;
        }
        catch (SAXException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            return;
        }
        catch (ParserConfigurationException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            return;
        }
        if (line == -1) {
            line = 0;
        }
        try {
            fileDO = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        LineCookie lines = (LineCookie)fileDO.getCookie(LineCookie.class);
        if (lines != null) {
            try {
                lines.getLineSet().getCurrent(line).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
            catch (IndexOutOfBoundsException e) {
                Logger.getLogger(WebFreeFormActionProvider.class.getName()).log(Level.WARNING, e + " [file=" + file + " match=" + match + " line=" + line + "]");
                lines.getLineSet().getCurrent(0).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
        }
    }

    private void openFile(String path) {
        DataObject fileDO;
        FileObject file = this.helper.getProjectDirectory().getFileObject(path);
        if (file == null) {
            return;
        }
        try {
            fileDO = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        EditCookie edit = (EditCookie)fileDO.getCookie(EditCookie.class);
        if (edit != null) {
            edit.edit();
        }
    }

    static final int findLine(FileObject file, final String match, final String elementLocalName, final String elementAttributeName) throws IOException, SAXException, ParserConfigurationException {
        InputSource in = new InputSource(file.getURL().toString());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        final int[] line = new int[]{-1};
        class Handler
        extends DefaultHandler {
            private Locator locator;

            Handler() {
            }

            @Override
            public void setDocumentLocator(Locator l) {
                this.locator = l;
            }

            @Override
            public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                if (line[0] == -1 && localname.equals(elementLocalName) && match.equals(attr.getValue(elementAttributeName))) {
                    line[0] = this.locator.getLineNumber() - 1;
                }
            }
        }
        parser.parse(in, (DefaultHandler)new Handler());
        return line[0];
    }

    private String findSourceFolders(String type) {
        StringBuffer result = new StringBuffer();
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element foldersEl = XMLUtil.findElement((Element)data, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (foldersEl != null) {
            for (Element sourceFolderEl : XMLUtil.findSubElements((Element)foldersEl)) {
                Element locationEl;
                Element typeEl = XMLUtil.findElement((Element)sourceFolderEl, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (typeEl == null || !XMLUtil.findText((Node)typeEl).equals(type) || (locationEl = XMLUtil.findElement((Element)sourceFolderEl, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) continue;
                String location = XMLUtil.findText((Node)locationEl);
                if (result.length() > 0) {
                    result.append(":");
                }
                result.append(location);
            }
        }
        return result.toString();
    }

    private String findContextPath() {
        Element data = this.aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
        Element webModulEl = XMLUtil.findElement((Element)data, (String)"web-module", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
        if (webModulEl == null) {
            return null;
        }
        Element contextPathEl = XMLUtil.findElement((Element)webModulEl, (String)"context-path", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
        if (contextPathEl == null) {
            return null;
        }
        return XMLUtil.findText((Node)contextPathEl);
    }
}

