/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.cli.options;

import java.io.File;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.cli.CLIArgumentsList;
import org.netbeans.installer.utils.cli.CLIOptionOneArgument;
import org.netbeans.installer.utils.exceptions.CLIOptionException;

public class StateOption
extends CLIOptionOneArgument {
    private static final String WARNING_MISSING_STATE_FILE_KEY = "O.warning.missing.state.file";
    private static final String WARNING_BAD_STATE_FILE_ARG_KEY = "O.warning.bag.state.file.arg";
    public static final String STATE_ARG = "--state";

    public void execute(CLIArgumentsList arguments) throws CLIOptionException {
        File stateFile = new File(arguments.next()).getAbsoluteFile();
        if (!stateFile.exists()) {
            throw new CLIOptionException(ResourceUtils.getString(StateOption.class, WARNING_MISSING_STATE_FILE_KEY, STATE_ARG, stateFile));
        }
        System.setProperty("nbi.product.source.state.file.path", stateFile.getAbsolutePath());
    }

    protected String getLackOfArgumentsMessage() {
        return ResourceUtils.getString(StateOption.class, WARNING_BAD_STATE_FILE_ARG_KEY, STATE_ARG);
    }

    public String getName() {
        return STATE_ARG;
    }
}

