/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.wizard.steps;

import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.attach.wizard.WizardContext;
import org.netbeans.modules.profiler.attach.wizard.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.functors.TrueConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStepVisitor;

public class SimpleWizardStep
implements WizardStep {
    private static final int NAVIGATION_STATE_BEGIN = 1;
    private static final int NAVIGATION_STATE_END = 2;
    private ConditionalFunctor condition;
    private String title;
    private WizardContext context;
    private WizardScreen attachedScreen;
    private boolean currentFlag = false;
    private int navigationState = 0;

    public SimpleWizardStep(String title, WizardScreen screen) {
        this(null, title, screen);
    }

    public SimpleWizardStep(String title, WizardScreen screen, ConditionalFunctor condition) {
        this(null, title, screen, condition);
    }

    public SimpleWizardStep(WizardContext context, String title, WizardScreen screen) {
        this(context, title, screen, new TrueConditionalFunctor());
    }

    public SimpleWizardStep(WizardContext context, String title, WizardScreen screen, ConditionalFunctor condition) {
        this.context = context;
        this.title = title;
        screen.setTitle(title);
        this.attachedScreen = screen;
        this.condition = condition;
    }

    @Override
    public WizardScreen getAttachedScreen() {
        return this.attachedScreen;
    }

    @Override
    public boolean isBegin() {
        return (this.navigationState & 1) > 0;
    }

    @Override
    public void setCurrent() {
        this.currentFlag = true;
    }

    @Override
    public boolean isCurrent() {
        return this.currentFlag;
    }

    @Override
    public boolean isEnd() {
        return (this.navigationState & 2) > 0;
    }

    @Override
    public void setFirst() {
        if (this.canHandle()) {
            this.navigationState = 0;
            this.currentFlag = true;
            if (this.context != null) {
                this.attachedScreen.onEnter(this.context);
            }
        } else {
            this.navigationState = 3;
        }
    }

    @Override
    public boolean isFirst() {
        return true;
    }

    @Override
    public void setLast() {
        if (this.canHandle()) {
            this.navigationState = 0;
            this.currentFlag = true;
            if (this.context != null) {
                this.attachedScreen.onEnter(this.context);
            }
        } else {
            this.navigationState = 3;
        }
    }

    @Override
    public boolean isLast() {
        return true;
    }

    @Override
    public void setNext() {
        if (this.context != null) {
            this.attachedScreen.onExit(this.context);
        }
        this.navigationState = 2;
        this.currentFlag = false;
    }

    @Override
    public void setPrevious() {
        if (this.context != null) {
            this.attachedScreen.onExit(this.context);
        }
        this.navigationState = 1;
        this.currentFlag = false;
    }

    @Override
    public int getStepIndex() {
        return 0;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setWizardContext(WizardContext context) {
        this.context = context;
    }

    @Override
    public void accept(WizardStepVisitor visitor, WizardContext context, int level) {
        if (this.canHandle()) {
            visitor.visit(this, context, level);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.attachedScreen.addChangeListener(listener);
    }

    @Override
    public boolean canBack() {
        return this.attachedScreen.canBack(this.context);
    }

    @Override
    public boolean canFinish() {
        return this.attachedScreen.canFinish(this.context);
    }

    @Override
    public boolean canHandle() {
        return this.condition.evaluate(this.context);
    }

    @Override
    public boolean canNext() {
        return this.attachedScreen.canNext(this.context);
    }

    @Override
    public boolean onCancel() {
        return this.attachedScreen.onCancel(this.context);
    }

    @Override
    public void onFinish() {
        this.attachedScreen.onFinish(this.context);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.attachedScreen.removeChangeListener(listener);
    }
}

