/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.openide.util.NbBundle;

public final class BeanUtils {
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String IS_PREFIX = "is";
    public static final String ADD_PREFIX = "add";
    public static final String REMOVE_PREFIX = "remove";
    static final String[] WELL_KNOWN_LISTENERS = new String[]{"java.awt.event.ActionListener", "java.awt.event.ContainerListener", "java.awt.event.FocusListener", "java.awt.event.ItemListener", "java.awt.event.KeyListener", "java.awt.event.MouseListener", "java.awt.event.MouseMotionListener", "java.awt.event.WindowListener", "java.beans.PropertyChangeListener", "java.beans.VetoableChangeListener", "javax.swing.event.CaretListener", "javax.swing.event.ChangeListener", "javax.swing.event.DocumentListener", "javax.swing.event.HyperlinkListener", "javax.swing.event.MenuListener", "javax.swing.event.MouseInputListener", "javax.swing.event.PopupMenuListener", "javax.swing.event.TableColumnModelListener", "javax.swing.event.TableModelListener", "javax.swing.event.TreeModelListener", "javax.swing.event.UndoableEditListener"};
    public static final String PROP_TYPE = "type";
    public static final String PROP_MODE = "mode";
    public static final String PROP_NAME = "name";
    public static final String PROP_GETTER = "getter";
    public static final String PROP_SETTER = "setter";
    public static final String PROP_ESTIMATEDFIELD = "estimatedField";
    public static final String PROP_INDEXEDTYPE = "indexedType";
    public static final String PROP_INDEXEDGETTER = "indexedGetter";
    public static final String PROP_INDEXEDSETTER = "indexedSetter";
    public static final String PROP_ADDLISTENER = "addListener";
    public static final String PROP_REMOVELISTENER = "removeListener";
    public static final String PROP_ISUNICAST = "isUnicast";

    private BeanUtils() {
    }

    static String capitalizeFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public static String nameAsString(Element element) {
        return element.getSimpleName().toString();
    }

    public static boolean isThrowing(CompilationInfo compilationInfo, ExecutableElement executableElement, String string) {
        TypeElement typeElement = compilationInfo.getElements().getTypeElement(string);
        if (typeElement == null) {
            return false;
        }
        TypeMirror typeMirror = typeElement.asType();
        for (TypeMirror typeMirror2 : executableElement.getThrownTypes()) {
            if (!compilationInfo.getTypes().isSubtype(typeMirror2, typeMirror)) continue;
            return true;
        }
        return false;
    }

    public static String getString(String string) {
        return NbBundle.getMessage(BeanUtils.class, (String)string);
    }

    public static String typeAsString(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: {
                return BeanUtils.nameAsString(((DeclaredType)typeMirror).asElement());
            }
            case ARRAY: {
                return BeanUtils.typeAsString(((ArrayType)typeMirror).getComponentType()) + "[]";
            }
        }
        return ((Object)typeMirror).toString();
    }

    public static List<? extends ExecutableElement> methodsIn(TypeElement typeElement, CompilationInfo compilationInfo) {
        List<ExecutableElement> list = ElementFilter.methodsIn(compilationInfo.getElements().getAllMembers(typeElement));
        TypeElement typeElement2 = compilationInfo.getElements().getTypeElement("java.lang.Object");
        for (int i = list.size() - 1; i >= 0; --i) {
            ExecutableElement executableElement = list.get(i);
            if (executableElement.getModifiers().contains((Object)Modifier.PUBLIC) && typeElement2 != executableElement.getEnclosingElement()) continue;
            list.remove(i);
        }
        return list;
    }
}

