/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public abstract class Scanner {
    protected static final String SEPARATOR = "/";
    protected static final char SEPARATOR_CHAR = '/';
    private List includes = new ArrayList();
    private List excludes = new ArrayList();
    protected List filesIncluded;
    protected List filesNotIncluded;
    protected List filesExcluded;
    protected List dirsIncluded;
    protected List dirsNotIncluded;
    protected List dirsExcluded;
    protected boolean isCaseSensitive = true;

    public void setIncludes(String[] includes) {
        this.includes = new ArrayList();
        this.addIncludes(includes);
    }

    public void addIncludes(String[] includes) {
        if (includes != null) {
            for (int i = 0; i < includes.length; ++i) {
                this.includes.add(this.noramlizePattern(includes[i]));
            }
        }
    }

    public void setExcludes(String[] excludes) {
        this.excludes = new ArrayList();
        this.addExcludes(excludes);
    }

    public void addExcludes(String[] excludes) {
        if (excludes != null) {
            for (int i = 0; i < excludes.length; ++i) {
                this.excludes.add(this.noramlizePattern(excludes[i]));
            }
        }
    }

    private String noramlizePattern(String pattern) {
        if (pattern.endsWith(SEPARATOR)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    public void setCaseSensitive(boolean val) {
        this.isCaseSensitive = val;
    }

    public abstract void scan();

    protected boolean isIncluded(String name) {
        Iterator i = this.includes.iterator();
        while (i.hasNext()) {
            if (!Scanner.matchPath((String)i.next(), name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        Iterator i = this.excludes.iterator();
        while (i.hasNext()) {
            if (!Scanner.matchPath((String)i.next(), name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public String[] getIncludedFiles() {
        int count = this.filesIncluded.size();
        String[] files = new String[count];
        for (int i = 0; i < count; ++i) {
            files[i] = (String)this.filesIncluded.get(i);
        }
        return files;
    }

    public String[] getNotIncludedFiles() {
        int count = this.filesNotIncluded.size();
        String[] files = new String[count];
        for (int i = 0; i < count; ++i) {
            files[i] = (String)this.filesNotIncluded.get(i);
        }
        return files;
    }

    public String[] getExcludedFiles() {
        int count = this.filesExcluded.size();
        String[] files = new String[count];
        for (int i = 0; i < count; ++i) {
            files[i] = (String)this.filesExcluded.get(i);
        }
        return files;
    }

    public String[] getIncludedDirectories() {
        int count = this.dirsIncluded.size();
        String[] directories = new String[count];
        for (int i = 0; i < count; ++i) {
            directories[i] = (String)this.dirsIncluded.get(i);
        }
        return directories;
    }

    public String[] getNotIncludedDirectories() {
        int count = this.dirsNotIncluded.size();
        String[] directories = new String[count];
        for (int i = 0; i < count; ++i) {
            directories[i] = (String)this.dirsNotIncluded.get(i);
        }
        return directories;
    }

    public String[] getExcludedDirectories() {
        int count = this.dirsExcluded.size();
        String[] directories = new String[count];
        for (int i = 0; i < count; ++i) {
            directories[i] = (String)this.dirsExcluded.get(i);
        }
        return directories;
    }

    public static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match((String)pattern, (String)str, (boolean)isCaseSensitive);
    }

    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(SEPARATOR) != pattern.startsWith(SEPARATOR)) {
            return false;
        }
        String[] patDirs = Scanner.tokenizePathAsArray(pattern);
        String[] strDirs = Scanner.tokenizePathAsArray(str);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxStart]).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (Scanner.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patDirs[i].equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            patDirs = null;
            strDirs = null;
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxEnd]).equals("**")) {
            if (!Scanner.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patDirs[i].equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (!patDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = patDirs[patIdxStart + j + 1];
                    String subStr = strDirs[strIdxStart + i + j];
                    if (!Scanner.match(subPat, subStr, isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patDirs[i].equals("**")) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        return true;
    }

    private static String[] tokenizePathAsArray(String path) {
        char sep = '/';
        int start = 0;
        int len = path.length();
        int count = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != sep) continue;
            if (pos != start) {
                ++count;
            }
            start = pos + 1;
        }
        if (len != start) {
            ++count;
        }
        String[] l = new String[count];
        count = 0;
        start = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != sep) continue;
            if (pos != start) {
                String tok = path.substring(start, pos);
                l[count++] = tok;
            }
            start = pos + 1;
        }
        if (len != start) {
            String tok;
            l[count] = tok = path.substring(start);
        }
        return l;
    }
}

