/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.SearchScope;
import org.openide.util.Lookup;

public final class SearchScopeRegistry {
    private static SearchScopeRegistry defaultInstance;
    private static final Logger LOG;
    private final int id;
    private Collection<Reference<SearchScopeRegistry>> extraInstances;
    private SearchScopeChangeHandler scopeChangeHandler;
    private List<ChangeListener> changeListeners;
    private int projectSearchScopesCount;
    private int applicableSearchScopesCount;
    private Map<SearchScope, Boolean> searchScopes = new LinkedHashMap<SearchScope, Boolean>(5);

    public static synchronized SearchScopeRegistry getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new SearchScopeRegistry(0);
        }
        return defaultInstance;
    }

    static SearchScopeRegistry getInstance(Lookup lookup, int id) {
        return SearchScopeRegistry.getDefault().getLookupInstance(lookup, id);
    }

    private SearchScopeRegistry(int id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchScopeRegistry getLookupInstance(Lookup lookup, int id) {
        Collection<SearchScope> scopes;
        SearchScopeRegistry instance;
        assert (id > 0);
        assert (this == defaultInstance);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("getLookupInstance(Lookup, " + id + ')');
        }
        Object object = this.getLock();
        synchronized (object) {
            instance = new SearchScopeRegistry(id);
            if (this.extraInstances == null) {
                this.extraInstances = new ArrayList<Reference<SearchScopeRegistry>>(4);
            }
            this.extraInstances.add(new WeakReference<SearchScopeRegistry>(instance));
            scopes = this.cloneSearchScopes(defaultInstance);
        }
        for (SearchScope scope : scopes) {
            instance.registerSearchScope(scope.getContextSensitiveInstance(lookup));
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSearchScope(SearchScope searchScope) {
        Collection<SearchScopeRegistry> lookupInstances;
        Collection<ChangeListener> listeners;
        if (LOG.isLoggable(Level.FINER)) {
            this.log("register search scope " + searchScope);
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.scopeChangeHandler != null) {
                searchScope.addChangeListener(this.scopeChangeHandler);
                listeners = this.checkNewState(searchScope, Boolean.TRUE) ? this.cloneChangeListeners() : null;
            } else {
                this.searchScopes.put(searchScope, null);
                listeners = null;
            }
            if (SearchScopeRegistry.isProjectSearchScope(searchScope)) {
                ++this.projectSearchScopesCount;
            }
            lookupInstances = this.cloneLookupInstances();
        }
        if (listeners != null) {
            this.notifyListeners(listeners);
        }
        if (!lookupInstances.isEmpty()) {
            for (SearchScopeRegistry instance : lookupInstances) {
                instance.registerSearchScope(searchScope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSearchScope(SearchScope searchScope) {
        Collection<SearchScopeRegistry> lookupInstances;
        if (LOG.isLoggable(Level.FINER)) {
            this.log("unregister search scope " + searchScope);
        }
        Object object = this.getLock();
        synchronized (object) {
            Collection<ChangeListener> listeners;
            if (this.scopeChangeHandler != null) {
                searchScope.removeChangeListener(this.scopeChangeHandler);
                listeners = this.checkNewState(searchScope, Boolean.FALSE) ? this.cloneChangeListeners() : null;
            } else {
                this.searchScopes.remove(searchScope);
                listeners = null;
            }
            if (SearchScopeRegistry.isProjectSearchScope(searchScope)) {
                --this.projectSearchScopesCount;
            }
            lookupInstances = this.cloneLookupInstances();
        }
        if (!lookupInstances.isEmpty()) {
            for (SearchScopeRegistry instance : lookupInstances) {
                instance.unregisterSearchScope(searchScope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeListener(ChangeListener l) {
        assert (l != null);
        if (LOG.isLoggable(Level.FINER)) {
            this.log("addChangeListener(" + l + ')');
        }
        Object object = this.getLock();
        synchronized (object) {
            boolean firstListener;
            boolean bl = firstListener = this.changeListeners == null;
            if (this.changeListeners == null) {
                this.changeListeners = new ArrayList<ChangeListener>(1);
            }
            this.changeListeners.add(l);
            if (firstListener) {
                assert (this.applicableSearchScopesCount == 0);
                this.applicableSearchScopesCount = 0;
                this.scopeChangeHandler = new SearchScopeChangeHandler();
                for (Map.Entry<SearchScope, Boolean> entry : this.searchScopes.entrySet()) {
                    SearchScope scope = entry.getKey();
                    scope.addChangeListener(this.scopeChangeHandler);
                    boolean applicable = scope.isApplicable();
                    if (applicable) {
                        ++this.applicableSearchScopesCount;
                    }
                    entry.setValue(applicable);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    this.log(" - initial applicable search scopes count: " + this.applicableSearchScopesCount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChangeListener(ChangeListener l) {
        assert (l != null);
        if (LOG.isLoggable(Level.FINER)) {
            this.log("removeChangeListener(" + l + ')');
        }
        Object object = this.getLock();
        synchronized (object) {
            boolean lastListener;
            if (this.changeListeners == null) {
                return;
            }
            boolean bl = lastListener = this.changeListeners.remove(l) && this.changeListeners.isEmpty();
            if (lastListener) {
                this.changeListeners = null;
                this.applicableSearchScopesCount = 0;
                for (SearchScope scope : this.searchScopes.keySet()) {
                    scope.removeChangeListener(this.scopeChangeHandler);
                }
                this.scopeChangeHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchScopeStateChanged(SearchScope searchScope) {
        Collection<ChangeListener> listeners;
        if (LOG.isLoggable(Level.FINER)) {
            this.log("searchScopeStateChanged(" + searchScope + ')');
        }
        Object object = this.getLock();
        synchronized (object) {
            listeners = this.checkNewState(searchScope, null) ? this.cloneChangeListeners() : null;
        }
        if (listeners != null) {
            this.notifyListeners(listeners);
        }
    }

    private boolean checkNewState(SearchScope searchScope, Boolean addition) {
        boolean stateChanged;
        boolean newValue;
        assert (Thread.holdsLock(this.getLock()));
        if (LOG.isLoggable(Level.FINER)) {
            this.log("checkNewState(" + searchScope + ')');
        }
        if (addition == null) {
            newValue = searchScope.isApplicable();
            Boolean oldValue = this.searchScopes.put(searchScope, newValue);
            if (oldValue == null) {
                this.searchScopes.remove(searchScope);
                return false;
            }
            if (newValue == oldValue) {
                return false;
            }
        } else if (addition.booleanValue()) {
            newValue = searchScope.isApplicable();
            this.searchScopes.put(searchScope, newValue);
        } else {
            newValue = false;
            this.searchScopes.remove(searchScope);
        }
        if (newValue) {
            ++this.applicableSearchScopesCount;
            if (LOG.isLoggable(Level.FINER)) {
                this.log(" - search scope count increased to " + this.applicableSearchScopesCount);
            }
            stateChanged = this.applicableSearchScopesCount == 1;
        } else {
            --this.applicableSearchScopesCount;
            if (LOG.isLoggable(Level.FINER)) {
                this.log(" - search scope count decreased to " + this.applicableSearchScopesCount);
            }
            stateChanged = this.applicableSearchScopesCount == 0;
        }
        return stateChanged;
    }

    private void notifyListeners(Collection<ChangeListener> listeners) {
        assert (listeners != null);
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listener : listeners) {
            listener.stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchScope getNodeSelectionSearchScope() {
        SearchScope nodeSelectionScope;
        Object object = this.getLock();
        synchronized (object) {
            if (this.searchScopes.isEmpty()) {
                nodeSelectionScope = null;
            } else {
                nodeSelectionScope = this.searchScopes.entrySet().iterator().next().getKey();
                assert (nodeSelectionScope.getClass().getName().startsWith("org.netbeans.modules.search.SearchScopeNodeSelection"));
            }
        }
        return nodeSelectionScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasApplicableSearchScope() {
        if (LOG.isLoggable(Level.FINER)) {
            this.log("hasApplicableSearchScope");
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.changeListeners != null) {
                if (LOG.isLoggable(Level.FINER)) {
                    this.log(" - listening, search scopes count = " + this.applicableSearchScopesCount);
                }
                return this.applicableSearchScopesCount != 0;
            }
            if (LOG.isLoggable(Level.FINER)) {
                this.log(" - not listening, going to check...");
            }
            return this.checkIsApplicable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SearchScope, Boolean> getSearchScopes() {
        Collection<SearchScope> scopes;
        assert (EventQueue.isDispatchThread());
        Object object = this.getLock();
        synchronized (object) {
            if (this.changeListeners != null) {
                return new LinkedHashMap<SearchScope, Boolean>(this.searchScopes);
            }
            scopes = this.cloneSearchScopes();
        }
        LinkedHashMap<SearchScope, Boolean> result = new LinkedHashMap<SearchScope, Boolean>(scopes.size() * 2);
        for (SearchScope scope : scopes) {
            result.put(scope, scope.isApplicable());
        }
        return result;
    }

    boolean hasProjectSearchScopes() {
        return this.projectSearchScopesCount > 0;
    }

    static boolean hasProjectSearchScopes(Collection<SearchScope> searchScopes) {
        if (searchScopes.isEmpty()) {
            return false;
        }
        for (SearchScope searchScope : searchScopes) {
            if (!SearchScopeRegistry.isProjectSearchScope(searchScope)) continue;
            return true;
        }
        return false;
    }

    private static boolean isProjectSearchScope(SearchScope searchScope) {
        return searchScope.getClass().getName().startsWith("org.netbeans.modules.search.project");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIsApplicable() {
        Collection<SearchScope> scopes;
        if (LOG.isLoggable(Level.FINER)) {
            this.log("checkIsApplicable()");
        }
        Object object = this.getLock();
        synchronized (object) {
            scopes = this.cloneSearchScopes();
        }
        for (SearchScope searchScope : scopes) {
            if (!searchScope.isApplicable()) continue;
            if (LOG.isLoggable(Level.FINER)) {
                this.log(" - returning true");
            }
            return true;
        }
        if (LOG.isLoggable(Level.FINER)) {
            this.log(" - returning false");
        }
        return false;
    }

    private Object getLock() {
        return this;
    }

    private Collection<SearchScopeRegistry> cloneLookupInstances() {
        List<SearchScopeRegistry> extras;
        assert (Thread.holdsLock(this.getLock()));
        if (this.extraInstances != null && !this.extraInstances.isEmpty()) {
            extras = new ArrayList(this.extraInstances.size());
            Iterator<Reference<SearchScopeRegistry>> it = this.extraInstances.iterator();
            while (it.hasNext()) {
                Reference<SearchScopeRegistry> extraInstanceRef = it.next();
                SearchScopeRegistry inst = extraInstanceRef.get();
                if (inst == null) {
                    it.remove();
                    continue;
                }
                extras.add(inst);
            }
            assert (extras.size() == this.extraInstances.size());
        } else {
            extras = null;
        }
        if (extras == null || extras.isEmpty()) {
            extras = null;
            this.extraInstances = null;
        }
        return extras != null ? extras : Collections.emptyList();
    }

    private Collection<SearchScope> cloneSearchScopes() {
        return this.cloneSearchScopes(this);
    }

    private Collection<SearchScope> cloneSearchScopes(SearchScopeRegistry fromInstance) {
        assert (Thread.holdsLock(this.getLock()));
        return new ArrayList<SearchScope>(fromInstance.searchScopes.keySet());
    }

    private Collection<ChangeListener> cloneChangeListeners() {
        assert (Thread.holdsLock(this.getLock()));
        return this.changeListeners != null ? new ArrayList<ChangeListener>(this.changeListeners) : null;
    }

    private void log(String msg) {
        LOG.finer("registry #" + this.id + ": " + msg);
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.search.SearchScopeRegistry");
    }

    private final class SearchScopeChangeHandler
    implements ChangeListener {
        private SearchScopeChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            assert (e.getSource() instanceof SearchScope);
            SearchScopeRegistry.this.searchScopeStateChanged((SearchScope)e.getSource());
        }
    }
}

