/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;

public class PropertyReader {
    private final Map<String, String[]> properties;

    public PropertyReader(String propertyname) {
        try {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            PropertyResourceBundle resource2 = new PropertyResourceBundle(classloader.getResourceAsStream(propertyname));
            Enumeration<String> keys2 = resource2.getKeys();
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            while (keys2.hasMoreElements()) {
                String key2 = keys2.nextElement();
                String[] values = resource2.getString(key2).split(",\\s*");
                for (int i = 0; i < values.length; ++i) {
                    values[i] = values[i].trim();
                }
                map.put(key2, values);
            }
            this.properties = Collections.unmodifiableMap(map);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String[] getProperty(String key2) {
        return this.properties.get(key2);
    }

    public String getSingleValue(String key2) {
        String[] array = this.getProperty(key2);
        if (array == null) {
            throw new NullPointerException(key2 + "is not defined");
        }
        return array[0];
    }

    public List getMultipleValue(String key2) {
        String[] array = this.getProperty(key2);
        if (array == null) {
            throw new NullPointerException(key2 + "is not defined");
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : array) {
            list2.add(s);
        }
        return list2;
    }
}

