/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.identity.profile.api.configurator.Configurator;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.DataEntryTableModel;
import org.netbeans.modules.identity.profile.api.configurator.MultiSelectTableModel;
import org.netbeans.modules.identity.profile.api.configurator.ProviderConfigFactory;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanismHelper;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.spi.ProviderConfig;
import org.openide.util.NbBundle;

public class ProviderConfigurator
extends Configurator {
    public static final String WSP_SERVICE_TYPE = "urn:wsp";
    private static final String DUMMY_PROVIDER_NAME = "org.netbeans.modules.identity.profile.api.DummyProviderName";
    private static final String AM_CONFIG_FILE_PROP = "AM_CONFIG_FILE";
    private static final String PROVIDER_ID_PROPERTY = "ProviderID";
    private static final String SERVICE_URI_PROPERTY = "ServiceURI";
    private String providerName;
    private Type type;
    private String serverID;
    private ProviderConfig providerConfig;
    private String keystoreLocation;
    private String keystorePassword;
    private String keyPassword;
    private boolean disabled = false;
    private JLabel errorComponent;
    private String errorText;
    private Collection<ChangeListener> listeners;
    private SecurityMechanismHelper secMechHelper;

    private ProviderConfigurator(String providerName, Type type, String serverID) {
        this.providerName = providerName;
        this.type = type;
        this.serverID = serverID;
        this.secMechHelper = new SecurityMechanismHelper(serverID);
        this.secMechHelper.getAllSecurityMechanisms();
    }

    public static ProviderConfigurator getConfigurator(String providerName, Type type, Configurator.AccessMethod accessMethod, Object accessToken, String serverID) {
        ProviderConfigurator configurator = new ProviderConfigurator(providerName, type, serverID);
        configurator.init(accessMethod, accessToken);
        return configurator;
    }

    public static Collection<ProviderConfigurator> getAllConfigurators(Type type, Configurator.AccessMethod accessMethod, Object accessToken, String id) {
        ProviderConfig dummyConfig = ProviderConfigFactory.newInstance(accessMethod, DUMMY_PROVIDER_NAME, type, accessToken);
        Collection<String> providerNames = dummyConfig.getAllProviderNames();
        ArrayList<ProviderConfigurator> result = new ArrayList<ProviderConfigurator>();
        for (String name : providerNames) {
            if (name.equals(DUMMY_PROVIDER_NAME)) continue;
            result.add(ProviderConfigurator.getConfigurator(name, type, accessMethod, accessToken, id));
        }
        return result;
    }

    protected void init(Configurator.AccessMethod accessMethod, Object accessToken) {
        this.providerConfig = ProviderConfigFactory.newInstance(accessMethod, this.providerName, this.type, accessToken);
        this.setConfiguration(this.providerConfig);
        this.keystoreLocation = (String)this.getValue(Configurable.KEYSTORE_LOCATION);
        this.keystorePassword = (String)this.getValue(Configurable.KEYSTORE_PASSWORD);
        this.keyPassword = (String)this.getValue(Configurable.KEY_PASSWORD);
    }

    ProviderConfig getProviderConfig() {
        return this.providerConfig;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(listener);
    }

    public void fireStateChanged() {
        if (this.listeners != null) {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener l : this.listeners) {
                l.stateChanged(event);
            }
        }
    }

    public void addModifier(Configurable configurable, Object source) {
        this.addModifier(configurable, source, null);
    }

    public void addModifier(Configurable configurable, Object source, Object initialValue) {
        if (this.providerConfig == null) {
            return;
        }
        switch (configurable) {
            case SECURITY_MECH: {
                if (!(source instanceof JComboBox)) break;
                this.setModel((JComboBox)source, (Collection)initialValue);
                break;
            }
            case SECURITY_MECH_COLLECTION: {
                if (!(source instanceof JTable)) break;
                this.setMultiSelectTableModel((JTable)source, (Collection)initialValue, "LBL_SecurityMechanisms");
                break;
            }
            case SECURITY_MECH_ORDERING: {
                this.setSecurityMechOrderingModel((JTable)source, (Collection)initialValue);
                return;
            }
            case USERNAME_PASSWORD_PAIRS: {
                this.setDataEntryTableModel((JTable)source, new String[]{"LBL_UserName", "LBL_Password"});
                break;
            }
            case SERVER_PROPERTIES: {
                this.setModel((JComboBox)source, (Collection)initialValue);
                break;
            }
            case SIGN_RESPONSE: 
            case USE_DEFAULT_KEYSTORE: {
                if (source instanceof JCheckBox) break;
                break;
            }
            case KEY_ALIAS: 
            case KEY_PASSWORD: 
            case KEYSTORE_PASSWORD: 
            case KEYSTORE_LOCATION: 
            case PROVIDER_ID: 
            case SERVICE_URI: 
            case WSP_ENDPOINT: 
            case SERVICE_TYPE: 
            case USERNAME: 
            case PASSWORD: {
                assert (source instanceof JTextField);
                break;
            }
        }
        this.addModifierInternal(configurable, source);
    }

    public void addErrorComponent(JLabel errorLabel) {
        this.errorComponent = errorLabel;
        this.validate();
    }

    @Override
    public Object getValue(Enum configurable) {
        if (this.providerConfig == null) {
            return null;
        }
        if (configurable instanceof Configurable) {
            switch ((Configurable)configurable) {
                case SECURITY_MECH: {
                    return this.getSecurityMechanism();
                }
                case SECURITY_MECH_COLLECTION: {
                    return this.getSecurityMechanisms();
                }
                case SIGN_RESPONSE: {
                    if (this.providerConfig.isResponseSignEnabled()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case KEY_ALIAS: {
                    return this.providerConfig.getKeyAlias();
                }
                case KEY_PASSWORD: {
                    return this.providerConfig.getKeyPassword();
                }
                case KEYSTORE_PASSWORD: {
                    return this.providerConfig.getKeyStorePassword();
                }
                case KEYSTORE_LOCATION: {
                    return this.providerConfig.getKeyStoreFile();
                }
                case PROVIDER_ID: {
                    return this.providerConfig.getProperty(PROVIDER_ID_PROPERTY);
                }
                case SERVICE_URI: {
                    return this.providerConfig.getProperty(SERVICE_URI_PROPERTY);
                }
                case WSP_ENDPOINT: {
                    return this.providerConfig.getWSPEndpoint();
                }
                case SERVER_PROPERTIES: {
                    return this.providerConfig.getServerProperties(this.serverID);
                }
                case USERNAME: {
                    return this.providerConfig.getUserName();
                }
                case PASSWORD: {
                    return this.providerConfig.getPassword();
                }
                case USERNAME_PASSWORD_PAIRS: {
                    return this.providerConfig.getUserNamePasswordPairs();
                }
                case SERVICE_TYPE: {
                    return this.providerConfig.getServiceType();
                }
                case USE_DEFAULT_KEYSTORE: {
                    return this.providerConfig.useDefaultKeyStore();
                }
            }
        }
        return null;
    }

    @Override
    public void setValue(Enum configurable, Object value) {
        if (this.providerConfig == null) {
            return;
        }
        if (configurable instanceof Configurable) {
            switch ((Configurable)configurable) {
                case SECURITY_MECH: {
                    this.setSecurityMechanism((SecurityMechanism)value);
                    break;
                }
                case SECURITY_MECH_COLLECTION: {
                    this.setSecurityMechanisms((Collection)value);
                    break;
                }
                case SIGN_RESPONSE: {
                    if (Boolean.TRUE.equals(value)) {
                        this.providerConfig.setResponseSignEnabled(true);
                        break;
                    }
                    this.providerConfig.setResponseSignEnabled(false);
                    break;
                }
                case KEY_ALIAS: {
                    this.providerConfig.setKeyAlias((String)value);
                    break;
                }
                case KEYSTORE_PASSWORD: {
                    this.keystorePassword = (String)value;
                    break;
                }
                case KEYSTORE_LOCATION: {
                    this.keystoreLocation = (String)value;
                    break;
                }
                case KEY_PASSWORD: {
                    this.keyPassword = (String)value;
                    break;
                }
                case PROVIDER_ID: {
                    this.providerConfig.setProperty(PROVIDER_ID_PROPERTY, (String)value);
                    break;
                }
                case SERVICE_URI: {
                    this.providerConfig.setProperty(SERVICE_URI_PROPERTY, (String)value);
                    break;
                }
                case WSP_ENDPOINT: {
                    this.providerConfig.setWSPEndpoint((String)value);
                    break;
                }
                case SERVER_PROPERTIES: {
                    this.providerConfig.setServerProperties((ServerProperties)value);
                    break;
                }
                case USERNAME: {
                    this.providerConfig.setUserName((String)value);
                    break;
                }
                case PASSWORD: {
                    this.providerConfig.setPassword((String)value);
                    break;
                }
                case USERNAME_PASSWORD_PAIRS: {
                    this.providerConfig.setUserNamePasswordPairs((Collection)value);
                    break;
                }
                case SERVICE_TYPE: {
                    this.providerConfig.setServiceType((String)value);
                    break;
                }
                case USE_DEFAULT_KEYSTORE: {
                    if (Boolean.TRUE.equals(value)) {
                        this.providerConfig.setDefaultKeyStore(true);
                        break;
                    }
                    this.providerConfig.setDefaultKeyStore(false);
                }
            }
            this.validate();
            this.fireStateChanged();
        }
    }

    public SecurityMechanismHelper getSecMechHelper() {
        return this.secMechHelper;
    }

    public void setError(String errorMsg) {
        if (this.errorComponent != null) {
            this.errorComponent.setText(errorMsg);
        }
        this.errorText = errorMsg;
    }

    public void clearError() {
        if (this.errorComponent != null) {
            this.errorComponent.setText("");
        }
        this.errorText = null;
    }

    public String getError() {
        return this.errorText;
    }

    @Override
    public void save() {
        try {
            if (this.providerConfig != null) {
                if (!this.disabled) {
                    this.providerConfig.saveProvider();
                } else {
                    this.providerConfig.deleteProvider();
                }
            }
        }
        catch (ConfiguratorException ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        if (this.providerConfig != null) {
            this.providerConfig.close();
        }
    }

    @Override
    public String validate() {
        this.clearError();
        String errorText = this.validateKeyStore();
        if (errorText != null) {
            this.setError(errorText);
        }
        return errorText;
    }

    private String validateKeyStore() {
        SecurityMechanism secMech = (SecurityMechanism)this.getValue(Configurable.SECURITY_MECH);
        if (secMech == null) {
            return null;
        }
        Boolean signResponse = (Boolean)this.getValue(Configurable.SIGN_RESPONSE);
        if (secMech.isPasswordCredentialRequired() && Boolean.FALSE.equals(signResponse)) {
            return null;
        }
        if (Boolean.FALSE.equals(this.getValue(Configurable.USE_DEFAULT_KEYSTORE))) {
            this.setKeyStore();
            String errorText = this.getError();
            if (errorText != null) {
                return errorText;
            }
            String keyAlias = (String)this.getValue(Configurable.KEY_ALIAS);
            if (this.keystoreLocation == null || this.keystoreLocation.trim().length() == 0) {
                return NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_InvalidKeystoreLocation");
            }
            if (this.keystorePassword == null || this.keystorePassword.trim().length() == 0) {
                return NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_InvalidKeystorePassword");
            }
            if (keyAlias == null || keyAlias.trim().length() == 0) {
                return NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_InvalidKeyAlias");
            }
            if (this.keyPassword == null || this.keyPassword.trim().length() == 0) {
                return NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_InvalidKeyPassword");
            }
        }
        return null;
    }

    @Override
    public void disable() {
        this.disabled = true;
    }

    @Override
    public void enable() {
        this.disabled = false;
    }

    private void setKeyStore() {
        try {
            this.providerConfig.setKeyStore(this.convertToForwardSlash(this.keystoreLocation), this.keystorePassword, this.keyPassword);
        }
        catch (ConfiguratorException ex) {
            this.setError(ex.getCause().getMessage());
        }
    }

    private String convertToForwardSlash(String value) {
        return value == null ? null : value.replace('\\', '/');
    }

    private Collection<SecurityMechanism> getSecurityMechanisms() {
        return this.secMechHelper.getSecurityMechanismsFromURIs(this.providerConfig.getSecurityMechanisms());
    }

    private SecurityMechanism getSecurityMechanism() {
        Collection<SecurityMechanism> secMechs = this.getSecurityMechanisms();
        if (secMechs.size() > 0) {
            return secMechs.iterator().next();
        }
        return null;
    }

    private void setSecurityMechanisms(Collection<SecurityMechanism> secMechs) {
        this.providerConfig.setSecurityMechanisms(this.secMechHelper.getSecurityMechanismURIs(secMechs));
    }

    private void setSecurityMechanism(SecurityMechanism secMech) {
        ArrayList<SecurityMechanism> secMechs = new ArrayList<SecurityMechanism>();
        if (secMechs != null) {
            secMechs.add(secMech);
        }
        this.setSecurityMechanisms(secMechs);
    }

    private void setModel(JComboBox comboBox, Collection<Object> values) {
        Object[] valueArray = new Object[values.size()];
        valueArray = values.toArray(valueArray);
        comboBox.setModel(new DefaultComboBoxModel<Object>(valueArray));
        comboBox.setSelectedIndex(0);
    }

    private void setMultiSelectTableModel(JTable table, Collection<Object> values, String label) {
        Object[] valueArray = new Object[values.size()];
        valueArray = values.toArray(valueArray);
        MultiSelectTableModel model = new MultiSelectTableModel();
        model.addColumn((Object)NbBundle.getMessage(ProviderConfigurator.class, (String)label), valueArray);
        table.setModel(model);
    }

    private void setDataEntryTableModel(JTable table, String[] labels) {
        DataEntryTableModel model = new DataEntryTableModel();
        for (String label : labels) {
            model.addColumn(NbBundle.getMessage(ProviderConfigurator.class, (String)label));
        }
        table.setModel(model);
    }

    private void setSecurityMechOrderingModel(JTable table, Collection<SecurityMechanism> secMechs) {
        Collection<SecurityMechanism> secMechOrdering = this.getSecurityMechanisms();
        SecurityMechanism[] secMechArray = new SecurityMechanism[secMechs.size()];
        secMechArray = secMechs.toArray(secMechArray);
        SecurityMechanism[] ordering = null;
        if (secMechOrdering == null || secMechOrdering.size() != secMechArray.length) {
            ordering = secMechArray;
        } else {
            ordering = new SecurityMechanism[secMechOrdering.size()];
            ordering = secMechOrdering.toArray(ordering);
        }
        DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.addColumn((Object)NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_SecurityMechanismOrdering"), ordering);
        table.setModel(tableModel);
        table.setSelectionMode(0);
    }

    public static enum Configurable {
        SECURITY_MECH,
        SECURITY_MECH_ORDERING,
        SECURITY_MECH_COLLECTION,
        SIGN_RESPONSE,
        KEY_ALIAS,
        KEY_PASSWORD,
        KEYSTORE_PASSWORD,
        KEYSTORE_LOCATION,
        PROVIDER_ID,
        SERVICE_URI,
        WSP_ENDPOINT,
        SERVER_PROPERTIES,
        USERNAME,
        PASSWORD,
        USERNAME_PASSWORD_PAIRS,
        SERVICE_TYPE,
        USE_DEFAULT_KEYSTORE,
        TRUST_AUTHORITY_CONFIG_LIST;

    }

    public static enum Type {
        WSP,
        WSC;

    }
}

