/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.SessionRemote;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class ResultRemote
implements ResultInterface {
    private int fetchSize;
    private SessionRemote session;
    private Transfer transfer;
    private int id;
    private ResultColumn[] columns;
    private Value[] currentRow;
    private int rowId;
    private int rowCount;
    private int rowOffset;
    private ObjectArray result;
    private ObjectArray lobValues;

    public ResultRemote(SessionRemote sessionRemote, Transfer transfer, int n, int n2, int n3) throws IOException, SQLException {
        this.session = sessionRemote;
        this.transfer = transfer;
        this.id = n;
        this.columns = new ResultColumn[n2];
        this.rowCount = transfer.readInt();
        for (int i = 0; i < n2; ++i) {
            this.columns[i] = new ResultColumn(transfer);
        }
        this.rowId = -1;
        this.result = new ObjectArray();
        this.fetchSize = n3;
        this.fetchRows(false);
    }

    public String getAlias(int n) {
        return this.columns[n].alias;
    }

    public String getSchemaName(int n) {
        return this.columns[n].schemaName;
    }

    public String getTableName(int n) {
        return this.columns[n].tableName;
    }

    public String getColumnName(int n) {
        return this.columns[n].columnName;
    }

    public int getColumnType(int n) {
        return this.columns[n].columnType;
    }

    public long getColumnPrecision(int n) {
        return this.columns[n].precision;
    }

    public int getColumnScale(int n) {
        return this.columns[n].scale;
    }

    public int getDisplaySize(int n) {
        return this.columns[n].displaySize;
    }

    public boolean isAutoIncrement(int n) {
        return this.columns[n].autoIncrement;
    }

    public int getNullable(int n) {
        return this.columns[n].nullable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SQLException {
        this.rowId = -1;
        this.currentRow = null;
        if (this.session == null) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            try {
                this.session.traceOperation("RESULT_RESET", this.id);
                this.transfer.writeInt(6).writeInt(this.id).flush();
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, null);
            }
        }
    }

    public Value[] currentRow() {
        return this.currentRow;
    }

    public boolean next() throws SQLException {
        if (this.rowId < this.rowCount) {
            ++this.rowId;
            this.remapIfOld();
            if (this.rowId < this.rowCount) {
                if (this.rowId - this.rowOffset >= this.result.size()) {
                    this.fetchRows(true);
                }
                this.currentRow = (Value[])this.result.get(this.rowId - this.rowOffset);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    public int getRowId() {
        return this.rowId;
    }

    public int getVisibleColumnCount() {
        return this.columns.length;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClose() {
        if (this.session == null) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            try {
                this.session.traceOperation("RESULT_CLOSE", this.id);
                this.transfer.writeInt(7).writeInt(this.id);
            }
            catch (IOException iOException) {
                this.session.getTrace().error("close", iOException);
            }
            finally {
                this.transfer = null;
                this.session = null;
            }
        }
    }

    public void close() {
        if (this.session == null) {
            return;
        }
        this.result = null;
        Trace trace = this.session.getTrace();
        this.sendClose();
        if (this.lobValues != null) {
            for (int i = 0; i < this.lobValues.size(); ++i) {
                Value value = (Value)this.lobValues.get(i);
                try {
                    value.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    trace.error("delete lob " + value.getTraceSQL(), sQLException);
                }
            }
            this.lobValues = null;
        }
    }

    private void remapIfOld() throws SQLException {
        if (this.session == null) {
            return;
        }
        try {
            if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS / 2) {
                int n = this.session.getNextId();
                this.session.traceOperation("CHANGE_ID", this.id);
                this.transfer.writeInt(9).writeInt(this.id).writeInt(n);
                this.id = n;
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRows(boolean bl) throws SQLException {
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            try {
                boolean bl2;
                this.rowOffset += this.result.size();
                this.result.clear();
                int n = Math.min(this.fetchSize, this.rowCount - this.rowOffset);
                if (bl) {
                    this.session.traceOperation("RESULT_FETCH_ROWS", this.id);
                    this.transfer.writeInt(5).writeInt(this.id).writeInt(n);
                    this.session.done(this.transfer);
                }
                for (int i = 0; i < n && (bl2 = this.transfer.readBoolean()); ++i) {
                    int n2 = this.columns.length;
                    Value[] valueArray = new Value[n2];
                    for (int j = 0; j < n2; ++j) {
                        Value value;
                        valueArray[j] = value = this.transfer.readValue();
                        if (!value.isFileBased()) continue;
                        if (this.lobValues == null) {
                            this.lobValues = new ObjectArray();
                        }
                        this.lobValues.add(value);
                    }
                    this.result.add(valueArray);
                }
                if (this.rowOffset + this.result.size() >= this.rowCount) {
                    this.sendClose();
                }
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, null);
            }
        }
    }

    public String toString() {
        return "columns: " + this.columns.length + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }
}

