/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.LazyProject;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectsRootNode;
import org.netbeans.modules.project.ui.SyncEditorWithViewsAction;
import org.netbeans.modules.project.ui.groups.Group;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ProjectTab
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener {
    public static final String ID_LOGICAL = "projectTabLogical_tc";
    public static final String ID_PHYSICAL = "projectTab_tc";
    private static final Image ICON_LOGICAL = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectTab.png");
    private static final Image ICON_PHYSICAL = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/filesTab.png");
    private static final Logger LOG = Logger.getLogger(ProjectTab.class.getName());
    private static Map<String, ProjectTab> tabs = new HashMap<String, ProjectTab>();
    private final transient ExplorerManager manager;
    private transient Node rootNode;
    private String id;
    private final transient ProjectTreeView btv;
    private final JLabel noProjectsLabel = new JLabel(NbBundle.getMessage(ProjectTab.class, (String)"NO_PROJECT_OPEN"));
    private boolean synchronizeViews = false;
    private FileObject objectToSelect;
    private RequestProcessor.Task selectionTask;
    private static final int NODE_SELECTION_DELAY = 200;
    private static final long serialVersionUID = 9374872358L;
    private static final Lookup context = Utilities.actionsGlobalContext();
    private static final Lookup.Result<FileObject> foSelection = context.lookup(new Lookup.Template(FileObject.class));
    private static final Lookup.Result<DataObject> doSelection = context.lookup(new Lookup.Template(DataObject.class));
    private final LookupListener baseListener = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            if (TopComponent.getRegistry().getActivated() == ProjectTab.this) {
                return;
            }
            if (ProjectTab.this.synchronizeViews) {
                Collection fos = foSelection.allInstances();
                if (fos.size() == 1) {
                    ProjectTab.this.selectNodeAsyncNoSelect((FileObject)fos.iterator().next());
                } else {
                    Collection dos = doSelection.allInstances();
                    if (dos.size() == 1) {
                        ProjectTab.this.selectNodeAsyncNoSelect(((DataObject)dos.iterator().next()).getPrimaryFile());
                    }
                }
            }
        }
    };
    private final LookupListener weakListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.baseListener, null);
    static final RequestProcessor RP = new RequestProcessor(ProjectTab.class);

    public ProjectTab(String id) {
        this();
        this.id = id;
        this.initValues();
    }

    public ProjectTab() {
        this.manager = new ExplorerManager();
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.initComponents();
        this.btv = new ProjectTreeView();
        this.btv.setDragSource(true);
        this.btv.setUseSubstringInQuickSearch(true);
        this.btv.setRootVisible(false);
        this.add((Component)((Object)this.btv), "Center");
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.noProjectsLabel.addMouseListener(new LabelPopupDisplayer(this.noProjectsLabel));
        this.noProjectsLabel.setHorizontalAlignment(0);
        this.noProjectsLabel.setEnabled(false);
        Color usualWindowBkg = UIManager.getColor("window");
        this.noProjectsLabel.setBackground(usualWindowBkg != null ? usualWindowBkg : Color.white);
        this.noProjectsLabel.setOpaque(true);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        this.selectionTask = this.createSelectionTask();
        Preferences nbPrefs = NbPreferences.forModule(SyncEditorWithViewsAction.class);
        this.synchronizeViews = nbPrefs.getBoolean("synchronizeEditorWithViews", false);
        nbPrefs.addPreferenceChangeListener(new NbPrefsListener());
    }

    public void setGroup(Group g) {
        if (this.id.equals(ID_LOGICAL)) {
            if (g != null) {
                this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTabLogical_tc_with_group", (Object)g.getName()));
            } else {
                this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTabLogical_tc"));
            }
        } else {
            this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTab_tc"));
        }
    }

    private void initValues() {
        this.setGroup(Group.getActiveGroup());
        if (this.id.equals(ID_LOGICAL)) {
            this.setIcon(ICON_LOGICAL);
        } else {
            this.setIcon(ICON_PHYSICAL);
        }
        if (this.rootNode == null) {
            this.rootNode = new ProjectsRootNode(this.id.equals(ID_LOGICAL) ? 1 : 0);
        }
        this.manager.setRootContext(this.rootNode);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static synchronized ProjectTab findDefault(String tcID) {
        ProjectTab tab = tabs.get(tcID);
        if (tab == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent(tcID);
            if (tc != null) {
                if (!(tc instanceof ProjectTab)) {
                    IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + ProjectTab.class.getName() + " Returned:" + tc.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    tab = ProjectTab.getDefault(tcID);
                } else {
                    tab = (ProjectTab)tc;
                }
            } else {
                tab = ProjectTab.getDefault(tcID);
            }
        }
        return tab;
    }

    public static synchronized ProjectTab getDefault(String tcID) {
        ProjectTab tab = tabs.get(tcID);
        if (tab == null) {
            tab = new ProjectTab(tcID);
            tabs.put(tcID, tab);
        }
        return tab;
    }

    public static TopComponent getLogical() {
        return ProjectTab.getDefault(ID_LOGICAL);
    }

    public static TopComponent getPhysical() {
        return ProjectTab.getDefault(ID_PHYSICAL);
    }

    protected String preferredID() {
        return this.id;
    }

    public HelpCtx getHelpCtx() {
        return ExplorerUtils.getHelpCtx((Node[])this.manager.getSelectedNodes(), (HelpCtx)(ID_LOGICAL.equals(this.id) ? new HelpCtx("ProjectTab_Projects") : new HelpCtx("ProjectTab_Files")));
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.btv.requestFocusInWindow();
    }

    public void requestFocus() {
        super.requestFocus();
        this.btv.requestFocus();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.id);
        out.writeObject(this.rootNode.getHandle());
        out.writeObject(this.btv.getExpandedPaths());
        out.writeObject(this.getSelectedPaths());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.id = (String)in.readObject();
        this.rootNode = ((Node.Handle)in.readObject()).getNode();
        List exPaths = NbCollections.checkedListByCopy((List)((List)in.readObject()), String[].class, (boolean)true);
        ArrayList<String[]> selPaths = new ArrayList<String[]>();
        try {
            selPaths.addAll(NbCollections.checkedListByCopy((List)((List)in.readObject()), String[].class, (boolean)true));
        }
        catch (OptionalDataException e) {
            // empty catch block
        }
        this.initValues();
        if (!"false".equals(System.getProperty("netbeans.keep.expansion"))) {
            KeepExpansion ke = new KeepExpansion(this.id, exPaths, selPaths);
            ke.task.schedule(0);
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    private void startListening() {
        foSelection.addLookupListener(this.weakListener);
        doSelection.addLookupListener(this.weakListener);
        this.baseListener.resultChanged(null);
    }

    private void stopListening() {
        foSelection.removeLookupListener(this.weakListener);
        doSelection.removeLookupListener(this.weakListener);
    }

    protected void componentShowing() {
        super.componentShowing();
        this.startListening();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.stopListening();
    }

    public void selectNodeAsync(FileObject object) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.open();
        this.requestActive();
        this.selectNodeAsyncNoSelect(object);
    }

    private RequestProcessor.Task createSelectionTask() {
        RequestProcessor.Task task = RP.create(new Runnable(){

            @Override
            public void run() {
                if (ProjectTab.this.objectToSelect == null) {
                    return;
                }
                ProjectsRootNode root = (ProjectsRootNode)ProjectTab.this.manager.getRootContext();
                Node tempNode = root.findNode(ProjectTab.this.objectToSelect);
                if (tempNode == null) {
                    Project project = FileOwnerQuery.getOwner((FileObject)ProjectTab.this.objectToSelect);
                    Project found = null;
                    while (true) {
                        if (project != null) {
                            for (Project p : OpenProjectList.getDefault().getOpenProjects()) {
                                if (!p.getProjectDirectory().equals(project.getProjectDirectory())) continue;
                                found = p;
                                break;
                            }
                        }
                        if (!(found instanceof LazyProject)) break;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    tempNode = root.findNode(ProjectTab.this.objectToSelect);
                    if (project != null && found == null) {
                        String message = NbBundle.getMessage(ProjectTab.class, (String)"MSG_openProject_confirm", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
                        String title = NbBundle.getMessage(ProjectTab.class, (String)"MSG_openProject_confirm_title");
                        NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)message, title, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
                        if (confirm.getValue() == NotifyDescriptor.OK_OPTION) {
                            if (!OpenProjectList.getDefault().isOpen(project)) {
                                OpenProjects.getDefault().open(new Project[]{project}, false);
                            }
                            tempNode = root.findNode(ProjectTab.this.objectToSelect);
                        }
                    }
                }
                final Node selectedNode = tempNode;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (selectedNode != null) {
                            try {
                                ProjectTab.this.manager.setSelectedNodes(new Node[]{selectedNode});
                                ProjectTab.this.btv.scrollToNode(selectedNode);
                                StatusDisplayer.getDefault().setStatusText("");
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectTab.class, (String)(ProjectTab.ID_LOGICAL.equals(ProjectTab.this.id) ? "MSG_NodeNotFound_ProjectsTab" : "MSG_NodeNotFound_FilesTab")));
                        }
                        ProjectTab.this.setCursor(null);
                    }
                });
            }
        });
        return task;
    }

    private void selectNodeAsyncNoSelect(FileObject object) {
        this.objectToSelect = object;
        this.selectionTask.schedule(200);
    }

    Node findNode(FileObject object) {
        return ((ProjectsRootNode)this.manager.getRootContext()).findNode(object);
    }

    void selectNode(final Node node) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectTab.this.manager.setSelectedNodes(new Node[]{node});
                    ProjectTab.this.btv.scrollToNode(node);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    void expandNode(Node node) {
        this.btv.expandNode(node);
    }

    private List<String[]> getSelectedPaths() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Node root = this.manager.getRootContext();
        for (Node n : this.manager.getSelectedNodes()) {
            String[] path = NodeOp.createPath((Node)n, (Node)root);
            LOG.log(Level.FINE, "path from {0} to {1}: {2}", new Object[]{root, n, Arrays.asList(path)});
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    private void selectPaths(List<String[]> paths) {
        ArrayList<Node> selectedNodes = new ArrayList<Node>();
        Node root = this.manager.getRootContext();
        for (String[] sp : paths) {
            try {
                Node n = NodeOp.findPath((Node)root, (String[])sp);
                if (n == null) continue;
                selectedNodes.add(n);
            }
            catch (NodeNotFoundException e) {}
        }
        if (!selectedNodes.isEmpty()) {
            Node[] nodes = new Node[selectedNodes.size()];
            selectedNodes.toArray(nodes);
            try {
                this.manager.setSelectedNodes(nodes);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("openProjects".equals(evt.getPropertyName())) {
            final boolean someProjectsOpen = OpenProjects.getDefault().getOpenProjects().length > 0;
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    if (someProjectsOpen) {
                        ProjectTab.this.restoreTreeView();
                    } else {
                        ProjectTab.this.showNoProjectsLabel();
                    }
                }
            });
        }
    }

    private void showNoProjectsLabel() {
        if (this.noProjectsLabel.isShowing()) {
            return;
        }
        this.remove((Component)((Object)this.btv));
        this.add(this.noProjectsLabel, "Center");
        this.revalidate();
        this.repaint();
    }

    private void restoreTreeView() {
        if (this.btv.isShowing()) {
            return;
        }
        this.remove(this.noProjectsLabel);
        this.add((Component)((Object)this.btv), "Center");
        this.revalidate();
        this.repaint();
    }

    private class NbPrefsListener
    implements PreferenceChangeListener {
        private NbPrefsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if ("synchronizeEditorWithViews".equals(evt.getKey())) {
                ProjectTab.this.synchronizeViews = Boolean.parseBoolean(evt.getNewValue());
            }
        }
    }

    private class LabelPopupDisplayer
    extends MouseAdapter {
        private Component component;

        public LabelPopupDisplayer(Component comp) {
            this.component = comp;
        }

        private void showPopup(int x, int y) {
            Action[] actions = ProjectTab.this.rootNode.getActions(false);
            JPopupMenu popup = Utilities.actionsToPopup((Action[])actions, (Component)this.component);
            popup.show(this.component, x, y);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && ProjectTab.this.id.equals(ProjectTab.ID_LOGICAL)) {
                this.showPopup(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && ProjectTab.this.id.equals(ProjectTab.ID_LOGICAL)) {
                this.showPopup(e.getX(), e.getY());
            }
        }
    }

    private class ProjectTreeView
    extends BeanTreeView {
        private ProjectTreeView() {
        }

        public void scrollToNode(final Node n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeNode tn = Visualizer.findVisualizer((Node)n);
                    if (tn == null) {
                        return;
                    }
                    TreeModel model = ProjectTreeView.this.tree.getModel();
                    if (!(model instanceof DefaultTreeModel)) {
                        return;
                    }
                    TreePath path = new TreePath(((DefaultTreeModel)model).getPathToRoot(tn));
                    Rectangle r = ProjectTreeView.this.tree.getPathBounds(path);
                    if (r != null) {
                        ProjectTreeView.this.tree.scrollRectToVisible(r);
                    }
                }
            });
        }

        public List<String[]> getExpandedPaths() {
            ArrayList<String[]> result = new ArrayList<String[]>();
            TreeNode rtn = Visualizer.findVisualizer((Node)ProjectTab.this.rootNode);
            TreePath tp = new TreePath(rtn);
            Enumeration<TreePath> exPaths = this.tree.getExpandedDescendants(tp);
            while (exPaths != null && exPaths.hasMoreElements()) {
                TreePath ep = exPaths.nextElement();
                Node en = Visualizer.findNode((Object)ep.getLastPathComponent());
                String[] path = NodeOp.createPath((Node)en, (Node)ProjectTab.this.rootNode);
                result.add(path);
            }
            return result;
        }

        public void expandNodes(List<String[]> exPaths) {
            for (Object[] objectArray : exPaths) {
                Node n;
                try {
                    n = NodeOp.findPath((Node)ProjectTab.this.rootNode, (String[])objectArray);
                }
                catch (NodeNotFoundException e) {
                    LOG.log(Level.FINE, "got {0}", e);
                    n = e.getClosestNode();
                }
                if (n == null) {
                    LOG.log(Level.FINE, "nothing from {0} via {1}", new Object[]{ProjectTab.this.rootNode, Arrays.toString(objectArray)});
                    continue;
                }
                Node leafNode = n;
                EventQueue.invokeLater(new Runnable((String[])objectArray, leafNode){
                    final /* synthetic */ String[] val$sp;
                    final /* synthetic */ Node val$leafNode;
                    {
                        this.val$sp = stringArray;
                        this.val$leafNode = node;
                    }

                    @Override
                    public void run() {
                        Object[] tns = new TreeNode[this.val$sp.length + 1];
                        Node n = this.val$leafNode;
                        for (int i = this.val$sp.length; i >= 0; --i) {
                            if (n == null) {
                                LOG.log(Level.FINE, "lost parent node at #{0} from {1}", new Object[]{i, this.val$leafNode});
                                return;
                            }
                            tns[i] = Visualizer.findVisualizer((Node)n);
                            n = n.getParentNode();
                        }
                        ProjectTreeView.this.showPath(new TreePath(tns));
                    }
                });
            }
        }
    }

    private class KeepExpansion
    implements Runnable {
        final String id;
        final RequestProcessor.Task task;
        final List<String[]> exPaths;
        final List<String[]> selPaths;

        public KeepExpansion(String id, List<String[]> exPaths, List<String[]> selPaths) {
            this.id = id;
            this.exPaths = exPaths;
            this.selPaths = selPaths;
            this.task = RP.create((Runnable)this);
        }

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                LOG.log(Level.FINE, "{0}: selecting paths: {1}", new Object[]{this.id, this.selPaths});
                ProjectTab.this.selectPaths(this.selPaths);
                LOG.log(Level.FINE, "{0}: done.", this.id);
                return;
            }
            try {
                LOG.log(Level.FINE, "{0}: waiting for projects being open", this.id);
                OpenProjects.getDefault().openProjects().get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException ex) {
                LOG.log(Level.FINE, "{0}: Timeout. Will retry in a second", this.id);
                this.task.schedule(1000);
                return;
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            LOG.log(Level.FINE, "{0}: Checking node state", this.id);
            for (Node n : ProjectTab.this.rootNode.getChildren().getNodes()) {
                if (!ProjectTab.this.btv.isExpanded(n)) continue;
                LOG.log(Level.FINE, "{0}: Node {1} has been expanded. Giving up.", new Object[]{this.id, n});
                return;
            }
            LOG.log(Level.FINE, "{0}: Expanding paths: {1}", new Object[]{this.id, this.exPaths});
            ProjectTab.this.btv.expandNodes(this.exPaths);
            LOG.log(Level.FINE, "{0}: Switching to AWT", this.id);
            EventQueue.invokeLater(this);
        }
    }
}

