/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.ui;

import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.ruby.ui.RenamePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private String oldName = null;
    private String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private RubyElementCtx jmiObject;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;
    private String stripPrefix;

    public RenameRefactoringUI(RubyElementCtx handle, ParserResult info) {
        this.jmiObject = handle;
        this.stripPrefix = handle.getStripPrefix();
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)handle));
        this.dispOldName = this.oldName = handle.getSimpleName();
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    public RenameRefactoringUI(FileObject file, RubyElementCtx handle, ParserResult info) {
        if (handle != null) {
            this.jmiObject = handle;
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file, handle}));
            this.oldName = this.jmiObject.getSimpleName();
        } else {
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file}));
            this.oldName = file.getName();
        }
        this.dispOldName = this.oldName;
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    public RenameRefactoringUI(NonRecursiveFolder file) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)file));
        this.dispOldName = this.oldName = RetoucheUtils.getPackageName(file.getFolder());
        this.pkgRename = true;
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    RenameRefactoringUI(FileObject jmiObject, String newName, RubyElementCtx handle, ParserResult info) {
        this.refactoring = handle != null ? new RenameRefactoring(Lookups.fixed((Object[])new Object[]{jmiObject, handle})) : new RenameRefactoring(Lookups.fixed((Object[])new Object[]{jmiObject}));
        this.oldName = newName;
        this.dispOldName = newName;
        this.fromListener = true;
        this.refactoring.getContext().add((Object)true);
    }

    RenameRefactoringUI(NonRecursiveFolder jmiObject, String newName) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)jmiObject));
        this.oldName = newName;
        this.dispOldName = newName;
        this.fromListener = true;
        this.pkgRename = true;
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            String name = this.oldName;
            if (this.stripPrefix != null && name.startsWith(this.stripPrefix)) {
                name = name.substring(this.stripPrefix.length());
            }
            String suffix = "";
            if (this.jmiObject != null) {
                ElementKind kind = this.jmiObject.getKind();
                if (kind == ElementKind.CLASS) {
                    suffix = RenameRefactoringUI.getString("LBL_Class");
                } else if (kind == ElementKind.METHOD) {
                    suffix = RenameRefactoringUI.getString("LBL_Method");
                } else if (kind == ElementKind.FIELD) {
                    suffix = RenameRefactoringUI.getString("LBL_Field");
                } else if (kind == ElementKind.VARIABLE) {
                    suffix = RenameRefactoringUI.getString("LBL_LocalVar");
                } else if (kind == ElementKind.MODULE || this.jmiObject == null && this.fromListener) {
                    suffix = this.pkgRename ? RenameRefactoringUI.getString("LBL_Package") : RenameRefactoringUI.getString("LBL_Folder");
                } else if (kind == ElementKind.PARAMETER) {
                    suffix = RenameRefactoringUI.getString("LBL_Parameter");
                }
            }
            suffix = suffix + " " + name;
            this.panel = new RenamePanel(name, parent, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename") + " " + suffix, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)key);
    }

    private String getPanelName() {
        String name = this.panel.getNameValue();
        if (this.stripPrefix != null && !name.startsWith(this.stripPrefix)) {
            name = this.stripPrefix + name;
        }
        return name;
    }

    public Problem setParameters() {
        this.newName = this.getPanelName();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchJavadoc());
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (!this.panel.isUpdateReferences()) {
            return null;
        }
        this.newName = this.getPanelName();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenamePanel.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Object dob = null;
        dob = this.byPassFolder != null ? DataFolder.findFolder((FileObject)this.byPassFolder) : DataObject.find((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
        dob.rename(this.getPanelName());
    }
}

