/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.inspector.common.DefaultOrderingController;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.inspector.InspectorFolderNode;
import org.openide.nodes.AbstractNode;

final class InspectorFolderWrapper {
    private List<InspectorFolderWrapper> children;
    private InspectorFolder folder;
    private InspectorFolderNode node;
    private WeakReference<DesignComponent> component;
    private Collection<InspectorFolder> childrenFolders;
    private Set<InspectorFolderWrapper> toRemove;
    private Map<InspectorOrderingController, List<InspectorFolder>> ocMap;
    private Map<Integer, List<InspectorFolder>> sortedLists;
    private List<InspectorFolderWrapper> tempChildren;
    private InspectorOrderingController defaultOrderingController;
    private List<AbstractNode> childrenNode;
    private WeakReference<DesignDocument> document;

    InspectorFolderWrapper(DesignDocument document, InspectorFolder folder) {
        this.folder = folder;
        this.document = new WeakReference<DesignDocument>(document);
    }

    List<InspectorFolderWrapper> getChildren() {
        return this.children;
    }

    List<AbstractNode> getChildrenNodes() {
        if (this.children == null) {
            return null;
        }
        if (this.childrenNode == null) {
            this.childrenNode = new ArrayList<AbstractNode>();
        } else {
            this.childrenNode.clear();
        }
        for (InspectorFolderWrapper child : this.children) {
            this.childrenNode.add(child.getNode());
        }
        return this.childrenNode;
    }

    boolean removeChild(InspectorFolder folder) {
        if (this.children == null) {
            return false;
        }
        if (this.toRemove == null) {
            this.toRemove = new HashSet<InspectorFolderWrapper>();
        } else {
            this.toRemove.clear();
        }
        for (InspectorFolderWrapper child : this.children) {
            if (!child.getFolder().equals(folder)) continue;
            this.toRemove.add(child);
        }
        if (this.toRemove == null || this.toRemove.isEmpty()) {
            return false;
        }
        this.children.removeAll(this.toRemove);
        return true;
    }

    InspectorFolder getFolder() {
        return this.folder;
    }

    void setChildren(List<InspectorFolderWrapper> children) {
        if (children == null || this.children == children) {
            return;
        }
        this.children = children;
        if (this.childrenFolders == null) {
            this.childrenFolders = new ArrayList<InspectorFolder>();
        } else {
            this.childrenFolders.clear();
        }
        for (InspectorFolderWrapper wrapper : children) {
            this.childrenFolders.add(wrapper.getFolder());
        }
    }

    InspectorFolderNode getNode() {
        return this.node;
    }

    DesignComponent getComponent() {
        if (this.component == null) {
            return null;
        }
        return (DesignComponent)this.component.get();
    }

    void resolveFolder(DesignDocument document) {
        if (this.node == null) {
            DataObjectContext dc = ProjectUtils.getDataObjectContextForDocument((DesignDocument)document);
            this.node = dc != null ? new InspectorFolderNode(dc) : new InspectorFolderNode();
        }
        if (this.folder.getComponentID() != null) {
            this.component = new WeakReference<DesignComponent>(document.getComponentByUID(this.folder.getComponentID().longValue()));
        }
        this.executeOrder();
        this.getNode().resolveNode(this, document);
    }

    Collection<InspectorFolder> getChildrenFolders() {
        return this.childrenFolders;
    }

    public AcceptSuggestion createSuggestion(Transferable transferable) {
        return this.folder.createSuggestion(transferable);
    }

    private void executeOrder() {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        if (this.ocMap == null) {
            this.ocMap = new HashMap<InspectorOrderingController, List<InspectorFolder>>();
        } else {
            this.ocMap.clear();
        }
        if (this.sortedLists == null) {
            this.sortedLists = new TreeMap<Integer, List<InspectorFolder>>();
        } else {
            this.sortedLists.clear();
        }
        if (this.tempChildren == null) {
            this.tempChildren = new ArrayList<InspectorFolderWrapper>();
        } else {
            this.tempChildren.clear();
        }
        if (this.defaultOrderingController == null) {
            this.defaultOrderingController = new DefaultOrderingController(Integer.MAX_VALUE, new TypeID(TypeID.Kind.COMPONENT, "Default"));
        }
        for (InspectorFolder inspectorFolder : this.childrenFolders) {
            boolean isWrite = false;
            if (this.getFolder().getOrderingControllers() != null) {
                for (InspectorOrderingController orderingController : this.getFolder().getOrderingControllers()) {
                    if (orderingController.isTypeIDSupported((DesignDocument)this.document.get(), inspectorFolder.getTypeID()) && this.ocMap.get(orderingController) == null) {
                        this.ocMap.put(orderingController, new ArrayList<InspectorFolder>(Arrays.asList(inspectorFolder)));
                        isWrite = true;
                        continue;
                    }
                    if (!orderingController.isTypeIDSupported((DesignDocument)this.document.get(), inspectorFolder.getTypeID()) || this.ocMap.get(orderingController) == null) continue;
                    this.ocMap.get(orderingController).add(inspectorFolder);
                    isWrite = true;
                }
                if (!isWrite && this.ocMap.get(this.defaultOrderingController) == null) {
                    this.ocMap.put(this.defaultOrderingController, new ArrayList<InspectorFolder>(Arrays.asList(inspectorFolder)));
                    continue;
                }
                if (isWrite) continue;
                this.ocMap.get(this.defaultOrderingController).add(inspectorFolder);
                continue;
            }
            if (this.ocMap.get(this.defaultOrderingController) == null) {
                this.ocMap.put(this.defaultOrderingController, new ArrayList<InspectorFolder>(Arrays.asList(inspectorFolder)));
                continue;
            }
            this.ocMap.get(this.defaultOrderingController).add(inspectorFolder);
        }
        for (InspectorOrderingController inspectorOrderingController : this.ocMap.keySet()) {
            List<InspectorFolder> sortedList = this.component != null ? inspectorOrderingController.getOrdered((DesignComponent)this.component.get(), Collections.unmodifiableList(this.ocMap.get(inspectorOrderingController))) : inspectorOrderingController.getOrdered(null, Collections.unmodifiableList(this.ocMap.get(inspectorOrderingController)));
            if (sortedList == null) {
                throw new IllegalArgumentException("List returned from InspectorOrderingController is null, controller:" + inspectorOrderingController);
            }
            if (inspectorOrderingController.getOrder() != null && this.sortedLists.get(inspectorOrderingController.getOrder()) == null) {
                this.sortedLists.put(inspectorOrderingController.getOrder(), sortedList);
                continue;
            }
            if (inspectorOrderingController.getOrder() == null || this.sortedLists.get(inspectorOrderingController.getOrder()) == null) continue;
            this.sortedLists.get(inspectorOrderingController.getOrder()).addAll(sortedList);
        }
        this.childrenFolders.clear();
        for (List list : this.sortedLists.values()) {
            this.childrenFolders.addAll(list);
        }
        for (InspectorFolder inspectorFolder : this.childrenFolders) {
            for (InspectorFolderWrapper wrapper : this.children) {
                if (wrapper.getFolder() != inspectorFolder || !inspectorFolder.getComponentID().equals(wrapper.getFolder().getComponentID())) continue;
                this.tempChildren.add(wrapper);
            }
        }
        this.children = new ArrayList<InspectorFolderWrapper>(this.tempChildren);
    }

    void terminate() {
        this.folder = null;
        if (this.node != null) {
            this.node.terminate();
            try {
                this.node.destroy();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.node = null;
        this.component = null;
        this.childrenFolders = null;
        this.toRemove = null;
        this.ocMap = null;
        this.sortedLists = null;
        this.tempChildren = null;
        this.defaultOrderingController = null;
        this.childrenNode = null;
        if (this.children == null) {
            return;
        }
        for (InspectorFolderWrapper wrapper : this.children) {
            wrapper.terminate();
        }
        this.children = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer().append("[ ").append(this.folder.getDisplayName()).append(" ] TYPE : ").append(this.folder.getTypeID()).append(", ID : ").append(this.folder.getComponentID()).append(", Children : ").append(this.children == null ? 0 : this.children.size()).append(" " + super.toString());
        return buffer.toString();
    }
}

