/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.threadmap.api.ThreadData;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.OrderedEnumStateIterator;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumn;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsDataManager;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;

public class ThreadStateColumnImpl
implements ThreadStateColumn {
    public static final Color THREAD_STATUS_UNKNOWN_COLOR = Color.LIGHT_GRAY;
    public static final Color THREAD_STATUS_ZOMBIE_COLOR = Color.BLACK;
    private final ThreadsDataManager.MergedThreadInfo info;
    private ThreadData stackProvider;
    private final List<ThreadState> list = new ArrayList<ThreadState>();
    private final AtomicInteger comparable = new AtomicInteger();

    static Color getThreadStateColor(ThreadState.MSAState threadState) {
        if (threadState == ThreadState.MSAState.ThreadFinished) {
            return THREAD_STATUS_ZOMBIE_COLOR;
        }
        ThreadStateResources res = ThreadStateResources.forState(threadState);
        if (res != null) {
            return res.color;
        }
        return THREAD_STATUS_UNKNOWN_COLOR;
    }

    static Color getThreadStateColor(ThreadState threadStateColor, int msa) {
        return ThreadStateColumnImpl.getThreadStateColor(threadStateColor.getMSAState(msa, false));
    }

    static long timeStampToMilliSeconds(long timeStamp) {
        return timeStamp / 1000L / 1000L;
    }

    static int timeInervalToMilliSeconds(long samplingInterval) {
        return (int)(samplingInterval / 1000L / 1000L);
    }

    static long timeInervalToNanoSeconds(long samplingInterval) {
        return samplingInterval * 1000L * 1000L;
    }

    static ThreadState.MSAState point2MSA(ThreadsPanel panel, ThreadState state, Point point) {
        int delta = 12;
        EnumMap<ThreadState.MSAState, AtomicInteger> map = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
        if (panel.isMSAMode()) {
            for (AtomicInteger i : map.values()) {
                i.set(0);
            }
            ThreadStateColumnImpl.fillMap(panel, state, map);
            ThreadStateColumnImpl.roundMap(map);
            int y = 0;
            int rest = 50;
            int oldRest = 0;
            OrderedEnumStateIterator it = new OrderedEnumStateIterator(map);
            while (it.hasNext()) {
                Object entry = it.next();
                int v = ((AtomicInteger)entry.getValue()).get();
                oldRest = rest;
                rest = (v * delta + oldRest) % 100;
                int d = (v * delta + oldRest) / 100;
                if (d <= 0 || 3 + delta - (y += d) > point.y || point.y > 3 + delta - y + d) continue;
                return (ThreadState.MSAState)entry.getKey();
            }
        } else {
            return state.getMSAState(state.getSamplingStateIndex(panel.isFullMode()), panel.isFullMode());
        }
        return null;
    }

    static void fillMap(ThreadsPanel panel, ThreadState threadStateColor, EnumMap<ThreadState.MSAState, AtomicInteger> aMap) {
        int size = threadStateColor.size();
        for (int i = 0; i < size; ++i) {
            ThreadState.MSAState msa = threadStateColor.getMSAState(i, panel.isFullMode());
            if (msa != null) {
                AtomicInteger value = aMap.get(msa);
                if (value == null) {
                    value = new AtomicInteger();
                    aMap.put(msa, value);
                }
                value.addAndGet(threadStateColor.getState(i));
                continue;
            }
            System.err.println("Wrong MSA at index " + i + " MSA=" + threadStateColor);
        }
    }

    static void roundMap(EnumMap<ThreadState.MSAState, AtomicInteger> aMap) {
        int sum = 0;
        int max = 0;
        ThreadState.MSAState maxMsa = null;
        for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : aMap.entrySet()) {
            int p = entry.getValue().get();
            sum += p;
            if (max > p) continue;
            maxMsa = entry.getKey();
            max = p;
        }
        if (sum < 100 && sum > 0) {
            int delta = 100 - sum;
            int s = 0;
            for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : aMap.entrySet()) {
                int cur = entry.getValue().get();
                int d = (cur * delta + sum / 2) / sum;
                if (s + d > sum) {
                    d = sum - s;
                    s = sum;
                } else {
                    s += d;
                }
                if (d <= 0) continue;
                entry.getValue().addAndGet(d);
            }
            if (s < delta && aMap.get(maxMsa) != null) {
                aMap.get(maxMsa).addAndGet(delta - s);
            }
        }
    }

    static void normilizeMap(EnumMap<ThreadState.MSAState, AtomicInteger> aMap, int count, int unit) {
        long sum = 0L;
        for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : aMap.entrySet()) {
            sum += (long)entry.getValue().get();
        }
        if (sum > 0L && sum != (long)count * (long)unit * 100L) {
            for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : aMap.entrySet()) {
                long v = entry.getValue().get();
                v = (int)(v * (long)count * (long)unit * 100L / sum);
                entry.getValue().getAndSet((int)v);
            }
        }
        if (count > 1) {
            int rest = count / 2;
            int oldRest = 0;
            for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : aMap.entrySet()) {
                AtomicInteger value = entry.getValue();
                oldRest = rest;
                rest = (value.get() + oldRest) % count;
                value.set((value.get() + oldRest) / count);
            }
        }
    }

    static int point2index(ThreadsDataManager manager, ThreadsPanel panel, ThreadStateColumnImpl threadData, Point point, int width) {
        int index;
        long dataEnd = manager.getEndTime();
        if (threadData != null && (index = ThreadStateColumnImpl.getFirstVisibleDataUnit(threadData, panel)) != -1) {
            width = Math.abs(width);
            if (panel.getViewEnd() - panel.getViewStart() > 0L) {
                float factor = (float)width / (float)(panel.getViewEnd() - panel.getViewStart());
                while (index < threadData.size() && ThreadStateColumnImpl.timeStampToMilliSeconds(threadData.getThreadStateAt(index).getTimeStamp()) <= panel.getViewEnd()) {
                    if (threadData.isAlive(index)) {
                        int xx;
                        ThreadState threadStateAt = threadData.getThreadStateAt(index);
                        int x = Math.max((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateAt.getTimeStamp()) - panel.getViewStart()) * factor), 0);
                        if (index < threadData.size() - 1) {
                            xx = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadData.getThreadStateAt(index + 1).getTimeStamp()) - panel.getViewStart()) * factor), width);
                        } else {
                            int interval = ThreadStateColumnImpl.timeInervalToMilliSeconds(threadStateAt.getMSASamplePeriod());
                            xx = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateAt.getTimeStamp()) + (long)interval - panel.getViewStart()) * factor), width);
                        }
                        if (x <= point.x && point.x < xx) {
                            return index;
                        }
                    }
                    ++index;
                }
            }
        }
        return -1;
    }

    static int getFirstVisibleDataUnit(ThreadStateColumnImpl threadData, ThreadsPanel panel) {
        for (int i = 0; i < threadData.size(); ++i) {
            long timestamp = ThreadStateColumnImpl.timeStampToMilliSeconds(threadData.getThreadStateAt(i).getTimeStamp());
            if (timestamp <= panel.getViewEnd() && i == threadData.size() - 1) {
                return i;
            }
            if (!(timestamp <= panel.getViewStart() ? ThreadStateColumnImpl.timeStampToMilliSeconds(threadData.getThreadStateAt(i + 1).getTimeStamp()) > panel.getViewStart() : timestamp <= panel.getViewEnd())) continue;
            return i;
        }
        return -1;
    }

    ThreadStateColumnImpl(ThreadsDataManager.MergedThreadInfo info, ThreadData stackProvider) {
        this.info = info;
        this.stackProvider = stackProvider;
    }

    public void setRunning(int sum) {
        this.comparable.set(sum);
    }

    public int getRunning() {
        return this.comparable.get();
    }

    @Override
    public String getName() {
        return this.info.getThreadName();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isAlive(int index) {
        if (this.list.get(index) == null || this.list.get(index).getMSAState(0, false) == null) {
            return true;
        }
        return !this.list.get(index).getMSAState(0, false).equals((Object)ThreadState.MSAState.ThreadFinished);
    }

    @Override
    public ThreadState getThreadStateAt(int index) {
        return this.list.get(index);
    }

    @Override
    public boolean isAlive() {
        return !this.list.get(this.list.size() - 1).getMSAState(0, false).equals((Object)ThreadState.MSAState.ThreadFinished);
    }

    void updateName(String newName) {
        this.info.setThreadName(newName);
    }

    void resetName() {
        this.info.resetName();
    }

    void add(ThreadState state) {
        this.list.add(state);
    }

    void removeStopMark() {
        if (this.list.size() > 0 && this.list.get(this.list.size() - 1).getMSAState(0, false).equals((Object)ThreadState.MSAState.ThreadFinished)) {
            this.list.remove(this.list.size() - 1);
        }
    }

    void clearStates() {
        this.list.clear();
    }

    int getThreadID() {
        return this.info.getThreadId();
    }

    long getThreadStartTimeStamp() {
        return this.info.getStartTimeStamp();
    }

    void updateStackProvider(ThreadData stackProvider) {
        if (stackProvider != null) {
            this.stackProvider = stackProvider;
        }
    }
}

