/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.RestServicesNode;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class RestServicesNodeFactory
implements NodeFactory {
    public static RestServicesNodeFactory mavenproject() {
        return new RestServicesNodeFactory();
    }

    public NodeList createNodes(Project project) {
        assert (project != null);
        RestUtils.upgrade(project);
        return new RestNodeList(project);
    }

    private static class RestNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String KEY_SERVICES = "rest_services";
        private static final String NO_SERVICES = "no_rest_services";
        private Project project;
        private List<String> result = new ArrayList<String>();
        private RequestProcessor.Task updateNodeTask = new RequestProcessor("RestServicesNodeFactory-request-processor").create(new Runnable(){

            @Override
            public void run() {
                RestNodeList.this.fireChange();
            }
        });
        private RequestProcessor.Task restModelTask = new RequestProcessor("RestServicesModel-request-processor").create(new Runnable(){

            @Override
            public void run() {
                try {
                    RestServicesModel restServicesModel = RestNodeList.this.getModel();
                    if (restServicesModel != null) {
                        restServicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                            public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                                RestServices restServices = restServicesMetadata.getRoot();
                                if (restServices.sizeRestServiceDescription() > 0) {
                                    RestNodeList.this.result.add(RestNodeList.KEY_SERVICES);
                                } else {
                                    RestNodeList.this.result.add(RestNodeList.NO_SERVICES);
                                }
                                return null;
                            }
                        });
                        RestNodeList.this.fireChange();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        public RestNodeList(Project project) {
            this.project = project;
        }

        public List<String> keys() {
            if (!this.result.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = this.result.get(0);
                if (KEY_SERVICES.equals(string)) {
                    arrayList.add(KEY_SERVICES);
                }
                this.result.clear();
                return arrayList;
            }
            this.restModelTask.schedule(100);
            return Collections.emptyList();
        }

        public RestServicesModel getModel() {
            RestSupport restSupport = (RestSupport)this.project.getLookup().lookup(RestSupport.class);
            if (restSupport != null) {
                return restSupport.getRestServicesModel();
            }
            return null;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            RestNodeList restNodeList = this;
            synchronized (restNodeList) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(String string) {
            if (KEY_SERVICES.equals(string)) {
                return new RestServicesNode(this.project);
            }
            return null;
        }

        public void addNotify() {
            RestSupport restSupport = (RestSupport)this.project.getLookup().lookup(RestSupport.class);
            if (restSupport != null) {
                restSupport.addModelListener((PropertyChangeListener)this);
            }
        }

        public void removeNotify() {
            RestSupport restSupport = (RestSupport)this.project.getLookup().lookup(RestSupport.class);
            if (restSupport != null) {
                restSupport.removeModelListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateNodeTask.schedule(100);
        }
    }
}

