/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.wadl.Param;
import org.netbeans.modules.websvc.saas.model.wadl.ParamStyle;
import org.netbeans.modules.websvc.saas.model.wadl.RepresentationType;
import org.netbeans.modules.websvc.saas.model.wadl.Request;

public class HttpParams {
    private boolean hasFormParams = false;
    private boolean hasHeaderParams = false;
    private boolean hasQueryParams = false;
    private boolean hasRequiredQueryParams = false;
    private boolean hasOptionalQueryParams = false;
    private boolean hasDefaultQueryParams = false;
    private List<String> formParams = new ArrayList<String>();
    private Map<String, String> fixedFormParams = new HashMap<String, String>();
    private List<String> headerParams = new ArrayList<String>();
    private Map<String, String> fixedHeaderParams = new HashMap<String, String>();
    private Map<String, String> defaultQueryParams = new HashMap<String, String>();
    private List<String> requiredQueryParams = new ArrayList<String>();
    private List<String> optionalQueryParams = new ArrayList<String>();
    private Map<String, String> fixedQueryParams = new HashMap<String, String>();

    HttpParams(WadlSaasResource wadlSaasResource) {
        this.initParams(wadlSaasResource.getResource().getParam(), null);
    }

    HttpParams(WadlSaasMethod wadlSaasMethod) {
        Request request = wadlSaasMethod.getWadlMethod().getRequest();
        if (request != null) {
            RepresentationType representationType = null;
            List list = request.getRepresentation();
            for (RepresentationType representationType2 : list) {
                if (!ClientJavaSourceHelper.HttpMimeType.FORM.getMimeType().equals(representationType2.getMediaType())) continue;
                representationType = representationType2;
                break;
            }
            this.initParams(request.getParam(), representationType);
        }
    }

    private void initParams(List<Param> list, RepresentationType representationType) {
        Object object;
        Object object2;
        if (representationType != null && (object2 = representationType.getParam()).size() > 0) {
            this.hasFormParams = true;
            Iterator object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (Param)object3.next();
                String string = object.getFixed();
                if (string != null) {
                    this.fixedFormParams.put(object.getName(), string);
                    continue;
                }
                this.formParams.add(object.getName());
            }
        }
        for (Param param : list) {
            if (ParamStyle.HEADER == param.getStyle()) {
                this.hasHeaderParams = true;
                object = param.getFixed();
                if (object != null) {
                    this.fixedHeaderParams.put(param.getName(), (String)object);
                } else {
                    this.headerParams.add(param.getName());
                }
            }
            if (ParamStyle.QUERY != param.getStyle()) continue;
            this.hasQueryParams = true;
            if (param.isRequired() && param.getFixed() == null && param.getDefault() == null) {
                this.hasRequiredQueryParams = true;
                this.requiredQueryParams.add(param.getName());
                continue;
            }
            if (param.getFixed() != null) {
                this.hasRequiredQueryParams = true;
                this.fixedQueryParams.put(param.getName(), param.getFixed());
                continue;
            }
            if (param.getDefault() != null) {
                this.hasDefaultQueryParams = true;
                this.defaultQueryParams.put(param.getName(), param.getDefault());
                continue;
            }
            this.hasOptionalQueryParams = true;
            this.optionalQueryParams.add(param.getName());
        }
    }

    boolean hasMultipleParamsInList() {
        if (!this.hasQueryParams) {
            return false;
        }
        return this.requiredQueryParams.size() + this.fixedQueryParams.size() > 1 || !this.hasRequiredQueryParams && this.optionalQueryParams.size() > 0;
    }

    boolean hasFormParams() {
        return this.hasFormParams;
    }

    boolean hasQueryParams() {
        return this.hasQueryParams;
    }

    boolean hasHeaderParams() {
        return this.hasHeaderParams;
    }

    boolean hasRequiredQueryParams() {
        return this.hasRequiredQueryParams;
    }

    boolean hasOptionalQueryParams() {
        return this.hasOptionalQueryParams;
    }

    boolean hasDefaultQueryParams() {
        return this.hasDefaultQueryParams;
    }

    Map<String, String> getDefaultQueryParams() {
        return this.defaultQueryParams;
    }

    Map<String, String> getFixedQueryParams() {
        return this.fixedQueryParams;
    }

    List<String> getOptionalQueryParams() {
        return this.optionalQueryParams;
    }

    List<String> getRequiredQueryParams() {
        return this.requiredQueryParams;
    }

    List<String> getFormParams() {
        return this.formParams;
    }

    Map<String, String> getFixedFormParams() {
        return this.fixedFormParams;
    }

    List<String> getHeaderParams() {
        return this.headerParams;
    }

    Map<String, String> getFixedHeaderParams() {
        return this.fixedHeaderParams;
    }

    void mergeQueryandHeaderParams(HttpParams httpParams) {
        this.hasQueryParams = this.hasQueryParams || httpParams.hasQueryParams;
        this.hasRequiredQueryParams = this.hasRequiredQueryParams || httpParams.hasRequiredQueryParams;
        this.hasOptionalQueryParams = this.hasOptionalQueryParams || httpParams.hasOptionalQueryParams;
        this.hasHeaderParams = this.hasHeaderParams || httpParams.hasHeaderParams;
        this.requiredQueryParams.addAll(httpParams.requiredQueryParams);
        this.optionalQueryParams.addAll(httpParams.optionalQueryParams);
        this.fixedQueryParams.putAll(httpParams.fixedQueryParams);
        this.defaultQueryParams.putAll(httpParams.defaultQueryParams);
        this.headerParams.addAll(httpParams.headerParams);
        this.fixedHeaderParams.putAll(httpParams.fixedHeaderParams);
    }
}

