/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.lib.profiler.wireprotocol.Response;

public class VMPropertiesResponse
extends Response {
    private String bootClassPath;
    private String javaClassPath;
    private String javaCommand;
    private String javaExtDirs;
    private String jdkVersionString;
    private String jvmArguments;
    private String targetMachineOSName;
    private String workingDir;
    private int agentId;
    private int agentVersion;
    private long maxHeapSize;
    private long startupTimeInCounts;
    private long startupTimeMillis;

    public VMPropertiesResponse(String jdkVerString, String javaClassPath, String javaExtDirs, String bootClassPath, String workingDir, String jvmArguments, String javaCommand, String targetMachineOSName, long maxHeapSize, long startupTimeMillis, long startupTimeInCounts, int agentId) {
        super(true, 4);
        this.jdkVersionString = jdkVerString;
        this.javaClassPath = javaClassPath;
        this.javaExtDirs = javaExtDirs;
        this.bootClassPath = bootClassPath;
        this.workingDir = workingDir;
        this.jvmArguments = jvmArguments != null ? jvmArguments : "";
        this.javaCommand = javaCommand != null ? javaCommand : "";
        this.targetMachineOSName = targetMachineOSName;
        this.maxHeapSize = maxHeapSize;
        this.startupTimeMillis = startupTimeMillis;
        this.startupTimeInCounts = startupTimeInCounts & 0xFFFFFFFFFFFFFFL;
        this.agentId = agentId;
        this.agentVersion = 10;
    }

    VMPropertiesResponse() {
        super(true, 4);
    }

    public int getAgentId() {
        return this.agentId;
    }

    public int getAgentVersion() {
        return this.agentVersion;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public String getJDKVersionString() {
        return this.jdkVersionString;
    }

    public String getJVMArguments() {
        return this.jvmArguments;
    }

    public String getJavaClassPath() {
        return this.javaClassPath;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public String getJavaExtDirs() {
        return this.javaExtDirs;
    }

    public long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public long getStartupTimeInCounts() {
        return this.startupTimeInCounts;
    }

    public long getStartupTimeMillis() {
        return this.startupTimeMillis;
    }

    public String getTargetMachineOSName() {
        return this.targetMachineOSName;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String toString() {
        return "VMPropertiesResponse:\n  jdkVersionString: " + this.jdkVersionString + "\n  javaClassPath: " + this.javaClassPath + "\n  javaExtDirs: " + this.javaExtDirs + "\n  bootClassPath: " + this.bootClassPath + "\n  workingDir: " + this.workingDir + "\n  jvmArguments: " + this.jvmArguments + "\n  javaCommand: " + this.javaCommand + "\n  targetMachineOSName: " + this.targetMachineOSName + "\n  maxHeapSize: " + this.maxHeapSize + "\n  startupTimeMillis: " + this.startupTimeMillis + "\n  startupTimeInCounts: " + this.startupTimeInCounts + "\n  agentId: " + this.agentId + "\n  agentVersion: " + this.agentVersion + "\n" + super.toString();
    }

    void readObject(ObjectInputStream in) throws IOException {
        this.agentVersion = in.readInt();
        this.jdkVersionString = in.readUTF();
        this.javaClassPath = in.readUTF();
        this.javaExtDirs = in.readUTF();
        this.bootClassPath = in.readUTF();
        this.workingDir = in.readUTF();
        this.jvmArguments = in.readUTF();
        this.javaCommand = in.readUTF();
        this.targetMachineOSName = in.readUTF();
        this.maxHeapSize = in.readLong();
        this.startupTimeMillis = in.readLong();
        this.startupTimeInCounts = in.readLong();
        this.agentId = in.readInt();
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.agentVersion);
        out.writeUTF(this.jdkVersionString);
        out.writeUTF(this.javaClassPath);
        out.writeUTF(this.javaExtDirs);
        out.writeUTF(this.bootClassPath);
        out.writeUTF(this.workingDir);
        out.writeUTF(this.jvmArguments);
        out.writeUTF(this.javaCommand);
        out.writeUTF(this.targetMachineOSName);
        out.writeLong(this.maxHeapSize);
        out.writeLong(this.startupTimeMillis);
        out.writeLong(this.startupTimeInCounts);
        out.writeInt(this.agentId);
    }
}

