/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenMetadataSource
extends AbstractLogEnabled
implements ArtifactMetadataSource,
Contextualizable {
    public static final String ROLE_HINT = "default";
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;
    private RepositoryMetadataManager repositoryMetadataManager;
    private MavenProject superProject;
    private PlexusContainer container;
    private boolean strictlyEnforceThePresenceOfAValidMavenPOM = false;
    static /* synthetic */ Class class$0;

    /*
     * Unable to fully structure code
     */
    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        if (remoteRepositories == null) {
            remoteRepositories = Collections.EMPTY_LIST;
        }
        try {
            this.loadProjectBuilder();
        }
        catch (ComponentLookupException e) {
            throw new ArtifactMetadataRetrievalException("Cannot lookup MavenProjectBuilder component instance: " + e.getMessage(), e);
        }
        project = null;
        done = false;
        do {
            block28: {
                block26: {
                    block27: {
                        pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
                        if (Artifact.SCOPE_SYSTEM.equals(artifact.getScope())) {
                            done = true;
                            continue;
                        }
                        try {
                            project = this.mavenProjectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository);
                        }
                        catch (InvalidProjectModelException e) {
                            if (this.strictlyEnforceThePresenceOfAValidMavenPOM) {
                                throw new ArtifactMetadataRetrievalException("Invalid POM file for artifact: '" + artifact.getDependencyConflictId() + "' Reason: " + e.getMessage(), e, artifact);
                            }
                            this.getLogger().warn("POM for '" + pomArtifact + "' is invalid. It will be ignored for artifact resolution. Reason: " + e.getMessage());
                            if (!this.getLogger().isDebugEnabled()) break block26;
                            this.getLogger().debug("Reason: " + e.getMessage());
                            validationResult = e.getValidationResult();
                            if (validationResult == null) break block27;
                            this.getLogger().debug("\nValidation Errors:");
                            i = validationResult.getMessages().iterator();
                            ** while (i.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.getLogger().debug(i.next().toString());
                            continue;
                        }
lbl31:
                        // 1 sources

                        this.getLogger().debug("\n");
                        break block26;
                    }
                    this.getLogger().debug("", e);
                }
                project = null;
                break block28;
                catch (ProjectBuildingException e) {
                    if (!this.strictlyEnforceThePresenceOfAValidMavenPOM) break block28;
                    throw new ArtifactMetadataRetrievalException("Unable to read the metadata file for artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), e, artifact);
                }
            }
            if (project != null) {
                relocation = null;
                distMgmt = project.getDistributionManagement();
                if (distMgmt != null) {
                    relocation = distMgmt.getRelocation();
                    artifact.setDownloadUrl(distMgmt.getDownloadUrl());
                    pomArtifact.setDownloadUrl(distMgmt.getDownloadUrl());
                }
                if (relocation != null) {
                    if (relocation.getGroupId() != null) {
                        artifact.setGroupId(relocation.getGroupId());
                    }
                    if (relocation.getArtifactId() != null) {
                        artifact.setArtifactId(relocation.getArtifactId());
                    }
                    if (relocation.getVersion() != null) {
                        artifact.setVersionRange(VersionRange.createFromVersion(relocation.getVersion()));
                    }
                    if (artifact.getDependencyFilter() != null && !artifact.getDependencyFilter().include(artifact)) {
                        return null;
                    }
                    available = artifact.getAvailableVersions();
                    if (available != null && !available.isEmpty()) {
                        artifact.setAvailableVersions(this.retrieveAvailableVersions(artifact, localRepository, remoteRepositories));
                    }
                    message = "\n  This artifact has been relocated to " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ".\n";
                    if (relocation.getMessage() != null) {
                        message = String.valueOf(message) + "  " + relocation.getMessage() + "\n";
                    }
                    if (artifact.getDependencyTrail() != null && artifact.getDependencyTrail().size() == 1) {
                        this.getLogger().warn("While downloading " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + message + "\n");
                        continue;
                    }
                    this.getLogger().debug("While downloading " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + message + "\n");
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        if (artifact.getDownloadUrl() == null) {
            artifact.setDownloadUrl(pomArtifact.getDownloadUrl());
        }
        if (project == null) {
            result = new ResolutionGroup(pomArtifact, Collections.EMPTY_SET, Collections.EMPTY_LIST);
        } else {
            artifacts = Collections.EMPTY_SET;
            if (!artifact.getArtifactHandler().isIncludesDependencies()) {
                try {
                    artifacts = project.createArtifacts(this.artifactFactory, artifact.getScope(), artifact.getDependencyFilter());
                }
                catch (InvalidDependencyVersionException e) {
                    throw new ArtifactMetadataRetrievalException("Error in metadata for artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), e);
                }
            }
            repositories = this.aggregateRepositoryLists(remoteRepositories, project.getRemoteArtifactRepositories());
            result = new ResolutionGroup(pomArtifact, artifacts, repositories);
        }
        return result;
    }

    private void loadProjectBuilder() throws ComponentLookupException {
        if (this.mavenProjectBuilder == null) {
            this.mavenProjectBuilder = (MavenProjectBuilder)this.container.lookup(MavenProjectBuilder.class);
        }
    }

    private List aggregateRepositoryLists(List remoteRepositories, List remoteArtifactRepositories) throws ArtifactMetadataRetrievalException {
        if (this.superProject == null) {
            try {
                this.superProject = this.mavenProjectBuilder.buildStandaloneSuperProject();
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to parse the Maven built-in model: " + e.getMessage(), e);
            }
        }
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        repositories.addAll(remoteRepositories);
        for (ArtifactRepository superRepo : this.superProject.getRemoteArtifactRepositories()) {
            Iterator aggregatedIterator = repositories.iterator();
            while (aggregatedIterator.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)aggregatedIterator.next();
                if (!repo.getId().equals(superRepo.getId()) || !repo.getUrl().equals(superRepo.getUrl())) continue;
                aggregatedIterator.remove();
            }
        }
        if (remoteArtifactRepositories != null) {
            for (ArtifactRepository repository : remoteArtifactRepositories) {
                if (repositories.contains(repository)) continue;
                repositories.add(repository);
            }
        }
        return repositories;
    }

    public static Set createArtifacts(ArtifactFactory artifactFactory, List dependencies, String inheritedScope, ArtifactFilter dependencyFilter, MavenProject project) throws InvalidDependencyVersionException {
        LinkedHashSet<Artifact> projectArtifacts = new LinkedHashSet<Artifact>(dependencies.size());
        for (Dependency d : dependencies) {
            VersionRange versionRange;
            String scope = d.getScope();
            if (StringUtils.isEmpty(scope)) {
                scope = Artifact.SCOPE_COMPILE;
                d.setScope(scope);
            }
            try {
                versionRange = VersionRange.createFromVersionSpec(d.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidDependencyVersionException(project.getId(), d, project.getFile(), e);
            }
            Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), scope, inheritedScope, d.isOptional());
            if (Artifact.SCOPE_SYSTEM.equals(scope)) {
                artifact.setFile(new File(d.getSystemPath()));
            }
            ArtifactFilter artifactFilter = dependencyFilter;
            if (artifact == null || artifactFilter != null && !artifactFilter.include(artifact)) continue;
            if (d.getExclusions() != null && !d.getExclusions().isEmpty()) {
                ArrayList<String> exclusions = new ArrayList<String>();
                for (Exclusion e : d.getExclusions()) {
                    exclusions.add(String.valueOf(e.getGroupId()) + ":" + e.getArtifactId());
                }
                ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
                if (artifactFilter != null) {
                    AndArtifactFilter filter = new AndArtifactFilter();
                    filter.add(artifactFilter);
                    filter.add(newFilter);
                    artifactFilter = filter;
                } else {
                    artifactFilter = newFilter;
                }
            }
            artifact.setDependencyFilter(artifactFilter);
            if (project != null) {
                artifact = project.replaceWithActiveArtifact(artifact);
            }
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersions(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolve(metadata, remoteRepositories, localRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), e);
        }
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata());
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersionsFromDeploymentRepository(Artifact artifact, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolveAlways(metadata, localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), e);
        }
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata());
    }

    private List<ArtifactVersion> retrieveAvailableVersionsFromMetadata(Metadata repoMetadata) {
        List<ArtifactVersion> versions;
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            List metadataVersions = repoMetadata.getVersioning().getVersions();
            versions = new ArrayList<ArtifactVersion>(metadataVersions.size());
            for (String version : metadataVersions) {
                versions.add(new DefaultArtifactVersion(version));
            }
        } else {
            versions = Collections.emptyList();
        }
        return versions;
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

