/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.analyzer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.modules.vmd.analyzer.AnalyzerPanel;
import org.netbeans.modules.vmd.api.analyzer.Analyzer;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AnalyzerEditorView
implements DataEditorView,
DesignDocumentAwareness {
    private static final Color BACKGROUND_COLOR = new Color(16513523);
    private static final long serialVersionUID = -1L;
    static final String ANALYZER_ID = "analyzer";
    private DataObjectContext context;
    private transient HashMap<Analyzer, JComponent> components;
    private transient DesignDocument document;
    private transient JScrollPane scroll;
    private transient JToolBar toolbar;

    public AnalyzerEditorView(DataObjectContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        this.components = new HashMap();
        Collection analyzers = Lookup.getDefault().lookupResult(Analyzer.class).allInstances();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBackground(BACKGROUND_COLOR);
        panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scroll = new JScrollPane(panel);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.anchor = 18;
        for (Analyzer analyzer : analyzers) {
            String projectType = this.context.getProjectType();
            if (projectType == null || !projectType.equals(analyzer.getProjectType())) continue;
            JComponent visualRepresentation = analyzer.createVisualRepresentation();
            this.components.put(analyzer, visualRepresentation);
            if (visualRepresentation == null) continue;
            panel.add((Component)new AnalyzerPanel(analyzer, visualRepresentation), constraints);
        }
        constraints.weighty = 1.0;
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        panel.add((Component)filler, constraints);
        this.context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setPreferredSize(new Dimension(14, 14));
        this.toolbar.setSize(new Dimension(14, 14));
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        this.toolbar.add(separator);
        JButton refreshButton = new JButton();
        refreshButton.setOpaque(false);
        refreshButton.setToolTipText(NbBundle.getMessage(AnalyzerEditorView.class, (String)"TTIP_Refresh"));
        refreshButton.setBorderPainted(false);
        refreshButton.setRolloverEnabled(true);
        refreshButton.setSize(14, 14);
        refreshButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/analyzer/resources/refresh.png", (boolean)false));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalyzerEditorView.this.updateAnalyzers();
            }
        });
        this.toolbar.add(refreshButton);
        panel.putClientProperty("print.printable", Boolean.TRUE);
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.MODEL;
    }

    public boolean canShowSideWindows() {
        return true;
    }

    public Collection<String> getTags() {
        return Collections.emptySet();
    }

    public String preferredID() {
        return ANALYZER_ID;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AnalyzerEditorView.class, (String)"DISP_AnalyzerView");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AnalyzerEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.scroll;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbar;
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
        this.updateAnalyzers();
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return 0;
    }

    public int getEditPriority() {
        return 0;
    }

    public int getOrder() {
        return 3000;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.context);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }

    public void setDesignDocument(DesignDocument designDocument) {
        this.document = designDocument;
        this.componentActivated();
    }

    private void updateAnalyzers() {
        DesignDocument doc = this.document;
        for (Map.Entry<Analyzer, JComponent> entry : this.components.entrySet()) {
            entry.getKey().update(entry.getValue(), doc);
        }
    }
}

