/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

abstract class HTMLElementBase
implements HTMLElement {
    private Node _node;
    private ScriptableDelegate _scriptable;
    private List _supportedAttributes = new ArrayList();

    public String getID() {
        return this.getAttribute("id");
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public ScriptableDelegate getScriptableDelegate() {
        if (this._scriptable == null) {
            this._scriptable = this.newScriptable();
            this._scriptable.setScriptEngine(this.getParentDelegate().getScriptEngine(this._scriptable));
        }
        return this._scriptable;
    }

    public String getText() {
        if (this._node.getNodeType() == 3) {
            return this._node.getNodeValue().trim();
        }
        if (this._node == null || !this._node.hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(this._node.getChildNodes()).trim();
    }

    public String getTagName() {
        return this._node.getNodeName();
    }

    protected HTMLElementBase(Node node) {
        this._node = node;
        this.supportAttribute("id");
        this.supportAttribute("class");
        this.supportAttribute("title");
        this.supportAttribute("name");
    }

    public String getAttribute(String name) {
        return NodeUtils.getNodeAttribute(this.getNode(), name);
    }

    public boolean isSupportedAttribute(String name) {
        return this._supportedAttributes.contains(name);
    }

    protected String getAttribute(String name, String defaultValue) {
        return NodeUtils.getNodeAttribute(this.getNode(), name, defaultValue);
    }

    protected Node getNode() {
        return this._node;
    }

    protected void supportAttribute(String name) {
        this._supportedAttributes.add(name);
    }

    protected ScriptableDelegate newScriptable() {
        return new HTMLElementScriptable(this);
    }

    protected abstract ScriptableDelegate getParentDelegate();
}

