/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class NamingFactory {
    private static final Map nameMap = new WeakHashMap();

    public static synchronized FileNaming fromFile(File file) {
        LinkedList<File> list = new LinkedList<File>();
        for (File current = file; current != null; current = current.getParentFile()) {
            list.addFirst(current);
        }
        FileNaming fileName = null;
        for (int i = 0; i < list.size(); ++i) {
            File f = (File)list.get(i);
            if ("\\\\".equals(f.getPath())) {
                ++i;
                continue;
            }
            FileType type = i == list.size() - 1 ? FileType.unknown : FileType.directory;
            fileName = NamingFactory.registerInstanceOfFileNaming(fileName, f, type);
        }
        return fileName;
    }

    public static synchronized int getSize() {
        return nameMap.size();
    }

    public static synchronized FileNaming fromFile(FileNaming parentFn, File file, boolean ignoreCache) {
        return NamingFactory.registerInstanceOfFileNaming(parentFn, file, null, ignoreCache, FileType.unknown);
    }

    public static synchronized void checkCaseSensitivity(FileNaming childName, File f) throws IOException {
        if (!childName.getFile().getName().equals(f.getName())) {
            boolean isCaseSensitive;
            boolean bl = isCaseSensitive = !new File(f, "a").equals(new File(f, "A"));
            if (!isCaseSensitive) {
                NamingFactory.rename(childName, f.getName());
            }
        }
    }

    private static synchronized FileNaming[] rename(FileNaming fNaming, String newName) throws IOException {
        return NamingFactory.rename(fNaming, newName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileNaming[] rename(FileNaming fNaming, String newName, ProvidedExtensions.IOHandler handler) throws IOException {
        ArrayList<FileNaming> all = new ArrayList<FileNaming>();
        boolean retVal = false;
        Class<NamingFactory> clazz = NamingFactory.class;
        synchronized (NamingFactory.class) {
            NamingFactory.removeImpl(fNaming, null);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            retVal = fNaming.rename(newName, handler);
            clazz = NamingFactory.class;
            synchronized (NamingFactory.class) {
                all.add(fNaming);
                NamingFactory.registerInstanceOfFileNaming(fNaming.getParent(), fNaming.getFile(), fNaming, true, FileType.unknown);
                NamingFactory.renameChildren(all);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return retVal ? all.toArray(new FileNaming[all.size()]) : null;
            }
        }
    }

    private static void renameChildren(ArrayList all) {
        Integer id;
        assert (Thread.holdsLock(NamingFactory.class));
        HashMap<Integer, FileNaming> toRename = new HashMap<Integer, FileNaming>();
        for (Map.Entry entry : nameMap.entrySet()) {
            id = (Integer)entry.getKey();
            ArrayList list = new ArrayList();
            Object value = entry.getValue();
            if (value instanceof Reference) {
                list.add(value);
            } else if (value instanceof List) {
                list.addAll((List)value);
            }
            for (int i = 0; i < list.size(); ++i) {
                boolean isRenamed;
                FileNaming fN = (FileNaming)((Reference)list.get(i)).get();
                if (fN == null) continue;
                Integer computedId = NamingFactory.createID(fN.getFile());
                boolean bl = isRenamed = !computedId.equals(id);
                if (!isRenamed) continue;
                toRename.put(id, fN);
            }
        }
        for (Map.Entry entry : toRename.entrySet()) {
            id = (Integer)entry.getKey();
            FileNaming fN = (FileNaming)entry.getValue();
            all.add(fN);
            NamingFactory.removeImpl(fN, id);
            fN.getId(true);
            NamingFactory.registerInstanceOfFileNaming(fN.getParent(), fN.getFile(), fN, false, FileType.unknown);
        }
    }

    public static synchronized void remove(FileNaming fNaming, Integer id) {
        NamingFactory.removeImpl(fNaming, id);
    }

    private static void removeImpl(FileNaming fNaming, Integer id) {
        assert (Thread.holdsLock(NamingFactory.class));
        Object value = nameMap.get(id = id != null ? id : fNaming.getId());
        if (value instanceof List) {
            Reference ref = NamingFactory.getReference((List)value, fNaming.getFile());
            if (ref != null) {
                ((List)value).remove(ref);
            }
        } else {
            nameMap.remove(id);
        }
    }

    public static Integer createID(File file) {
        return new Integer(file.hashCode());
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming parentName, File file, FileType type) {
        return NamingFactory.registerInstanceOfFileNaming(parentName, file, null, false, type);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming parentName, File file, FileNaming newValue, boolean ignoreCache, FileType type) {
        FileNaming retVal;
        FileNaming cachedElement;
        assert (Thread.holdsLock(NamingFactory.class));
        Object value = nameMap.get(new Integer(file.hashCode()));
        Reference ref = (Reference)(value instanceof Reference ? value : null);
        ref = ref == null && value instanceof List ? NamingFactory.getReference((List)value, file) : ref;
        FileNaming fileNaming = cachedElement = ref != null ? (FileNaming)ref.get() : null;
        if (!ignoreCache && cachedElement != null && cachedElement.getFile().compareTo(file) == 0) {
            retVal = cachedElement;
        } else {
            retVal = newValue == null ? NamingFactory.createFileNaming(file, parentName, type) : newValue;
            WeakReference<FileNaming> refRetVal = new WeakReference<FileNaming>(retVal);
            boolean isList = value instanceof List;
            if (!ignoreCache && cachedElement != null || isList) {
                if (isList) {
                    ((List)value).add(refRetVal);
                } else {
                    ArrayList<WeakReference<FileNaming>> l = new ArrayList<WeakReference<FileNaming>>();
                    l.add(refRetVal);
                    nameMap.put(retVal.getId(), l);
                }
            } else {
                FileName original;
                Reference r = nameMap.put(retVal.getId(), refRetVal);
                if (ignoreCache && r != null && (original = (FileName)r.get()) != null) {
                    List children = NamingFactory.collectChildren(original);
                    for (FileNaming child : children) {
                        NamingFactory.removeImpl(child, null);
                    }
                }
            }
        }
        assert (retVal != null);
        return retVal;
    }

    private static List collectChildren(FileName parent) {
        assert (Thread.holdsLock(NamingFactory.class));
        ArrayList<FileNaming> retval = new ArrayList<FileNaming>();
        for (Object value : nameMap.values()) {
            if (value instanceof List) {
                for (Object item : (List)value) {
                    Reference ref = (Reference)item;
                    FileNaming naming = (FileNaming)ref.get();
                    if (!NamingFactory.isChild(parent, naming)) continue;
                    retval.add(naming);
                }
                continue;
            }
            Reference ref = (Reference)value;
            FileNaming naming = (FileNaming)ref.get();
            if (!NamingFactory.isChild(parent, naming)) continue;
            retval.add(naming);
        }
        return retval;
    }

    private static boolean isChild(FileName parent, FileNaming naming) {
        for (FileNaming temp = naming; temp != null; temp = temp.getParent()) {
            if (temp != parent) continue;
            return true;
        }
        return false;
    }

    private static Reference getReference(List list, File f) {
        Reference retVal = null;
        for (int i = 0; retVal == null && i < list.size(); ++i) {
            FileNaming cachedElement;
            Reference ref = (Reference)list.get(i);
            FileNaming fileNaming = cachedElement = ref != null ? (FileNaming)ref.get() : null;
            if (cachedElement == null || cachedElement.getFile().compareTo(f) != 0) continue;
            retVal = ref;
        }
        return retVal;
    }

    private static FileNaming createFileNaming(File f, FileNaming parentName, FileType type) {
        FileName retVal = null;
        if (type.equals((Object)FileType.unknown)) {
            type = f.isDirectory() ? FileType.directory : FileType.file;
        }
        switch (type) {
            case file: {
                retVal = new FileName(parentName, f);
                break;
            }
            case directory: {
                retVal = new FolderName(parentName, f);
            }
        }
        return retVal;
    }

    public static enum FileType {
        file,
        directory,
        unknown;

    }
}

