/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeletableState;

public abstract class DeletePresenter
extends Presenter {
    DeletableState canDelete() {
        return DeletableState.ALLOWED;
    }

    boolean isSilent() {
        return false;
    }

    protected abstract void delete();

    public static Presenter createSilentDeletionPresenter() {
        return new DeletePresenter(){

            @Override
            boolean isSilent() {
                return true;
            }

            @Override
            protected void delete() {
            }
        };
    }

    public static Presenter createIndeliblePresenter() {
        return new DeletePresenter(){

            @Override
            DeletableState canDelete() {
                return DeletableState.DISALLOWED;
            }

            @Override
            protected void delete() {
                throw Debug.illegalState(new Object[0]);
            }
        };
    }

    public static Presenter createUserIndeliblePresenter() {
        return new DeletePresenter(){

            @Override
            DeletableState canDelete() {
                return DeletableState.DISALLOWED_FOR_USER_ONLY;
            }

            @Override
            protected void delete() {
            }
        };
    }

    public static Presenter createRemoveComponentReferences() {
        return new DeletePresenter(){

            @Override
            DeletableState canDelete() {
                return DeletableState.ALLOWED;
            }

            @Override
            protected void delete() {
                DesignComponent root = this.getComponent().getDocument().getRootComponent();
                this.search(root);
            }

            private void search(DesignComponent root) {
                for (DesignComponent component : root.getComponents()) {
                    if (component.getComponents() != null) {
                        this.search(component);
                    }
                    this.removeReferences(component);
                }
            }

            private void removeReferences(DesignComponent component) {
                List<PropertyDescriptor> descriptors = component.getComponentDescriptor().getDeclaredPropertyDescriptors();
                if (descriptors == null) {
                    return;
                }
                for (PropertyDescriptor descriptor : descriptors) {
                    PropertyValue value = component.readProperty(descriptor.getName());
                    if (value.getComponent() == null || value.getComponent() != this.getComponent()) continue;
                    component.writeProperty(descriptor.getName(), PropertyValue.createNull());
                }
            }
        };
    }
}

