/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiProjectsListRenderer;
import org.netbeans.modules.kenai.ui.NewKenaiProjectAction;
import org.netbeans.modules.kenai.ui.SearchField;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.kenai.ui.treelist.TreeListUI;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class KenaiSearchPanel
extends JPanel {
    private final JLabel noSearchResultsLabel = new JLabel(NbBundle.getMessage(KenaiSearchPanel.class, (String)"NoSearchResults.label.text"));
    private final JLabel noMatchingResultsLabel = new JLabel(NbBundle.getMessage(KenaiSearchPanel.class, (String)"NoResultsMatching.label.text"));
    private final JLabel badRequest = new JLabel();
    private JPanel noSearchLabelPanel;
    private JPanel noMatchingLabelPanel;
    private JPanel badRequestPanel;
    private static JList kenaiFeaturedProjectsList = null;
    private static JList kenaiFeaturedProjectsListWithRepos = null;
    private static JList kenaiRecentProjectsList = null;
    private static JList kenaiRecentProjectsListWithRepos = null;
    private PanelType panelType;
    private ProgressHandle progressHandle;
    private ProgressHandle progressHandleFeatured;
    private ProgressHandle progressHandleRecent;
    private boolean progressRunning;
    private boolean multiSelection;
    private KenaiProjectsListModel listModel;
    private static Kenai kenai;
    private RequestProcessor rp = new RequestProcessor("Kenai Search Panel", 3);
    private static final int projectURLGroup = 1;
    private JPanel createButtonPanel;
    private JButton createNewProjectButton;
    private JPanel featuredProjectPanel;
    private JList kenaiProjectsList;
    private JTabbedPane kenaiProjectsTabPane;
    private JLabel projectsLabel;
    private JPanel recentProjectPanel;
    private JScrollPane scrollPane;
    private JScrollPane scrollPaneFeatured;
    private JScrollPane scrollPaneRecent;
    private JButton searchButton;
    private JPanel searchButtonPanel;
    private JLabel searchInfoLabel;
    private JLabel searchLabel;
    private JPanel searchResultsPanel;
    private SearchField searchTextField;

    public KenaiSearchPanel(PanelType type, boolean multiSel, Kenai k) {
        this.panelType = type;
        this.multiSelection = multiSel;
        boolean clear = false;
        if (kenai != k) {
            kenai = k;
            clear = true;
        }
        this.initComponents();
        this.setChildrenEnabled(this, kenai != null);
        if (clear) {
            this.clearRecentAndFeatured();
        }
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("search".equals(e.getActionCommand())) {
                    KenaiSearchPanel.this.invokeSearch();
                } else {
                    kenai = KenaiSearchPanel.this.searchTextField.getSelectedKenai();
                    KenaiSearchPanel.this.setChildrenEnabled(KenaiSearchPanel.this, kenai != null);
                    KenaiSearchPanel.this.clearRecentAndFeatured();
                }
            }
        });
        this.kenaiProjectsList.setUI(new TreeListUI());
        this.noSearchLabelPanel = this.createLabelPanel(this.noSearchResultsLabel);
        this.noMatchingLabelPanel = this.createLabelPanel(this.noMatchingResultsLabel);
        this.badRequestPanel = this.createLabelPanel(this.badRequest);
        this.searchResultsPanel.remove(this.scrollPane);
        this.searchResultsPanel.add((Component)this.noSearchLabelPanel, "Center");
        if (this.panelType == PanelType.BROWSE) {
            this.remove(this.createButtonPanel);
        }
        final ListSelectionModel selModel = this.kenaiProjectsList.getSelectionModel();
        selModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (selModel.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        this.kenaiProjectsTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (kenaiFeaturedProjectsList != null) {
                    kenaiFeaturedProjectsList.clearSelection();
                }
                if (kenaiRecentProjectsList != null) {
                    kenaiRecentProjectsList.clearSelection();
                }
                if (kenaiFeaturedProjectsListWithRepos != null) {
                    kenaiFeaturedProjectsListWithRepos.clearSelection();
                }
                if (kenaiRecentProjectsListWithRepos != null) {
                    kenaiRecentProjectsListWithRepos.clearSelection();
                }
                KenaiSearchPanel.this.kenaiProjectsList.clearSelection();
            }
        });
        if (this.panelType == PanelType.OPEN) {
            this.setOpenPanels();
        } else {
            this.setBrowsePanels();
        }
    }

    private void setChildrenEnabled(Component root, boolean enabled) {
        root.setEnabled(enabled);
        if (root instanceof Container) {
            for (Component c : ((Container)root).getComponents()) {
                if (c == this.searchTextField) continue;
                this.setChildrenEnabled(c, enabled);
            }
        }
    }

    private void clearRecentAndFeatured() {
        kenaiFeaturedProjectsList = null;
        kenaiRecentProjectsList = null;
        kenaiFeaturedProjectsListWithRepos = null;
        kenaiRecentProjectsListWithRepos = null;
        if (this.panelType == PanelType.OPEN) {
            this.setOpenPanels();
        } else {
            this.setBrowsePanels();
        }
    }

    private void setOpenPanels() {
        if (kenaiFeaturedProjectsList == null || kenaiFeaturedProjectsList.getModel().getSize() == 0) {
            kenaiFeaturedProjectsList = new JList();
            kenaiFeaturedProjectsList.setUI(new TreeListUI());
            kenaiFeaturedProjectsList.setSelectionMode(this.getListSelMode());
            kenaiFeaturedProjectsList.setCellRenderer(new KenaiProjectsListRenderer2());
            kenaiFeaturedProjectsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleName"));
            kenaiFeaturedProjectsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleDescription"));
            this.progressHandleFeatured = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabelFeatured"));
            this.presentSpecialProjects(this.featuredProjectPanel, this.scrollPaneFeatured, kenaiFeaturedProjectsList, "featured", this.progressHandleFeatured);
        }
        if (kenaiRecentProjectsList == null || kenaiRecentProjectsList.getModel().getSize() == 0) {
            kenaiRecentProjectsList = new JList();
            kenaiRecentProjectsList.setUI(new TreeListUI());
            kenaiRecentProjectsList.setSelectionMode(this.getListSelMode());
            kenaiRecentProjectsList.setCellRenderer(new KenaiProjectsListRenderer2());
            kenaiRecentProjectsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleName"));
            kenaiRecentProjectsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleDescription"));
            this.progressHandleRecent = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabelRecent"));
            this.presentSpecialProjects(this.recentProjectPanel, this.scrollPaneRecent, kenaiRecentProjectsList, "recent", this.progressHandleRecent);
        }
        final ListSelectionModel selModelRecent = kenaiRecentProjectsList.getSelectionModel();
        selModelRecent.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (selModelRecent.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        final ListSelectionModel selModelFeatured = kenaiFeaturedProjectsList.getSelectionModel();
        selModelFeatured.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (selModelFeatured.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        kenaiFeaturedProjectsList.clearSelection();
        kenaiRecentProjectsList.clearSelection();
        this.scrollPaneRecent.setViewportView(kenaiRecentProjectsList);
        this.scrollPaneFeatured.setViewportView(kenaiFeaturedProjectsList);
    }

    private void setBrowsePanels() {
        if (kenaiFeaturedProjectsListWithRepos == null || kenaiFeaturedProjectsListWithRepos.getModel().getSize() == 0) {
            kenaiFeaturedProjectsListWithRepos = new JList();
            kenaiFeaturedProjectsListWithRepos.setUI(new TreeListUI());
            kenaiFeaturedProjectsListWithRepos.setSelectionMode(this.getListSelMode());
            kenaiFeaturedProjectsListWithRepos.setCellRenderer(new KenaiProjectsListRenderer2());
            kenaiFeaturedProjectsListWithRepos.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleName"));
            kenaiFeaturedProjectsListWithRepos.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleDescription"));
            this.progressHandleFeatured = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabelFeatured"));
            this.presentSpecialProjects(this.featuredProjectPanel, this.scrollPaneFeatured, kenaiFeaturedProjectsListWithRepos, "featured", this.progressHandleFeatured);
        }
        if (kenaiRecentProjectsListWithRepos == null || kenaiRecentProjectsListWithRepos.getModel().getSize() == 0) {
            kenaiRecentProjectsListWithRepos = new JList();
            kenaiRecentProjectsListWithRepos.setUI(new TreeListUI());
            kenaiRecentProjectsListWithRepos.setSelectionMode(this.getListSelMode());
            kenaiRecentProjectsListWithRepos.setCellRenderer(new KenaiProjectsListRenderer2());
            kenaiRecentProjectsListWithRepos.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleName"));
            kenaiRecentProjectsListWithRepos.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleDescription"));
            this.progressHandleRecent = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabelRecent"));
            this.presentSpecialProjects(this.recentProjectPanel, this.scrollPaneRecent, kenaiRecentProjectsListWithRepos, "recent", this.progressHandleRecent);
        }
        final ListSelectionModel selModelRecent = kenaiRecentProjectsListWithRepos.getSelectionModel();
        selModelRecent.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (selModelRecent.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        final ListSelectionModel selModelFeatured = kenaiFeaturedProjectsListWithRepos.getSelectionModel();
        selModelFeatured.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (selModelFeatured.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        kenaiFeaturedProjectsListWithRepos.clearSelection();
        kenaiRecentProjectsListWithRepos.clearSelection();
        this.scrollPaneRecent.setViewportView(kenaiRecentProjectsListWithRepos);
        this.scrollPaneFeatured.setViewportView(kenaiFeaturedProjectsListWithRepos);
    }

    public KenaiProject getSelectedProject() {
        KenaiProjectSearchInfo searchInfo = null;
        searchInfo = this.kenaiProjectsTabPane.getSelectedComponent().equals(this.featuredProjectPanel) ? (KenaiProjectSearchInfo)kenaiFeaturedProjectsList.getSelectedValue() : (this.kenaiProjectsTabPane.getSelectedComponent().equals(this.recentProjectPanel) ? (KenaiProjectSearchInfo)kenaiRecentProjectsList.getSelectedValue() : (KenaiProjectSearchInfo)this.kenaiProjectsList.getSelectedValue());
        return searchInfo != null ? searchInfo.kenaiProject : null;
    }

    public KenaiProjectSearchInfo getSelectedProjectSearchInfo() {
        KenaiProjectSearchInfo searchInfo = null;
        searchInfo = this.kenaiProjectsTabPane.getSelectedComponent().equals(this.featuredProjectPanel) ? (KenaiProjectSearchInfo)(this.panelType == PanelType.OPEN ? kenaiFeaturedProjectsList.getSelectedValue() : kenaiFeaturedProjectsListWithRepos.getSelectedValue()) : (this.kenaiProjectsTabPane.getSelectedComponent().equals(this.recentProjectPanel) ? (KenaiProjectSearchInfo)(this.panelType == PanelType.OPEN ? kenaiRecentProjectsList.getSelectedValue() : kenaiRecentProjectsListWithRepos.getSelectedValue()) : (KenaiProjectSearchInfo)this.kenaiProjectsList.getSelectedValue());
        return searchInfo != null ? searchInfo : null;
    }

    public KenaiProject[] getSelectedProjects() {
        Object[] searchInfos = null;
        searchInfos = this.kenaiProjectsTabPane.getSelectedComponent().equals(this.featuredProjectPanel) ? (this.panelType == PanelType.OPEN ? kenaiFeaturedProjectsList.getSelectedValues() : kenaiFeaturedProjectsListWithRepos.getSelectedValues()) : (this.kenaiProjectsTabPane.getSelectedComponent().equals(this.recentProjectPanel) ? (this.panelType == PanelType.OPEN ? kenaiRecentProjectsList.getSelectedValues() : kenaiRecentProjectsListWithRepos.getSelectedValues()) : this.kenaiProjectsList.getSelectedValues());
        KenaiProject[] selPrjs = new KenaiProject[searchInfos.length];
        int i = 0;
        for (Object searchInfo : searchInfos) {
            selPrjs[i++] = ((KenaiProjectSearchInfo)searchInfo).kenaiProject;
        }
        return searchInfos.length > 0 ? selPrjs : null;
    }

    private int getListSelMode() {
        if (!this.multiSelection) {
            return 0;
        }
        return 2;
    }

    private void initComponents() {
        this.searchButtonPanel = new JPanel();
        this.searchTextField = new SearchField(kenai);
        this.searchLabel = new JLabel();
        this.searchButton = new JButton();
        this.searchInfoLabel = new JLabel();
        this.projectsLabel = new JLabel();
        this.createButtonPanel = new JPanel();
        this.createNewProjectButton = new JButton();
        this.kenaiProjectsTabPane = new JTabbedPane();
        this.featuredProjectPanel = new JPanel();
        this.scrollPaneFeatured = new JScrollPane();
        this.recentProjectPanel = new JPanel();
        this.scrollPaneRecent = new JScrollPane();
        this.searchResultsPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.kenaiProjectsList = new JList();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setPreferredSize(new Dimension(700, 500));
        this.setLayout(new BorderLayout());
        this.searchButtonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.searchButtonPanel.add((Component)this.searchTextField, gridBagConstraints);
        this.searchLabel.setLabelFor(this.searchTextField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.searchButtonPanel.add((Component)this.searchLabel, gridBagConstraints);
        this.searchLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KenaiSearchPanel.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.searchButtonPanel.add((Component)this.searchButton, gridBagConstraints);
        this.searchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchButton.AccessibleContext.accessibleDescription"));
        this.searchInfoLabel.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchInfoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.searchButtonPanel.add((Component)this.searchInfoLabel, gridBagConstraints);
        this.searchInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchInfoLabel.AccessibleContext.accessibleDescription"));
        this.projectsLabel.setLabelFor(this.kenaiProjectsTabPane);
        this.projectsLabel.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.projectsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 4, 0);
        this.searchButtonPanel.add((Component)this.projectsLabel, gridBagConstraints);
        this.projectsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.projectsLabel.AccessibleContext.accessibleDescription"));
        this.add((Component)this.searchButtonPanel, "North");
        this.createButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.createNewProjectButton, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.createNewProjectButton.text"));
        this.createNewProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KenaiSearchPanel.this.createNewProjectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.createButtonPanel.add((Component)this.createNewProjectButton, gridBagConstraints);
        this.createNewProjectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.createNewProjectButton.AccessibleContext.accessibleDescription"));
        this.add((Component)this.createButtonPanel, "South");
        this.featuredProjectPanel.setLayout(new BorderLayout());
        this.featuredProjectPanel.add((Component)this.scrollPaneFeatured, "Center");
        this.kenaiProjectsTabPane.addTab(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.featuredProjectPanel.TabConstraints.tabTitle"), this.featuredProjectPanel);
        this.recentProjectPanel.setLayout(new BorderLayout());
        this.recentProjectPanel.add((Component)this.scrollPaneRecent, "Center");
        this.kenaiProjectsTabPane.addTab(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.recentProjectPanel.TabConstraints.tabTitle"), this.recentProjectPanel);
        this.searchResultsPanel.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.kenaiProjectsList.setSelectionMode(this.getListSelMode());
        this.kenaiProjectsList.setCellRenderer(new KenaiProjectsListRenderer2());
        this.scrollPane.setViewportView(this.kenaiProjectsList);
        this.kenaiProjectsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleName"));
        this.kenaiProjectsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleDescription"));
        this.searchResultsPanel.add((Component)this.scrollPane, "Center");
        this.kenaiProjectsTabPane.addTab(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchResultsPanel.TabConstraints.tabTitle"), this.searchResultsPanel);
        this.add((Component)this.kenaiProjectsTabPane, "Center");
        this.kenaiProjectsTabPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsTabPane.AccessibleContext.accessibleName"));
        this.kenaiProjectsTabPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsTabPane.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.AccessibleContext.accessibleDescription"));
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.invokeSearch();
    }

    private void createNewProjectButtonActionPerformed(ActionEvent evt) {
        new NewKenaiProjectAction().actionPerformed(evt);
    }

    private void presentSpecialProjects(final JPanel wherePanel, final JScrollPane whereScrollPane, final JList whereList, final String type, final ProgressHandle ph) {
        if (kenai == null) {
            return;
        }
        final JPanel progressPanel = this.createProgressPanel(ph);
        wherePanel.add((Component)progressPanel, "Center");
        this.revalidate();
        this.repaint();
        ph.start();
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                Iterator<KenaiProject> projectsIterator = null;
                String searchPattern = "&filter=" + type;
                try {
                    projectsIterator = kenai.searchProjects(searchPattern).iterator();
                }
                catch (KenaiException em) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ph.finish();
                            wherePanel.remove(progressPanel);
                            if ("400 Bad Request".equals(em.getStatus())) {
                                KenaiSearchPanel.this.badRequest.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"BadRequest.label.text"));
                            } else {
                                KenaiSearchPanel.this.badRequest.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"ServerError.label.text"));
                            }
                            wherePanel.add((Component)KenaiSearchPanel.this.badRequestPanel, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                    Logger.getLogger(KenaiSearchPanel.class.getName()).log(Level.INFO, em.getMessage(), em);
                    return;
                }
                if (projectsIterator != null && projectsIterator.hasNext()) {
                    final KenaiProjectsListModel listModel = new KenaiProjectsListModel(projectsIterator, searchPattern, whereList);
                    KenaiSearchPanel.this.setListModel(listModel);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ph.finish();
                            wherePanel.remove(progressPanel);
                            whereList.setModel(listModel);
                            wherePanel.add((Component)whereScrollPane, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ph.finish();
                            wherePanel.remove(progressPanel);
                            wherePanel.add((Component)KenaiSearchPanel.this.noMatchingLabelPanel, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void invokeSearch() {
        UIUtils.logKenaiUsage("PROJECT_SEARCH");
        this.kenaiProjectsTabPane.setSelectedComponent(this.searchResultsPanel);
        this.kenaiProjectsTabPane.validate();
        if (this.getListModel() != null) {
            this.getListModel().stopLoading();
        }
        this.searchTextField.setText(this.searchTextField.getText().toLowerCase());
        this.searchButton.setEnabled(false);
        this.searchTextField.setEnabled(false);
        boolean showProgressAndRepaint = false;
        this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabel"));
        final JPanel progressPanel = this.createProgressPanel(this.progressHandle);
        if (this.scrollPane.isShowing()) {
            this.searchResultsPanel.remove(this.scrollPane);
            showProgressAndRepaint = true;
        } else if (this.noSearchLabelPanel != null && this.noSearchLabelPanel.isShowing()) {
            this.searchResultsPanel.remove(this.noSearchLabelPanel);
            showProgressAndRepaint = true;
        } else if (this.noMatchingLabelPanel != null && this.noMatchingLabelPanel.isShowing()) {
            this.searchResultsPanel.remove(this.noMatchingLabelPanel);
            showProgressAndRepaint = true;
        } else if (this.badRequestPanel != null && this.badRequestPanel.isShowing()) {
            this.searchResultsPanel.remove(this.badRequestPanel);
            showProgressAndRepaint = true;
        }
        if (showProgressAndRepaint) {
            this.searchResultsPanel.add((Component)progressPanel, "Center");
            this.startProgress();
            this.revalidate();
            this.repaint();
        }
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                Iterator<KenaiProject> projectsIterator = null;
                String searchPattern = KenaiSearchPanel.this.searchTextField.getText();
                Pattern projectURLPattern = Pattern.compile(kenai.getUrl().toString().replaceFirst("^https://", "http://") + "/projects/([^/]*)/?.*");
                Matcher m = projectURLPattern.matcher(searchPattern);
                if (m.matches()) {
                    searchPattern = m.group(1);
                }
                try {
                    projectsIterator = kenai.searchProjects(searchPattern).iterator();
                }
                catch (KenaiException em) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KenaiSearchPanel.this.finishProgress();
                            KenaiSearchPanel.this.searchResultsPanel.remove(progressPanel);
                            KenaiSearchPanel.this.searchButton.setEnabled(true);
                            KenaiSearchPanel.this.searchTextField.setEnabled(true);
                            if ("400 Bad Request".equals(em.getStatus())) {
                                KenaiSearchPanel.this.badRequest.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"BadRequest.label.text"));
                            } else {
                                KenaiSearchPanel.this.badRequest.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"ServerError.label.text"));
                            }
                            KenaiSearchPanel.this.searchResultsPanel.add((Component)KenaiSearchPanel.this.badRequestPanel, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                            KenaiSearchPanel.this.searchTextField.requestFocus();
                        }
                    });
                    Logger.getLogger(KenaiSearchPanel.class.getName()).log(Level.INFO, em.getMessage(), em);
                    return;
                }
                if (projectsIterator != null && projectsIterator.hasNext()) {
                    final KenaiProjectsListModel listModel = new KenaiProjectsListModel(projectsIterator, searchPattern, KenaiSearchPanel.this.kenaiProjectsList);
                    KenaiSearchPanel.this.setListModel(listModel);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KenaiSearchPanel.this.kenaiProjectsList.setModel(listModel);
                            KenaiSearchPanel.this.finishProgress();
                            KenaiSearchPanel.this.searchResultsPanel.remove(progressPanel);
                            KenaiSearchPanel.this.searchButton.setEnabled(true);
                            KenaiSearchPanel.this.searchTextField.setEnabled(true);
                            KenaiSearchPanel.this.searchResultsPanel.add((Component)KenaiSearchPanel.this.scrollPane, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KenaiSearchPanel.this.finishProgress();
                            KenaiSearchPanel.this.searchResultsPanel.remove(progressPanel);
                            KenaiSearchPanel.this.searchButton.setEnabled(true);
                            KenaiSearchPanel.this.searchTextField.setEnabled(true);
                            KenaiSearchPanel.this.searchResultsPanel.add((Component)KenaiSearchPanel.this.noMatchingLabelPanel, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                            KenaiSearchPanel.this.searchTextField.requestFocus();
                        }
                    });
                }
            }
        });
    }

    private synchronized void setListModel(KenaiProjectsListModel model) {
        this.listModel = model;
    }

    private synchronized KenaiProjectsListModel getListModel() {
        return this.listModel;
    }

    private synchronized void startProgress() {
        if (!this.progressRunning && this.progressHandle != null) {
            this.progressHandle.start();
            this.progressRunning = true;
        }
    }

    private synchronized void finishProgress() {
        if (this.progressRunning && this.progressHandle != null) {
            this.progressHandle.finish();
            this.progressRunning = false;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KenaiProjectsListModel model = this.getListModel();
        if (model != null) {
            model.stopLoading();
        }
    }

    private JPanel createLabelPanel(JLabel label) {
        JPanel panel = this.preparePanel();
        label.setEnabled(false);
        label.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 0, 20, 0);
        panel.add((Component)label, constraints);
        JScrollPane scrlPane = new JScrollPane();
        scrlPane.setViewportView(panel);
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)scrlPane, "Center");
        return pnl;
    }

    private JPanel createProgressPanel(ProgressHandle progressHandle) {
        JPanel panel = this.preparePanel();
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel progressLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 0.5;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 40, 0, 40);
        panel.add((Component)progressLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.5;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 40, 20, 40);
        panel.add((Component)progressComponent, constraints);
        JScrollPane scrlPane = new JScrollPane();
        scrlPane.setViewportView(panel);
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)scrlPane, "Center");
        return pnl;
    }

    private JPanel preparePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Color bgColor = UIManager.getColor("window");
        panel.setBackground(bgColor != null ? bgColor : Color.WHITE);
        return panel;
    }

    public static class KenaiProjectSearchInfo {
        public KenaiProject kenaiProject;
        public KenaiFeature kenaiFeature;
        public String searchPattern;

        public KenaiProjectSearchInfo(KenaiProject kprj, String ptrn) {
            this.kenaiProject = kprj;
            this.searchPattern = ptrn;
            this.kenaiFeature = null;
        }

        public KenaiProjectSearchInfo(KenaiProject kprj, KenaiFeature ftr, String ptrn) {
            this.kenaiProject = kprj;
            this.kenaiFeature = ftr;
            this.searchPattern = ptrn;
        }
    }

    private class KenaiProjectsListModel
    extends DefaultListModel
    implements Runnable {
        private Iterator<KenaiProject> projects;
        private String pattern;
        private JList kpList;
        private static final int MAX_PROJECT_COUNT = 100;
        private boolean itemSelected = false;
        private boolean stopLoading;

        public KenaiProjectsListModel(Iterator<KenaiProject> projects, String pattern, JList kpLst) {
            this.projects = projects;
            this.pattern = pattern;
            this.kpList = kpLst;
            KenaiSearchPanel.this.rp.post((Runnable)this);
        }

        @Override
        public void run() {
            if (this.projects != null) {
                int count = 0;
                while (this.projects.hasNext() && count < 100) {
                    KenaiProject project = this.projects.next();
                    ++count;
                    try {
                        project.getProjectIcon();
                    }
                    catch (KenaiException ex) {
                        Logger.getLogger(KenaiSearchPanel.class.getName()).log(Level.INFO, "There are problems with getting a project icon - maybe see http://www.netbeans.org/issues/show_bug.cgi?id=172649", ex);
                    }
                    if (PanelType.OPEN.equals((Object)KenaiSearchPanel.this.panelType)) {
                        this.addElementLater(new KenaiProjectSearchInfo(project, this.pattern));
                    } else if (PanelType.BROWSE.equals((Object)KenaiSearchPanel.this.panelType)) {
                        try {
                            KenaiFeature[] repos;
                            for (KenaiFeature repo : repos = project.getFeatures(KenaiService.Type.SOURCE)) {
                                if (!"subversion".equals(repo.getService()) && !"mercurial".equals(repo.getService())) continue;
                                this.addElementLater(new KenaiProjectSearchInfo(project, repo, this.pattern));
                            }
                        }
                        catch (KenaiException kenaiException) {
                            Exceptions.printStackTrace((Throwable)kenaiException);
                        }
                    }
                    Thread.yield();
                    if (!this.loadingStopped()) continue;
                    return;
                }
            }
        }

        public synchronized void stopLoading() {
            this.stopLoading = true;
        }

        public synchronized boolean loadingStopped() {
            return this.stopLoading;
        }

        private void addElementLater(final KenaiProjectSearchInfo kenaiProjectSearchInfo) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KenaiProjectsListModel.this.addElement(kenaiProjectSearchInfo);
                    if (!KenaiProjectsListModel.this.itemSelected) {
                        KenaiProjectsListModel.this.kpList.requestFocus();
                        KenaiProjectsListModel.this.kpList.setSelectedIndex(0);
                        KenaiProjectsListModel.this.itemSelected = true;
                    }
                }
            });
        }
    }

    private class KenaiProjectsListRenderer2
    implements ListCellRenderer {
        private KenaiProjectsListRenderer2() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return new KenaiProjectsListRenderer(list, value, index, isSelected, cellHasFocus);
        }
    }

    public static enum PanelType {
        OPEN,
        BROWSE;

    }
}

