/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.cpu;

import java.awt.Color;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.datacollector.CpuSamplingSupport;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.visualizers.api.CallersCalleesVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public final class DLightCPUToolConfigurationProvider
implements DLightToolConfigurationProvider {
    public static final int INDICATOR_POSITION = 100;
    public static final String ID = "dlight.tool.cpu";
    private static final String TOOL_NAME = DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ToolName", new String[0]);
    private static final String DETAILED_TOOL_NAME = DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.DetailedToolName", new String[0]);
    private static final boolean CPU_TREE_TABLE = Boolean.valueOf(System.getProperty("cpu.tree.table", "false"));

    public DLightToolConfiguration create() {
        CallersCalleesVisualizerConfiguration detailsVisualizerConfigSS;
        DLightToolConfiguration toolConfiguration = new DLightToolConfiguration(ID, TOOL_NAME);
        toolConfiguration.setLongName(DETAILED_TOOL_NAME);
        toolConfiguration.setDescription(DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.Description", new String[0]));
        toolConfiguration.setIcon("org/netbeans/modules/dlight/cpu/resources/cpu.png");
        FeatureDescriptor descriptor = new FeatureDescriptor();
        descriptor.setValue("dtrace.script", CpuSamplingSupport.CPU_SAMPLING_SCRIPT_URL);
        toolConfiguration.setFeatureDescriptor(descriptor);
        SunStudioDCConfiguration ssCollectorConfig = new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.FUNCTIONS_LIST);
        toolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)ssCollectorConfig);
        DataTableMetadata detailedViewTableMetadataSS = SunStudioDCConfiguration.getCPUTableMetadata((DataTableMetadata.Column[])new DataTableMetadata.Column[]{SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_iUser, SunStudioDCConfiguration.c_eUser});
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setDisplayedName(SunStudioDCConfiguration.c_name.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.func_name", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_iUser.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.time_incl", new String[0]), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnTooltip.time_incl", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_eUser.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.time_excl", new String[0]), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnTooltip.time_excl", new String[0]));
        if (CPU_TREE_TABLE) {
            detailsVisualizerConfigSS = new CallersCalleesVisualizerConfiguration(detailedViewTableMetadataSS, "name", false);
            detailsVisualizerConfigSS.setColumnsUIMapping(columnsUIMapping);
        } else {
            FunctionDatatableDescription funcDescription = new FunctionDatatableDescription(SunStudioDCConfiguration.c_name.getColumnName(), null, SunStudioDCConfiguration.c_name.getColumnName());
            detailsVisualizerConfigSS = new FunctionsListViewVisualizerConfiguration(detailedViewTableMetadataSS, funcDescription, Arrays.asList(SunStudioDCConfiguration.c_eUser, SunStudioDCConfiguration.c_iUser));
            ((FunctionsListViewVisualizerConfiguration)detailsVisualizerConfigSS).setColumnsUIMapping(columnsUIMapping);
            ((FunctionsListViewVisualizerConfiguration)detailsVisualizerConfigSS).setEmptyAnalyzeMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
            ((FunctionsListViewVisualizerConfiguration)detailsVisualizerConfigSS).setEmptyRunningMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        }
        DTDCConfiguration dtraceDataCollectorConfiguration = DTDCConfiguration.createCpuSamplingConfiguration();
        toolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)dtraceDataCollectorConfiguration);
        VisualizerConfiguration detailsVisualizerConfigDtrace = this.createDTraceBasedVisualizerConfiguration(CpuSamplingSupport.CPU_SAMPLE_TABLE);
        toolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)new ProcDataProviderConfiguration());
        toolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.CPU));
        ArrayList<DataTableMetadata.Column> resultColumns = new ArrayList<DataTableMetadata.Column>();
        resultColumns.add(ProcDataProviderConfiguration.USR_TIME);
        resultColumns.add(ProcDataProviderConfiguration.SYS_TIME);
        resultColumns.addAll(LLDataCollectorConfiguration.CPU_TABLE.getColumns());
        IndicatorMetadata indicatorMetadata = new IndicatorMetadata(resultColumns);
        TimeSeriesIndicatorConfiguration indicatorConfiguration = new TimeSeriesIndicatorConfiguration(indicatorMetadata, 100);
        indicatorConfiguration.setPersistencePrefix("dlight_cpu");
        indicatorConfiguration.setActionTooltip(DLightCPUToolConfigurationProvider.loc("indicator.action.tooltip", new String[0]));
        indicatorConfiguration.setTitle(DLightCPUToolConfigurationProvider.loc("indicator.title", new String[0]));
        indicatorConfiguration.setGraphScale(100);
        indicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{new TimeSeriesDescriptor("system", DLightCPUToolConfigurationProvider.loc("graph.description.system", new String[0]), new Color(255, 199, 38), TimeSeriesDescriptor.Kind.REL_SURFACE), new TimeSeriesDescriptor("user", DLightCPUToolConfigurationProvider.loc("graph.description.user", new String[0]), new Color(231, 111, 0), TimeSeriesDescriptor.Kind.REL_SURFACE)});
        indicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new DataRowToCpu(Arrays.asList(ProcDataProviderConfiguration.USR_TIME), Arrays.asList(ProcDataProviderConfiguration.SYS_TIME)));
        indicatorConfiguration.setActionDisplayName(DLightCPUToolConfigurationProvider.loc("indicator.action", new String[0]));
        indicatorConfiguration.addVisualizerConfiguration(detailsVisualizerConfigDtrace);
        indicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)detailsVisualizerConfigSS);
        toolConfiguration.addIndicatorConfiguration((IndicatorConfiguration)indicatorConfiguration);
        return toolConfiguration;
    }

    private VisualizerConfiguration createDTraceBasedVisualizerConfiguration(DataTableMetadata profilerTableMetadata) {
        ArrayList<DataTableMetadata.Column> columns = new ArrayList<DataTableMetadata.Column>();
        ArrayList<DataTableMetadata.Column> metrics = new ArrayList<DataTableMetadata.Column>();
        DataTableMetadata.Column nameColumn = new DataTableMetadata.Column("name", String.class, DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.name", new String[0]), null);
        columns.add(nameColumn);
        List metricsList = StackDataStorage.METRICS;
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        for (FunctionMetric metric : metricsList) {
            String metricID = metric.getMetricID();
            String displayedName = DLightCPUToolConfigurationProvider.locMetricDisplayedName(metricID);
            String metricTooltip = DLightCPUToolConfigurationProvider.locMetricTooltip(metricID);
            if (displayedName != null) {
                columnsUIMapping.setDisplayedName(metricID, displayedName);
            }
            if (metricTooltip != null) {
                columnsUIMapping.setTooltip(metricID, metricTooltip);
            }
            DataTableMetadata.Column metricColumn = new DataTableMetadata.Column(metricID, metric.getMetricValueClass(), metric.getMetricDisplayedName(), null);
            columns.add(metricColumn);
            metrics.add(metricColumn);
        }
        DataTableMetadata result = new DataTableMetadata("DtraceStack", columns, null, Arrays.asList(profilerTableMetadata));
        if (CPU_TREE_TABLE) {
            CallersCalleesVisualizerConfiguration configuration = new CallersCalleesVisualizerConfiguration(result, "name", false);
            configuration.setColumnsUIMapping(columnsUIMapping);
            return configuration;
        }
        FunctionDatatableDescription funcDescription = new FunctionDatatableDescription(nameColumn.getColumnName(), null, nameColumn.getColumnName());
        FunctionsListViewVisualizerConfiguration configuration = new FunctionsListViewVisualizerConfiguration(result, funcDescription, metrics);
        configuration.setEmptyAnalyzeMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        configuration.setEmptyRunningMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        configuration.setColumnsUIMapping(columnsUIMapping);
        return configuration;
    }

    private static String locMetricDisplayedName(String metricID) {
        try {
            return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)("FunctionMetric." + metricID));
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static String locMetricTooltip(String metricID) {
        try {
            return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)("FunctionMetric.tooltip." + metricID));
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)key, (Object[])params);
    }

    private static class DataRowToCpu
    implements DataRowToTimeSeries {
        private final List<DataTableMetadata.Column> usrColumns;
        private final List<DataTableMetadata.Column> sysColumns;

        public DataRowToCpu(List<DataTableMetadata.Column> usrColumns, List<DataTableMetadata.Column> sysColumns) {
            this.usrColumns = new ArrayList<DataTableMetadata.Column>(usrColumns);
            this.sysColumns = new ArrayList<DataTableMetadata.Column>(sysColumns);
        }

        public float[] getData(DataRow row) {
            float[] result = null;
            for (String columnName : row.getColumnNames()) {
                for (DataTableMetadata.Column usrColumn : this.usrColumns) {
                    if (!usrColumn.getColumnName().equals(columnName)) continue;
                    if (result == null) {
                        result = new float[2];
                    }
                    result[1] = DataUtil.toInt((Object)row.getData(columnName));
                }
                for (DataTableMetadata.Column sysColumn : this.sysColumns) {
                    if (!sysColumn.getColumnName().equals(columnName)) continue;
                    if (result == null) {
                        result = new float[2];
                    }
                    result[0] = DataUtil.toInt((Object)row.getData(columnName));
                }
            }
            return result;
        }

        public Map<String, String> getDetails() {
            return Collections.emptyMap();
        }
    }
}

