/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.modules.spellchecker.spi.LocaleQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DefaultLocaleQueryImplementation
implements LocaleQueryImplementation {
    private static final String FILE_NAME = "spellchecker-default-locale";

    public Locale findLocale(FileObject file) {
        return DefaultLocaleQueryImplementation.getDefaultLocale();
    }

    private static FileObject getDefaultLocaleFile() {
        return FileUtil.getConfigFile((String)FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getDefaultLocale() {
        FileObject file = DefaultLocaleQueryImplementation.getDefaultLocaleFile();
        if (file == null) {
            return Locale.getDefault();
        }
        Charset UTF8 = Charset.forName("UTF-8");
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(file.getInputStream(), UTF8));
            String localeLine = r.readLine();
            if (localeLine == null) {
                Locale locale = null;
                return locale;
            }
            String language = "";
            String country = "";
            String variant = "";
            StringTokenizer stok = new StringTokenizer(localeLine, "_");
            language = stok.nextToken();
            if (stok.hasMoreTokens()) {
                country = stok.nextToken();
                if (stok.hasMoreTokens()) {
                    variant = stok.nextToken();
                }
            }
            Locale locale = new Locale(language, country, variant);
            return locale;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultLocale(Locale locale) {
        FileObject file = DefaultLocaleQueryImplementation.getDefaultLocaleFile();
        Charset UTF8 = Charset.forName("UTF-8");
        FileLock lock = null;
        PrintWriter pw = null;
        try {
            if (file == null) {
                file = FileUtil.getConfigRoot().createData(FILE_NAME);
            }
            lock = file.lock();
            pw = new PrintWriter(new OutputStreamWriter(file.getOutputStream(lock), UTF8));
            pw.println(locale.toString());
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }
}

