/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.threetier;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.sessions.Login;

public class ConnectionPolicy
implements Cloneable,
Serializable {
    protected Login login;
    protected String poolName;
    protected boolean isLazy;
    protected Map properties;

    public ConnectionPolicy() {
        this.isLazy = true;
    }

    public ConnectionPolicy(String poolName) {
        this.isLazy = true;
        this.poolName = poolName;
    }

    public ConnectionPolicy(Login login) {
        this.isLazy = false;
        this.login = login;
    }

    public Object clone() {
        try {
            ConnectionPolicy clone = (ConnectionPolicy)super.clone();
            if (clone.hasLogin()) {
                clone.setLogin((Login)clone.getLogin().clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void dontUseLazyConnection() {
        this.setIsLazy(false);
    }

    public Login getLogin() {
        return this.login;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public Object getProperty(Object object) {
        if (this.hasProperties()) {
            return this.getProperties().get(object);
        }
        return null;
    }

    public boolean hasLogin() {
        return this.login != null;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isPooled() {
        return this.poolName != null;
    }

    public boolean isUserDefinedConnection() {
        return this.poolName == null;
    }

    public Object removeProperty(Object key) {
        if (this.hasProperties()) {
            return this.getProperties().remove(key);
        }
        return null;
    }

    public void setIsLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setProperty(Object key, Object property) {
        this.getProperties().put(key, property);
    }

    public String toString() {
        String type = "";
        type = this.isPooled() ? "(" + ToStringLocalization.buildMessage("pooled", null) + ": " + this.getPoolName() : "(" + ToStringLocalization.buildMessage("login", null) + ": " + this.getLogin();
        type = this.isLazy() ? type + "," + ToStringLocalization.buildMessage("lazy", null) + ")" : type + "," + ToStringLocalization.buildMessage("non-lazy", null) + ")";
        return Helper.getShortClassName(this.getClass()) + type;
    }

    public void useLazyConnection() {
        this.setIsLazy(true);
    }
}

