/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchSettings;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BranchAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 1208;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Branch";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 1208;
    }

    protected boolean asynchronous() {
        return false;
    }

    @Override
    public void performCvsAction(Node[] nodes) {
        Context context = this.getContext(nodes);
        if (context.getFiles().length == 0) {
            DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getBundle(BranchAction.class).getString("CTL_BranchDialogNone_Prompt"), NbBundle.getBundle(BranchAction.class).getString("CTL_BranchDialogNone_Title"), -1, 0, null, null));
            return;
        }
        String title = MessageFormat.format(NbBundle.getBundle(BranchAction.class).getString("CTL_BranchDialog_Title"), this.getContextDisplayName(nodes));
        JButton branch = new JButton(NbBundle.getMessage(BranchAction.class, (String)"CTL_BranchDialog_Action_Branch"));
        branch.setToolTipText(NbBundle.getMessage(BranchAction.class, (String)"TT_BranchDialog_Action_Branch"));
        BranchSettings settings = new BranchSettings(context.getFiles());
        settings.putClientProperty("OKButton", branch);
        settings.onBranchNameChange();
        DialogDescriptor descriptor = new DialogDescriptor((Object)settings, title, true, new Object[]{branch, DialogDescriptor.CANCEL_OPTION}, (Object)branch, 0, new HelpCtx(BranchAction.class), null);
        descriptor.setClosingOptions(null);
        settings.putClientProperty("org.openide.DialogDescriptor", descriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BranchAction.class, (String)"ACSD_BranchDialog"));
        dialog.setVisible(true);
        if (descriptor.getValue() != branch) {
            return;
        }
        settings.saveSettings();
        CvsVersioningSystem.getInstance().getParallelRequestProcessor().post((Runnable)new BranchExecutor(context, settings, this.getRunningName(nodes)));
    }

    private static class BranchExecutor
    implements Runnable {
        private final Context context;
        private final BranchSettings settings;
        private final String name;

        public BranchExecutor(Context context, BranchSettings settings, String name) {
            this.context = context;
            this.settings = settings;
            this.name = name;
        }

        @Override
        public void run() {
            ExecutorGroup group = new ExecutorGroup(this.name);
            if (this.settings.isTaggingBase()) {
                group.addExecutors(this.tag(this.context.getFiles(), this.settings.getBaseTagName()));
                group.addBarrier(null);
            }
            group.addExecutors(this.branch(this.context.getFiles(), this.settings.getBranchName()));
            group.addBarrier(null);
            if (this.settings.isCheckingOutBranch()) {
                group.addExecutors(this.update(this.context, this.settings.getBranchName()));
            }
            group.execute();
        }

        private ExecutorSupport[] update(Context context, String revision) {
            File[][] files = Utils.splitFlatOthers((File[])context.getRootFiles());
            ArrayList<UpdateExecutor> executors = new ArrayList<UpdateExecutor>();
            executors.addAll(this.update(files[0], revision, false));
            executors.addAll(this.update(files[1], revision, true));
            return executors.toArray(new ExecutorSupport[executors.size()]);
        }

        private List<UpdateExecutor> update(File[] roots, String revision, boolean recursive) {
            if (roots.length == 0) {
                return Collections.emptyList();
            }
            UpdateCommand cmd = new UpdateCommand();
            GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
            if (this.context.getExclusions().size() > 0) {
                options.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
            }
            cmd.setUpdateByRevision(revision);
            cmd.setFiles(roots);
            cmd.setRecursive(recursive);
            return Arrays.asList(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options, null));
        }

        private ExecutorSupport[] branch(File[] roots, String branchName) {
            File[][] files = Utils.splitFlatOthers((File[])roots);
            ArrayList<TagExecutor> executors = new ArrayList<TagExecutor>();
            executors.addAll(this.tag(files[0], branchName, true, false));
            executors.addAll(this.tag(files[1], branchName, true, true));
            return executors.toArray(new ExecutorSupport[executors.size()]);
        }

        private ExecutorSupport[] tag(File[] roots, String tagName) {
            File[][] files = Utils.splitFlatOthers((File[])roots);
            ArrayList<TagExecutor> executors = new ArrayList<TagExecutor>();
            executors.addAll(this.tag(files[0], tagName, false, false));
            executors.addAll(this.tag(files[1], tagName, false, true));
            return executors.toArray(new ExecutorSupport[executors.size()]);
        }

        private List<TagExecutor> tag(File[] roots, String branchName, boolean isBranch, boolean recursive) {
            if (roots.length == 0) {
                return Collections.emptyList();
            }
            TagCommand cmd = new TagCommand();
            cmd.setMakeBranchTag(isBranch);
            cmd.setFiles(roots);
            cmd.setTag(branchName);
            cmd.setRecursive(recursive);
            return Arrays.asList(TagExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), null));
        }
    }
}

