/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.projects.ToolTipView;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private static final int TO_STRING_LENGTH_LIMIT = 10000;
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        if ("true".equals(System.getProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips"))) {
            return null;
        }
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (jPDADebugger == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part == null) {
            return null;
        }
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        this.lp = part;
        this.ec = editorCookie;
        RequestProcessor requestProcessor = (RequestProcessor)debuggerEngine.lookupFirst(null, RequestProcessor.class);
        if (requestProcessor == null) {
            requestProcessor = RequestProcessor.getDefault();
        }
        requestProcessor.post((Runnable)this);
        return "";
    }

    @Override
    public void run() {
        Object object;
        Object object2;
        Object object3;
        String string;
        JEditorPane jEditorPane;
        ObjectVariable objectVariable;
        block23: {
            StyledDocument styledDocument;
            objectVariable = null;
            if (this.lp == null || this.ec == null) {
                return;
            }
            try {
                styledDocument = this.ec.openDocument();
            }
            catch (IOException iOException) {
                return;
            }
            jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
            if (jEditorPane == null) {
                return;
            }
            DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (debuggerEngine == null) {
                return;
            }
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger == null) {
                return;
            }
            JPDAThread jPDAThread = jPDADebugger.getCurrentThread();
            if (jPDAThread == null || !jPDAThread.isSuspended()) {
                return;
            }
            boolean[] blArray = new boolean[]{false};
            int n = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn();
            string = ToolTipAnnotation.getIdentifier(jPDADebugger, styledDocument, jEditorPane, n, blArray);
            if (string == null) {
                return;
            }
            object3 = null;
            try {
                Object object4;
                Object object5;
                object2 = null;
                object = jPDAThread.getLastOperations();
                if (object != null) {
                    object5 = object.iterator();
                    while (object5.hasNext()) {
                        object4 = (EditorContext.Operation)object5.next();
                        if (!string.endsWith(object4.getMethodName()) || object4.getMethodStartPosition().getOffset() > n || n > object4.getMethodEndPosition().getOffset()) continue;
                        object2 = object4.getReturnValue();
                    }
                }
                if (object2 == null) {
                    if (blArray[0]) {
                        return;
                    }
                    object2 = jPDADebugger.evaluate(string);
                }
                if (object2 == null) {
                    return;
                }
                object5 = object2.getType();
                if (object2 instanceof ObjectVariable) {
                    objectVariable = (ObjectVariable)object2;
                    try {
                        object4 = null;
                        try {
                            Method method = object2.getClass().getMethod("getToStringValue", Integer.TYPE);
                            method.setAccessible(true);
                            object4 = (String)method.invoke(object2, 10000);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (object4 == null) {
                            object4 = ((ObjectVariable)object2).getToStringValue();
                        }
                        object3 = string + " = " + (((String)object5).length() == 0 ? "" : "(" + (String)object5 + ") ") + (String)object4;
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        object3 = string + " = " + (((String)object5).length() == 0 ? "" : "(" + (String)object5 + ") ") + object2.getValue();
                    }
                    break block23;
                }
                object3 = string + " = " + (((String)object5).length() == 0 ? "" : "(" + (String)object5 + ") ") + object2.getValue();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                object = this.resolveTypeName(n, styledDocument);
                object3 = object != null ? object : string + " = >" + invalidExpressionException.getMessage() + "<";
            }
        }
        if (objectVariable != null) {
            object2 = ToolTipView.createExpandableTooltip((String)object3);
            object = objectVariable;
            ((ToolTipView.ExpandableTooltip)object2).addExpansionListener(new ActionListener((ToolTipView.ExpandableTooltip)object2, string, (ObjectVariable)object, jEditorPane){
                final /* synthetic */ ToolTipView.ExpandableTooltip val$et;
                final /* synthetic */ String val$expression;
                final /* synthetic */ ObjectVariable val$var;
                final /* synthetic */ JEditorPane val$ep;
                {
                    this.val$et = expandableTooltip;
                    this.val$expression = string;
                    this.val$var = objectVariable;
                    this.val$ep = jEditorPane;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$et.setBorder(BorderFactory.createLineBorder(this.val$et.getForeground()));
                    this.val$et.removeAll();
                    this.val$et.setWidthCheck(false);
                    this.val$et.add(ToolTipView.getToolTipView(this.val$expression, this.val$var));
                    this.val$et.revalidate();
                    this.val$et.repaint();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Utilities.getEditorUI((JTextComponent)val$ep).getToolTipSupport().setToolTip((JComponent)val$et, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0, 4);
                        }
                    });
                }
            });
            Utilities.getEditorUI((JTextComponent)jEditorPane).getToolTipSupport().setToolTip((JComponent)object2);
        } else {
            this.firePropertyChange("shortDescription", null, object3);
        }
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(JPDADebugger jPDADebugger, StyledDocument styledDocument, JEditorPane jEditorPane, int n, boolean[] blArray) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && (Character.isJavaIdentifierPart(string.charAt(n5 - 1)) || string.charAt(n5 - 1) == '.'); --n5) {
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            int n8 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2) + n5 + 1;
            if (!ToolTipAnnotation.isValidTooltipLocation(jPDADebugger, styledDocument, n8)) {
                return null;
            }
            String string2 = string.substring(n5, n4);
            if (JAVA_KEYWORDS.contains(string2)) {
                return null;
            }
            while (n4 < n7 && Character.isWhitespace(string.charAt(n4))) {
                ++n4;
            }
            if (n4 < n7 && string.charAt(n4) == '(') {
                blArray[0] = true;
            }
            return string2;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static boolean isValidTooltipLocation(JPDADebugger jPDADebugger, final StyledDocument styledDocument, final int n) {
        CallStackFrame callStackFrame = jPDADebugger.getCurrentCallStackFrame();
        if (callStackFrame == null) {
            return false;
        }
        final boolean[] blArray = new boolean[]{true};
        final String[] stringArray = new String[]{""};
        Future future = null;
        try {
            future = ParserManager.parseWhenScanFinished(Collections.singleton(Source.create((Document)styledDocument)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Object object2;
                    ExpressionTree expressionTree;
                    Parser.Result result = resultIterator.getParserResult(n);
                    if (result == null) {
                        return;
                    }
                    CompilationController compilationController = CompilationController.get((Parser.Result)result);
                    if (compilationController == null || compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreeUtilities treeUtilities = compilationController.getTreeUtilities();
                    SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                    TreePath treePath = treeUtilities.pathFor(n);
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    if ((long)n >= sourcePositions.getStartPosition(compilationUnitTree, expressionTree = compilationUnitTree.getPackageName()) && (long)n <= sourcePositions.getEndPosition(compilationUnitTree, expressionTree)) {
                        blArray[0] = false;
                        return;
                    }
                    Tree tree = treePath.getLeaf();
                    Tree.Kind kind = tree.getKind();
                    if (kind == Tree.Kind.STRING_LITERAL) {
                        blArray[0] = false;
                        return;
                    }
                    int n6 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                    int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                    int n3 = Utilities.getLineOffset((BaseDocument)((BaseDocument)styledDocument), (int)n6);
                    int n4 = Utilities.getLineOffset((BaseDocument)((BaseDocument)styledDocument), (int)n2);
                    int n5 = Utilities.getLineOffset((BaseDocument)((BaseDocument)styledDocument), (int)n);
                    if (kind != Tree.Kind.VARIABLE && (n3 != n5 || n4 != n5)) {
                        blArray[0] = false;
                        return;
                    }
                    for (Object object2 : treeUtilities.getComments(tree, true)) {
                        if (object2.pos() < 0 || object2.pos() > n || n > object2.endPos()) continue;
                        blArray[0] = false;
                        return;
                    }
                    Object object3 = treeUtilities.getComments(tree, false).iterator();
                    while (object3.hasNext()) {
                        object2 = (Comment)object3.next();
                        if (object2.pos() < 0 || object2.pos() > n || n > object2.endPos()) continue;
                        blArray[0] = false;
                        return;
                    }
                    for (object3 = treePath; object3 != null; object3 = ((TreePath)object3).getParentPath()) {
                        tree = ((TreePath)object3).getLeaf();
                        kind = tree.getKind();
                        if (kind == Tree.Kind.IMPORT) {
                            blArray[0] = false;
                            return;
                        }
                        if (kind != Tree.Kind.CLASS || stringArray[0].length() != 0) continue;
                        object2 = (TypeElement)compilationController.getTrees().getElement((TreePath)object3);
                        stringArray[0] = object2.getQualifiedName().toString();
                    }
                }
            });
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        future.cancel(false);
        if (!blArray[0]) {
            return false;
        }
        if (stringArray[0].length() > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            This this_ = callStackFrame.getThisVariable();
            if (this_ != null) {
                String string = this_.getType();
                int n2 = string.lastIndexOf(36);
                while (n2 >= 0 && n2 < string.length() - 1 && Character.isDigit(string.charAt(n2 + 1))) {
                    string = string.substring(0, n2);
                    n2 = string.lastIndexOf(36);
                }
                hashSet.add(string.replace('$', '.'));
                for (Super super_ = this_.getSuper(); super_ != null; super_ = super_.getSuper()) {
                    string = super_.getType().replace('$', '.');
                    hashSet.add(string);
                }
            } else {
                hashSet.add(callStackFrame.getClassName());
            }
            if (!hashSet.contains(stringArray[0])) {
                return false;
            }
        }
        return true;
    }

    private String resolveTypeName(final int n, Document document) {
        final String[] stringArray = new String[]{null};
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)document)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult(n);
                    if (result == null) {
                        return;
                    }
                    CompilationController compilationController = CompilationController.get((Parser.Result)result);
                    if (compilationController == null || compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                    javax.lang.model.element.Element element = compilationController.getTrees().getElement(treePath);
                    ElementKind elementKind = element.getKind();
                    if (elementKind == ElementKind.CLASS || elementKind == ElementKind.ENUM || elementKind == ElementKind.ANNOTATION_TYPE) {
                        stringArray[0] = ((Object)element.asType()).toString();
                    }
                }
            });
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return stringArray[0];
    }
}

