/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.debugger.jpda.projects.FixActionProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SourcePathProviderImpl
extends SourcePathProvider {
    private static boolean verbose = System.getProperty("netbeans.debugger.sourcepathproviderimpl") != null;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.projects");
    private static final Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
    private static final Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
    private ClassPath originalSourcePath;
    private Set<String> additionalSourceRoots;
    private ClassPath smartSteppingSourcePath;
    private String[] projectSourceRoots;
    private ClassPath unorderedOriginalSourcePath;
    private int[] sourcePathPermutation;
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private PathRegistryListener pathRegistryListener;
    private File baseDir;
    private static boolean CAN_FIX_CLASSES_AUTOMATICALLY = Boolean.getBoolean("debugger.apply-code-changes.on-save");

    public SourcePathProviderImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourcePathProviderImpl(ContextProvider contextProvider) {
        List<FileObject> list;
        Object object;
        Object object2;
        String[] stringArray;
        String[] stringArray2;
        Object object5;
        Object object6;
        JPDADebugger jPDADebugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        HashSet<FileObject> hashSet = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Have properties = " + map);
        }
        if (map != null) {
            this.baseDir = (File)map.get("baseDir");
            this.smartSteppingSourcePath = (ClassPath)map.get("sourcepath");
            object6 = (ClassPath)map.get("jdksources");
            if (object6 == null && JavaPlatform.getDefault() != null) {
                object6 = JavaPlatform.getDefault().getSourceFolders();
            }
            if (this.baseDir != null) {
                object5 = this.getAdditionalClassPath(this.baseDir);
            } else {
                object5 = null;
                Exceptions.printStackTrace((Throwable)new NullPointerException("No base directory is defined. Properties = " + map));
            }
            if (object5 != null) {
                this.smartSteppingSourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.smartSteppingSourcePath, object5});
            }
            this.unorderedOriginalSourcePath = this.smartSteppingSourcePath = object6 == null ? this.smartSteppingSourcePath : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{object6, this.smartSteppingSourcePath});
            Map<String, Integer> object42 = SourcePathProviderImpl.getSourceRootsOrder(this.baseDir);
            stringArray2 = this.getSourceRoots(this.unorderedOriginalSourcePath);
            stringArray = new String[stringArray2.length];
            this.sourcePathPermutation = SourcePathProviderImpl.createPermutation(stringArray2, object42, stringArray);
            this.originalSourcePath = this.smartSteppingSourcePath = this.createClassPath(stringArray);
            object2 = this.baseDir != null ? this.getDisabledSourceRoots(this.baseDir) : null;
            if (object2 != null && !object2.isEmpty()) {
                object = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
                for (String[] stringArray3 : new HashSet(object)) {
                    if (!object2.contains(SourcePathProviderImpl.getRoot((FileObject)stringArray3))) continue;
                    object.remove(stringArray3);
                }
                this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])object.toArray(new FileObject[0]));
            }
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
            object = new HashSet();
            object.addAll(Arrays.asList(this.originalSourcePath.getRoots()));
            list = (String)map.get("listeningCP");
            if (list != null) {
                for (String string : ((String)((Object)list)).split(File.pathSeparator)) {
                    logger.log(Level.FINE, "Listening cp = '" + string + "'");
                    File file2 = new File(string);
                    file2 = FileUtil.normalizeFile((File)file2);
                    URL uRL = FileUtil.urlForArchiveOrDir((File)file2);
                    if (uRL == null) continue;
                    hashSet = new HashSet();
                    for (FileObject fileObject : SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots()) {
                        hashSet.add(fileObject);
                    }
                }
            }
        } else {
            String[] stringArray3;
            object6 = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
            this.pathRegistryListener = new PathRegistryListener((RequestProcessor)object6);
            GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.pathRegistryListener, (Object)GlobalPathRegistry.getDefault()));
            JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pathRegistryListener, (Object)JavaPlatformManager.getDefault()));
            object5 = new ArrayList();
            HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
            stringArray2 = new HashSet();
            stringArray = OpenProjects.getDefault().getMainProject();
            if (stringArray != null) {
                for (SourceGroup sourceGroup : object2 = ProjectUtils.getSources((Project)stringArray).getSourceGroups("java")) {
                    FileObject[] fileObjectArray;
                    ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/execute");
                    if (classPath == null) {
                        classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/source");
                    }
                    if (classPath == null) continue;
                    for (FileObject fileObject : fileObjectArray = classPath.getRoots()) {
                        if (stringArray2.contains(fileObject)) continue;
                        stringArray2.add(fileObject);
                        try {
                            FileObject fileObject2;
                            for (FileObject fileObject3 : fileObject2 = SourceForBinaryQuery.findSourceRoots((URL)fileObject.getURL()).getRoots()) {
                                if (hashSet2.contains(fileObject3)) continue;
                                object5.add(fileObject3);
                                hashSet2.add(fileObject3);
                            }
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                        }
                    }
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SourcePathProviderImpl: preferred source roots = " + hashSet2 + ")");
            }
            object2 = new TreeSet<FileObject>(new FileObjectComparator());
            object2.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            object = object2.iterator();
            while (object.hasNext()) {
                FileObject fileObject = (FileObject)object.next();
                if (hashSet2.contains(fileObject)) continue;
                object5.add(fileObject);
            }
            object = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < ((Object)object).length; ++i) {
                FileObject[] fileObjectArray = object[i].getSourceFolders().getRoots();
                int n = fileObjectArray.length;
                for (int j = 0; j < n; ++j) {
                    if (object5.contains(fileObjectArray[j])) continue;
                    object5.add(fileObjectArray[j]);
                }
            }
            list = this.getAdditionalRemoteClassPath();
            if (list != null) {
                object5.addAll(list);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SourcePathProviderImpl: GlobalPathRegistry roots = " + GlobalPathRegistry.getDefault().getSourceRoots() + ")");
                logger.fine("Platform roots:");
                for (int i = 0; i < ((Object)object).length; ++i) {
                    logger.fine(" " + Arrays.asList(object[i].getSourceFolders().getRoots()).toString());
                }
                logger.fine("SourcePathProviderImpl: all source roots = " + object5 + ")");
            }
            stringArray3 = this.getRemoteDisabledSourceRoots();
            SourcePathProviderImpl sourcePathProviderImpl = this;
            synchronized (sourcePathProviderImpl) {
                this.unorderedOriginalSourcePath = ClassPathSupport.createClassPath((FileObject[])object5.toArray(new FileObject[object5.size()]));
                Map<String, Integer> map2 = SourcePathProviderImpl.getRemoteSourceRootsOrder();
                String[] stringArray4 = this.getSourceRoots(this.unorderedOriginalSourcePath);
                String[] stringArray5 = new String[stringArray4.length];
                this.sourcePathPermutation = SourcePathProviderImpl.createPermutation(stringArray4, map2, stringArray5);
                this.originalSourcePath = this.createClassPath(stringArray5);
                this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
                hashSet = new HashSet<FileObject>((Collection<FileObject>)object5);
                this.smartSteppingSourcePath = this.originalSourcePath;
                if (stringArray3 != null && !stringArray3.isEmpty()) {
                    ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
                    for (FileObject fileObject : new HashSet<FileObject>(arrayList)) {
                        if (!stringArray3.contains(SourcePathProviderImpl.getRoot(fileObject))) continue;
                        arrayList.remove(fileObject);
                    }
                    this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
                }
            }
        }
        if (verbose) {
            System.out.println("SPPI: init originalSourcePath " + this.originalSourcePath);
        }
        if (verbose) {
            System.out.println("SPPI: init smartSteppingSourcePath " + this.smartSteppingSourcePath);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("new SourcePathProviderImpl(): contextProvider = " + contextProvider + ", properties = " + map + ", srcRootsToListenForArtifactsUpdates = " + hashSet);
        }
        if (hashSet != null) {
            object6 = new HashSet();
            for (FileObject fileObject : hashSet) {
                try {
                    object6.add(this.addArtifactsUpdateListenerFor(jPDADebugger, fileObject));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
            jPDADebugger.addPropertyChangeListener("state", new PropertyChangeListener((Set)object6){
                final /* synthetic */ Set val$artifactsListeners;
                {
                    this.val$artifactsListeners = set;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (4 == (Integer)propertyChangeEvent.getNewValue()) {
                        for (ArtifactsUpdatedImpl artifactsUpdatedImpl : this.val$artifactsListeners) {
                            BuildArtifactMapper.removeArtifactsUpdatedListener((URL)artifactsUpdatedImpl.getURL(), (BuildArtifactMapper.ArtifactsUpdated)artifactsUpdatedImpl);
                        }
                    }
                }
            });
        }
    }

    private ClassPath getAdditionalClassPath(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
            List list = (List)properties.getProperties("additional_source_roots").getMap("project", Collections.emptyMap()).get(string);
            if (list == null || list.isEmpty()) {
                return null;
            }
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(list.size());
            for (String string2 : list) {
                FileObject fileObject = this.getFileObject(string2);
                if (fileObject == null || !fileObject.canRead()) continue;
                arrayList.add(fileObject);
            }
            this.additionalSourceRoots = new LinkedHashSet<String>(list);
            return ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private List<FileObject> getAdditionalRemoteClassPath() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        List list = (List)properties.getProperties("additional_source_roots").getCollection("src_roots", Collections.emptyList());
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(list.size());
        for (String string : list) {
            FileObject fileObject = this.getFileObject(string);
            if (fileObject == null || !fileObject.canRead()) continue;
            arrayList.add(fileObject);
        }
        this.additionalSourceRoots = new LinkedHashSet<String>(list);
        return arrayList;
    }

    private void storeAdditionalSourceRoots() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (this.baseDir != null) {
            String string;
            try {
                string = this.baseDir.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return;
            }
            Map map = properties.getProperties("additional_source_roots").getMap("project", new HashMap());
            if (this.additionalSourceRoots != null) {
                map.put(string, new ArrayList<String>(this.additionalSourceRoots));
            } else {
                map.remove(string);
            }
            properties.getProperties("additional_source_roots").setMap("project", map);
        } else if (this.additionalSourceRoots != null) {
            properties.getProperties("additional_source_roots").setCollection("src_roots", new ArrayList<String>(this.additionalSourceRoots));
        } else {
            properties.getProperties("additional_source_roots").setCollection("src_roots", null);
        }
    }

    private Set<String> getDisabledSourceRoots(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
            return (Set)properties.getProperties("source_roots").getMap("project_disabled", Collections.emptyMap()).get(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private Set<String> getRemoteDisabledSourceRoots() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return (Set)properties.getProperties("source_roots").getCollection("remote_disabled", Collections.emptySet());
    }

    private void storeDisabledSourceRoots(Set<String> set) {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (this.baseDir != null) {
            String string;
            try {
                string = this.baseDir.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return;
            }
            Map map = properties.getProperties("source_roots").getMap("project_disabled", new HashMap());
            map.put(string, set);
            properties.getProperties("source_roots").setMap("project_disabled", map);
        } else {
            properties.getProperties("source_roots").setCollection("remote_disabled", set);
        }
    }

    private static Map<String, Integer> getSourceRootsOrder(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            return SourcePathProviderImpl.getSourceRootsOrder(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    static Map<String, Integer> getSourceRootsOrder(String string) {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return (Map)properties.getProperties("source_roots").getMap("project_order", Collections.emptyMap()).get(string);
    }

    static Map<String, Integer> getRemoteSourceRootsOrder() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return properties.getProperties("source_roots").getMap("remote_order", Collections.emptyMap());
    }

    private static void storeSourceRootsOrder(File file, String[] stringArray, int[] nArray) {
        String string;
        if (file != null) {
            try {
                string = file.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return;
            }
        } else {
            string = null;
        }
        SourcePathProviderImpl.storeSourceRootsOrder(string, stringArray, nArray);
    }

    static void storeSourceRootsOrder(String string, String[] stringArray, int[] nArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException("Incompatible array length: roots = " + stringArray.length + ", permutation = " + nArray.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[nArray[i]], i);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.storeSourceRootsOrder():");
            logger.fine("  sourceOrder = " + hashMap);
        }
        SourcePathProviderImpl.storeSourceRootsOrder(string, hashMap);
    }

    private static void storeSourceRootsOrder(String string, Map<String, Integer> map) {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (string != null) {
            Map map2 = properties.getProperties("source_roots").getMap("project_order", new HashMap());
            map2.put(string, map);
            properties.getProperties("source_roots").setMap("project_order", map2);
        } else {
            properties.getProperties("source_roots").setMap("remote_order", map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(String string, boolean bl) {
        FileObject fileObject;
        if (verbose) {
            System.out.println("SPPI: getURL " + string + " global " + bl);
        }
        string = SourcePathProviderImpl.normalize(string);
        ClassPath classPath = null;
        ClassPath classPath2 = null;
        SourcePathProviderImpl sourcePathProviderImpl = this;
        synchronized (sourcePathProviderImpl) {
            if (this.originalSourcePath != null) {
                classPath = this.smartSteppingSourcePath;
                classPath2 = this.originalSourcePath;
            }
        }
        if (classPath != null) {
            fileObject = classPath.findResource(string);
            if (fileObject == null && bl) {
                fileObject = classPath2.findResource(string);
            }
            if (fileObject == null && bl) {
                fileObject = GlobalPathRegistry.getDefault().findResource(string);
            }
        } else {
            fileObject = GlobalPathRegistry.getDefault().findResource(string);
        }
        if (verbose) {
            System.out.println("SPPI:   fo " + fileObject);
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return fileObject.getURL().toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            if (verbose) {
                System.out.println("SPPI:   FileStateInvalidException");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllURLs(String string, boolean bl) {
        Object object;
        List list;
        if (verbose) {
            System.out.println("SPPI: getURL " + string + " global " + bl);
        }
        string = SourcePathProviderImpl.normalize(string);
        if (this.originalSourcePath == null) {
            list = new ArrayList();
            for (Object object2 : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                list.addAll(object2.findAllResources(string));
            }
        } else {
            object = this;
            synchronized (object) {
                if (!bl) {
                    list = this.smartSteppingSourcePath.findAllResources(string);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + list);
                    }
                } else {
                    list = this.originalSourcePath.findAllResources(string);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + list);
                    }
                }
            }
        }
        object = new ArrayList(list.size());
        for (FileObject fileObject : list) {
            try {
                object.add(fileObject.getURL().toString());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                if (!verbose) continue;
                System.out.println("SPPI:   FileStateInvalidException for " + fileObject);
            }
        }
        return object.toArray(new String[0]);
    }

    public String getRelativePath(String string, char c, boolean bl) {
        FileObject fileObject = null;
        if (verbose) {
            System.out.println("SPPI: getRelativePath " + string);
        }
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (verbose) {
                System.out.println("SPPI:   fo " + fileObject);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        String string2 = this.smartSteppingSourcePath.getResourceName(fileObject, c, bl);
        if (string2 == null) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null) {
                classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            }
            if (classPath == null) {
                return null;
            }
            string2 = classPath.getResourceName(fileObject, c, bl);
        }
        return string2;
    }

    public synchronized String getSourceRoot(String string) {
        FileObject[] fileObjectArray;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            fileObject = null;
        }
        FileObject[] fileObjectArray2 = null;
        if (fileObject != null && fileObject.canRead() && (fileObjectArray = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) != null) {
            fileObjectArray2 = fileObjectArray.getRoots();
        }
        if (fileObjectArray2 == null) {
            fileObjectArray2 = this.originalSourcePath.getRoots();
        }
        for (FileObject fileObject2 : fileObjectArray2) {
            try {
                String string2;
                String string3 = fileObject2.getURL().toString();
                if (!string.startsWith(string3) || (string2 = SourcePathProviderImpl.getRoot(fileObject2)) == null) continue;
                return string2;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return null;
    }

    private String[] getSourceRoots(ClassPath classPath) {
        FileObject[] fileObjectArray = classPath.getRoots();
        ArrayList<String> arrayList = new ArrayList<String>(fileObjectArray.length);
        for (FileObject fileObject : fileObjectArray) {
            String string = SourcePathProviderImpl.getRoot(fileObject);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public synchronized String[] getOriginalSourceRoots() {
        return this.getSourceRoots(this.originalSourcePath);
    }

    public synchronized String[] getSourceRoots() {
        return this.getSourceRoots(this.smartSteppingSourcePath);
    }

    synchronized Set<FileObject> getSourceRootsFO() {
        return new HashSet<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
    }

    public String[] getProjectSourceRoots() {
        return this.projectSourceRoots;
    }

    public synchronized String[] getAdditionalSourceRoots() {
        return this.additionalSourceRoots == null ? new String[]{} : this.additionalSourceRoots.toArray(new String[0]);
    }

    public synchronized void reorderOriginalSourceRoots(int[] nArray) {
        String[] stringArray;
        int n;
        String[] stringArray2 = this.getOriginalSourceRoots();
        if (nArray == null) {
            for (n = 0; n < this.sourcePathPermutation.length; ++n) {
                this.sourcePathPermutation[n] = n;
            }
            this.originalSourcePath = this.unorderedOriginalSourcePath;
            stringArray2 = this.getSourceRoots(this.unorderedOriginalSourcePath);
        } else {
            int n2;
            if (stringArray2.length != nArray.length) {
                throw new IllegalArgumentException("Bad length of permutation: " + nArray.length + ", have " + stringArray2.length + " source roots.");
            }
            n = nArray.length;
            stringArray = this.getSourceRoots(this.unorderedOriginalSourcePath);
            String[] stringArray3 = new String[n];
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = this.sourcePathPermutation[nArray[n2]];
                stringArray3[n2] = stringArray[nArray[n2]];
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.sourcePathPermutation[n2] = nArray[n2];
            }
            this.originalSourcePath = this.createClassPath(stringArray3);
            stringArray2 = stringArray;
        }
        this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.getSourceRoots(this.smartSteppingSourcePath)));
        stringArray = new String[hashSet.size()];
        int n3 = 0;
        for (String string : this.projectSourceRoots) {
            if (!hashSet.contains(string)) continue;
            stringArray[n3++] = string;
        }
        this.smartSteppingSourcePath = this.createClassPath(stringArray);
        SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, stringArray2, this.sourcePathPermutation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(String[] stringArray, String[] stringArray2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.setSourceRoots(" + Arrays.asList(stringArray) + ", " + Arrays.asList(stringArray2) + ")");
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        ClassPath[] classPathArray = new ClassPath[]{null};
        ClassPath[] classPathArray2 = new ClassPath[]{null};
        SourcePathProviderImpl sourcePathProviderImpl = this;
        synchronized (sourcePathProviderImpl) {
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(Arrays.asList(stringArray2));
            int n = this.sourcePathPermutation.length;
            Set<String> set = this.setSourceRoots(linkedHashSet, classPathArray, classPathArray2, linkedHashSet2);
            this.storeAdditionalSourceRoots();
            this.storeDisabledSourceRoots(set);
            if (n != this.sourcePathPermutation.length) {
                SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, this.getSourceRoots(this.unorderedOriginalSourcePath), this.sourcePathPermutation);
            }
        }
        if (classPathArray[0] != null) {
            this.pcs.firePropertyChange("sourceRoots", classPathArray[0], classPathArray2[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(String[] stringArray) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.setSourceRoots(" + Arrays.asList(stringArray) + ")");
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        ClassPath[] classPathArray = new ClassPath[]{null};
        ClassPath[] classPathArray2 = new ClassPath[]{null};
        SourcePathProviderImpl sourcePathProviderImpl = this;
        synchronized (sourcePathProviderImpl) {
            int n = this.sourcePathPermutation.length;
            Set<String> set = this.setSourceRoots(linkedHashSet, classPathArray, classPathArray2, null);
            this.storeAdditionalSourceRoots();
            this.storeDisabledSourceRoots(set);
            if (n != this.sourcePathPermutation.length) {
                SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, this.getSourceRoots(this.unorderedOriginalSourcePath), this.sourcePathPermutation);
            }
        }
        if (classPathArray[0] != null) {
            this.pcs.firePropertyChange("sourceRoots", classPathArray[0], classPathArray2[0]);
        }
    }

    private synchronized Set<String> setSourceRoots(Set<String> set, ClassPath[] classPathArray, ClassPath[] classPathArray2, Set<String> set2) {
        Object object;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>(Arrays.asList(this.originalSourcePath.getRoots()));
        ArrayList<FileObject> arrayList3 = new ArrayList<FileObject>(Arrays.asList(this.unorderedOriginalSourcePath.getRoots()));
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(set);
        for (FileObject object42 : arrayList2) {
            linkedHashSet.remove(SourcePathProviderImpl.getRoot(object42));
        }
        if (!linkedHashSet.isEmpty()) {
            for (String string : linkedHashSet) {
                FileObject fileObject = this.getFileObject(string);
                if (fileObject == null || !fileObject.canRead()) continue;
                arrayList2.add(fileObject);
                arrayList3.add(fileObject);
            }
            if (this.additionalSourceRoots == null) {
                this.additionalSourceRoots = new LinkedHashSet<String>();
            }
            this.additionalSourceRoots.addAll(linkedHashSet);
        }
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(set);
        for (FileObject fileObject : arrayList) {
            linkedHashSet2.remove(SourcePathProviderImpl.getRoot(fileObject));
        }
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        for (FileObject fileObject : arrayList) {
            String string = SourcePathProviderImpl.getRoot(fileObject);
            if (set.contains(string)) continue;
            hashSet.add(fileObject);
            if (this.additionalSourceRoots == null || !this.additionalSourceRoots.contains(string) || set2 != null && set2.contains(string)) continue;
            hashSet2.add(fileObject);
            this.additionalSourceRoots.remove(string);
            if (this.additionalSourceRoots.size() != 0) continue;
            this.additionalSourceRoots = null;
        }
        if (!hashSet2.isEmpty()) {
            arrayList2.removeAll(hashSet2);
        }
        if (!linkedHashSet.isEmpty() || !hashSet2.isEmpty()) {
            for (FileObject fileObject : hashSet2) {
                int n;
                int n2 = arrayList3.indexOf(fileObject);
                arrayList3.remove(n2);
                int n3 = this.sourcePathPermutation[n2];
                for (n = 0; n < this.sourcePathPermutation.length; ++n) {
                    if (this.sourcePathPermutation[n] <= n3) continue;
                    int n4 = n;
                    this.sourcePathPermutation[n4] = this.sourcePathPermutation[n4] - 1;
                }
                for (n = n2; n < this.sourcePathPermutation.length - 1; ++n) {
                    this.sourcePathPermutation[n] = this.sourcePathPermutation[n + 1];
                }
            }
            int n = this.sourcePathPermutation.length - hashSet2.size() + linkedHashSet.size();
            int[] nArray = new int[n];
            System.arraycopy(this.sourcePathPermutation, 0, nArray, 0, this.sourcePathPermutation.length - hashSet2.size());
            for (int i = this.sourcePathPermutation.length - hashSet2.size(); i < n; ++i) {
                nArray[i] = i;
            }
            this.sourcePathPermutation = nArray;
            this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList2.toArray(new FileObject[0]));
            this.unorderedOriginalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList3.toArray(new FileObject[0]));
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
        }
        if (linkedHashSet2.size() > 0 || hashSet.size() > 0) {
            object = linkedHashSet2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                FileObject fileObject = this.getFileObject(string);
                if (fileObject == null || !fileObject.canRead()) continue;
                arrayList.add(fileObject);
            }
            arrayList.removeAll(hashSet);
            classPathArray[0] = this.smartSteppingSourcePath;
            classPathArray2[0] = this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
        }
        object = new HashSet<FileObject>(arrayList2);
        object.removeAll(arrayList);
        HashSet<String> hashSet3 = new HashSet<String>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            hashSet3.add(SourcePathProviderImpl.getRoot(fileObject));
        }
        return hashSet3;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static String normalize(String string) {
        Matcher matcher = thisDirectoryPattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$1");
            matcher = thisDirectoryPattern.matcher(string);
        }
        matcher = parentDirectoryPattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).equals("..")) continue;
            string = string.substring(0, matcher.start()) + matcher.group(1) + string.substring(matcher.end());
            matcher = parentDirectoryPattern.matcher(string);
        }
        return string;
    }

    static String getRoot(FileObject fileObject) {
        File file = null;
        String string = "";
        try {
            if (fileObject.getFileSystem() instanceof JarFileSystem) {
                file = ((JarFileSystem)fileObject.getFileSystem()).getJarFile();
                if (!fileObject.isRoot()) {
                    string = "!/" + fileObject.getPath();
                }
            } else {
                file = FileUtil.toFile((FileObject)fileObject);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        if (file != null) {
            return file.getAbsolutePath() + string;
        }
        return null;
    }

    private FileObject getFileObject(String string) {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        String string2 = null;
        if (fileObject == null && string.contains("!/")) {
            int n = string.indexOf("!/");
            file = new File(string.substring(0, n));
            fileObject = FileUtil.toFileObject((File)file);
            string2 = string.substring(n + "!/".length());
        }
        if (fileObject != null && FileUtil.isArchiveFile((FileObject)fileObject)) {
            fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            if (string2 != null) {
                fileObject = fileObject.getFileObject(string2);
            }
        }
        return fileObject;
    }

    static int[] createPermutation(String[] stringArray, Map<String, Integer> map, String[] stringArray2) {
        int n = stringArray.length;
        if (map == null) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[i];
                nArray[i] = i;
            }
            return nArray;
        }
        class IndexedRoot {
            String root;
            Integer index;
            int order;

            IndexedRoot(String string, Integer n, int n2) {
                this.root = string;
                this.index = n;
                this.order = n2;
            }
        }
        IndexedRoot[] indexedRootArray = new IndexedRoot[n];
        for (int i = 0; i < n; ++i) {
            indexedRootArray[i] = new IndexedRoot(stringArray[i], map.get(stringArray[i]), i);
        }
        class Cmp
        implements Comparator<IndexedRoot> {
            Cmp() {
            }

            @Override
            public int compare(IndexedRoot indexedRoot, IndexedRoot indexedRoot2) {
                Integer n = indexedRoot.index;
                if (n == null) {
                    return 0;
                }
                Integer n2 = indexedRoot2.index;
                if (n2 == null) {
                    return 0;
                }
                return n - n2;
            }
        }
        Cmp cmp = new Cmp();
        Arrays.sort(indexedRootArray, cmp);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = indexedRootArray[i].root;
            nArray[i] = indexedRootArray[i].order;
        }
        return nArray;
    }

    private ClassPath reorder(ClassPath classPath, final Map<String, Integer> map) {
        String[] stringArray = this.getSourceRoots(classPath);
        class Cmp
        implements Comparator<String> {
            Cmp() {
            }

            @Override
            public int compare(String string, String string2) {
                int n = (Integer)map.get(string);
                int n2 = (Integer)map.get(string2);
                return n - n2;
            }
        }
        Cmp cmp = new Cmp();
        Arrays.sort(stringArray, cmp);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(stringArray.length);
        for (String string : stringArray) {
            FileObject fileObject = this.getFileObject(string);
            if (fileObject == null || !fileObject.canRead()) continue;
            arrayList.add(fileObject);
        }
        return ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
    }

    private ClassPath createClassPath(String[] stringArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(stringArray.length);
        for (String string : stringArray) {
            FileObject fileObject = this.getFileObject(string);
            if (fileObject == null || !fileObject.canRead()) continue;
            arrayList.add(fileObject);
        }
        return ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
    }

    private ArtifactsUpdatedImpl addArtifactsUpdateListenerFor(JPDADebugger jPDADebugger, FileObject fileObject) throws FileStateInvalidException {
        URL uRL = fileObject.getURL();
        ArtifactsUpdatedImpl artifactsUpdatedImpl = new ArtifactsUpdatedImpl(jPDADebugger, uRL, fileObject);
        BuildArtifactMapper.addArtifactsUpdatedListener((URL)uRL, (BuildArtifactMapper.ArtifactsUpdated)artifactsUpdatedImpl);
        return artifactsUpdatedImpl;
    }

    static final class FileObjectComparator
    implements Comparator<FileObject> {
        FileObjectComparator() {
        }

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            String string = SourcePathProviderImpl.getRoot(fileObject);
            String string2 = SourcePathProviderImpl.getRoot(fileObject2);
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }

    private class PathRegistryListener
    implements GlobalPathRegistryListener,
    PropertyChangeListener {
        private RequestProcessor rp;

        public PathRegistryListener(RequestProcessor requestProcessor) {
            this.rp = requestProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsAdded(final GlobalPathRegistryEvent globalPathRegistryEvent) {
            if (EventQueue.isDispatchThread()) {
                this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        PathRegistryListener.this.pathsAdded(globalPathRegistryEvent);
                    }
                });
                return;
            }
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (Object object2 : globalPathRegistryEvent.getChangedPaths()) {
                for (FileObject fileObject : object2.getRoots()) {
                    arrayList.add(fileObject);
                }
            }
            if (arrayList.size() > 0) {
                Object object = SourcePathProviderImpl.this;
                synchronized (object) {
                    Object object2;
                    if (SourcePathProviderImpl.this.originalSourcePath == null) {
                        return;
                    }
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                    object2.addAll(arrayList);
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.smartSteppingSourcePath.getRoots()));
                    object2.addAll(arrayList);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsRemoved(final GlobalPathRegistryEvent globalPathRegistryEvent) {
            if (EventQueue.isDispatchThread()) {
                this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        PathRegistryListener.this.pathsRemoved(globalPathRegistryEvent);
                    }
                });
                return;
            }
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (Object object2 : globalPathRegistryEvent.getChangedPaths()) {
                for (FileObject fileObject : object2.getRoots()) {
                    arrayList.add(fileObject);
                }
            }
            if (arrayList.size() > 0) {
                Object object = SourcePathProviderImpl.this;
                synchronized (object) {
                    Object object2;
                    if (SourcePathProviderImpl.this.originalSourcePath == null) {
                        return;
                    }
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                    object2.removeAll(arrayList);
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.smartSteppingSourcePath.getRoots()));
                    object2.removeAll(arrayList);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (EventQueue.isDispatchThread()) {
                this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        PathRegistryListener.this.propertyChange(propertyChangeEvent);
                    }
                });
                return;
            }
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
            boolean bl = false;
            SourcePathProviderImpl sourcePathProviderImpl = SourcePathProviderImpl.this;
            synchronized (sourcePathProviderImpl) {
                if (SourcePathProviderImpl.this.originalSourcePath == null) {
                    return;
                }
                ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                for (JavaPlatform javaPlatform : javaPlatformArray) {
                    FileObject[] fileObjectArray;
                    for (FileObject fileObject : fileObjectArray = javaPlatform.getSourceFolders().getRoots()) {
                        if (arrayList.contains(fileObject)) continue;
                        arrayList.add(fileObject);
                        bl = true;
                    }
                }
                if (bl) {
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
                }
            }
            if (bl) {
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }
    }

    private static class ArtifactsUpdatedImpl
    implements BuildArtifactMapper.ArtifactsUpdated {
        private Reference<JPDADebugger> debuggerRef;
        private final URL url;
        private FileObject src;

        public ArtifactsUpdatedImpl(JPDADebugger jPDADebugger, URL uRL, FileObject fileObject) {
            this.debuggerRef = new WeakReference<JPDADebugger>(jPDADebugger);
            this.url = uRL;
            this.src = fileObject;
        }

        public URL getURL() {
            return this.url;
        }

        public void artifactsUpdated(Iterable<File> iterable) {
            String string = null;
            JPDADebugger jPDADebugger = this.debuggerRef.get();
            if (jPDADebugger == null) {
                string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_NoJPDADebugger");
            } else if (!jPDADebugger.canFixClasses()) {
                string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_CanNotFix");
            } else if (jPDADebugger.getState() == 4) {
                string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_NoDebug");
            }
            boolean bl = Properties.getDefault().getProperties("debugger.options.JPDA").getBoolean("ApplyCodeChangesOnSave", CAN_FIX_CLASSES_AUTOMATICALLY);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("artifactsUpdated(" + iterable + ") error = '" + string + "', canFixClasses = " + bl);
            }
            if (string == null) {
                if (!bl) {
                    for (File file : iterable) {
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        if (fileObject == null) continue;
                        String string2 = ArtifactsUpdatedImpl.fileToClassName(fileObject);
                        FixActionProvider.ClassesToReload.getInstance().addClassToReload(jPDADebugger, this.src, string2, fileObject);
                    }
                    return;
                }
                HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>();
                for (File file : iterable) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) continue;
                    String string3 = ArtifactsUpdatedImpl.fileToClassName(fileObject);
                    hashMap.put(string3, fileObject);
                }
                FixActionProvider.reloadClasses(jPDADebugger, hashMap);
            } else {
                BuildArtifactMapper.removeArtifactsUpdatedListener((URL)this.url, (BuildArtifactMapper.ArtifactsUpdated)this);
            }
            if (string != null && bl) {
                FixActionProvider.notifyError(string);
            }
        }

        private static String fileToClassName(FileObject fileObject) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            return classPath.getResourceName(fileObject, '.', false);
        }
    }
}

