/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.DebugScript;
import org.netbeans.modules.php.project.ui.actions.support.RunScript;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

class ConfigActionScript
extends ConfigAction {
    static final ExecutionDescriptor.LineConvertorFactory PHP_LINE_CONVERTOR_FACTORY = new PhpLineConvertorFactory();
    private final FileObject sourceRoot;

    protected ConfigActionScript(PhpProject project) {
        super(project);
        this.sourceRoot = ProjectPropertiesSupport.getSourcesDirectory(project);
        assert (this.sourceRoot != null);
    }

    @Override
    public boolean isValid(boolean indexFileNeeded) {
        boolean valid = true;
        if (indexFileNeeded && !this.isIndexFileValid(this.sourceRoot)) {
            valid = false;
        } else {
            try {
                if (RunAsValidator.validateScriptFields(ProjectPropertiesSupport.getPhpInterpreter(this.project).getProgram(), FileUtil.toFile((FileObject)this.sourceRoot), null, ProjectPropertiesSupport.getArguments(this.project)) != null) {
                    valid = false;
                }
            }
            catch (PhpProgram.InvalidPhpProgramException ex) {
                valid = false;
            }
        }
        if (!valid) {
            this.showCustomizer();
        }
        return valid;
    }

    @Override
    public boolean isRunFileEnabled(Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context, this.sourceRoot);
        return file != null && FileUtils.isPhpFile((FileObject)file);
    }

    @Override
    public boolean isDebugFileEnabled(Lookup context) {
        if (XDebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(context);
    }

    @Override
    public void runProject() {
        new RunScript(new ScriptProvider()).run();
    }

    @Override
    public void debugProject() {
        new DebugScript(new ScriptProvider()).run();
    }

    @Override
    public void runFile(Lookup context) {
        new RunScript(new ScriptProvider(context)).run();
    }

    @Override
    public void debugFile(Lookup context) {
        new DebugScript(new ScriptProvider(context)).run();
    }

    static final class PhpLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        PhpLineConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            LineConvertor[] lineConvertors = new LineConvertor[PhpInterpreter.LINE_PATTERNS.length];
            int i = 0;
            for (Pattern linePattern : PhpInterpreter.LINE_PATTERNS) {
                lineConvertors[i++] = LineConvertors.filePattern(null, (Pattern)linePattern, null, (int)1, (int)2);
            }
            return LineConvertors.proxy((LineConvertor[])lineConvertors);
        }
    }

    private final class ScriptProvider
    implements DebugScript.Provider {
        private final PhpProgram program;
        private final File startFile;

        public ScriptProvider() {
            this(null);
        }

        public ScriptProvider(Lookup context) {
            PhpInterpreter prg = null;
            try {
                prg = ProjectPropertiesSupport.getPhpInterpreter(ConfigActionScript.this.project);
            }
            catch (PhpProgram.InvalidPhpProgramException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            assert (prg.isValid()) : String.format("php program %s must be valid", prg);
            this.program = prg;
            this.startFile = this.getStartFile(context);
        }

        @Override
        public PhpProject getProject() {
            return ConfigActionScript.this.project;
        }

        @Override
        public FileObject getStartFile() {
            assert (this.startFile != null);
            return FileUtil.toFileObject((File)this.startFile);
        }

        @Override
        public ExecutionDescriptor getDescriptor() throws IOException {
            assert (this.startFile != null);
            RunScript.InOutPostRedirector redirector = new RunScript.InOutPostRedirector(this.startFile);
            return PhpProgram.getExecutionDescriptor().frontWindow(PhpOptions.getInstance().isOpenResultInOutputWindow()).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory").outConvertorFactory(PHP_LINE_CONVERTOR_FACTORY).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)redirector).postExecution((Runnable)redirector).charset(Charset.forName(ProjectPropertiesSupport.getEncoding(ConfigActionScript.this.project)));
        }

        @Override
        public ExternalProcessBuilder getProcessBuilder() {
            assert (this.startFile != null);
            ExternalProcessBuilder builder = this.program.getProcessBuilder().addArgument(this.startFile.getName());
            String argProperty = ProjectPropertiesSupport.getArguments(ConfigActionScript.this.project);
            if (StringUtils.hasText((String)argProperty)) {
                for (String argument : Arrays.asList(argProperty.split(" "))) {
                    builder = builder.addArgument(argument);
                }
            }
            builder = builder.workingDirectory(this.startFile.getParentFile());
            return builder;
        }

        @Override
        public String getOutputTabTitle() {
            assert (this.startFile != null);
            return String.format("%s - %s", this.program.getProgram(), this.startFile.getName());
        }

        @Override
        public boolean isValid() {
            return this.program.isValid() && this.startFile != null;
        }

        private File getStartFile(Lookup context) {
            FileObject file = null;
            file = context == null ? CommandUtils.fileForProject(ConfigActionScript.this.project, ConfigActionScript.this.sourceRoot) : CommandUtils.fileForContextOrSelectedNodes(context, ConfigActionScript.this.sourceRoot);
            assert (file != null) : "Start file must be found";
            return FileUtil.toFile((FileObject)file);
        }
    }
}

